/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class AsciiStringDecoder {
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 15;
    public static final int ENCODED_LENGTH = -1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public AsciiStringDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return -1;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 15;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static long lengthNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long lengthMinValue() {
        return 0L;
    }

    public static long lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public long length() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int varDataEncodingOffset() {
        return 4;
    }

    public static int varDataEncodingLength() {
        return -1;
    }

    public static int varDataSinceVersion() {
        return 0;
    }

    public static byte varDataNullValue() {
        return 0;
    }

    public static byte varDataMinValue() {
        return 32;
    }

    public static byte varDataMaxValue() {
        return 126;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("length=");
        builder.append(this.length());
        builder.append('|');
        builder.append(')');
        return builder;
    }
}

