/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;

public final class CharArraySet {
    private final CharArrayWrapper wrapper = new CharArrayWrapper();
    private final Set<CharArrayWrapper> values;

    public CharArraySet(String ... values) {
        this(Arrays.asList(values));
    }

    public CharArraySet(Collection<String> values) {
        this.values = values.stream().map(CharArrayWrapper::new).collect(Collectors.toSet());
    }

    public CharArraySet(CharArraySet other) {
        this.values = other.values.stream().map(CharArrayWrapper::new).collect(Collectors.toSet());
    }

    public boolean contains(char[] value, int length) {
        this.wrapper.wrap(value, length);
        return this.values.contains(this.wrapper);
    }
}

