/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import org.agrona.BufferUtil;
import org.agrona.UnsafeAccess;

public final class MessageTypeEncoding {
    private static final int MESSAGE_TYPE_BITSHIFT = 8;

    public static long packMessageType(String messageType) {
        int length = messageType.length();
        MessageTypeEncoding.checkLength(length);
        long packed = 0L;
        for (int index = 0; index < length; ++index) {
            byte asciiValue = (byte)messageType.charAt(index);
            packed |= (long)(asciiValue << 8 * index);
        }
        return packed;
    }

    public static long packMessageType(char[] messageType, int length) {
        MessageTypeEncoding.checkLength(length);
        long packed = 0L;
        for (int index = 0; index < length; ++index) {
            byte asciiValue = (byte)messageType[index];
            packed |= (long)(asciiValue << 8 * index);
        }
        return packed;
    }

    private static void checkLength(int length) {
        if (length > 8) {
            throw new IllegalArgumentException("Message types longer than 8 are not supported yet");
        }
    }

    public static long packMessageType(byte[] messageType, int offset, int length) {
        return MessageTypeEncoding.packMessageType(messageType, BufferUtil.ARRAY_BASE_OFFSET, offset, length);
    }

    static long packMessageType(byte[] messageType, long baseOffset, int offset, int length) {
        MessageTypeEncoding.checkLength(length);
        if (length == 1) {
            return UnsafeAccess.UNSAFE.getByte(messageType, baseOffset + (long)offset);
        }
        if (length == 2) {
            return UnsafeAccess.UNSAFE.getShort(messageType, baseOffset + (long)offset);
        }
        long packed = 0L;
        for (int index = 0; index < length; ++index) {
            byte asciiValue = UnsafeAccess.UNSAFE.getByte(messageType, baseOffset + (long)offset + (long)index);
            packed |= (long)(asciiValue << 8 * index);
        }
        return packed;
    }
}

