/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.ilink;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;

public abstract class AbstractILink3Offsets {
    public static final int MISSING_OFFSET = -1;
    static final int NORMAL_CLIENT_MSG_SEQ_NUM_OFFSET = 17;
    static final int PARTY_DETAILS_LIST_REQUEST_SEQ_NUM_OFFSET = 16;
    static final int EXCHANGE_MSG_SEQ_NUM_OFFSET = 0;
    static final int MINIMUM_BUSINESS_MSG_TEMPLATE_ID = 514;
    static final int PARTY_DETAILS_LIST_REQUEST_ID = 537;
    static final int TEMPLATE_ID_OFFSET = 2;

    public static AbstractILink3Offsets make(ErrorHandler errorHandler) {
        try {
            Class<?> cls = Class.forName("uk.co.real_logic.artio.ilink.ILink3Offsets");
            return (AbstractILink3Offsets)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            errorHandler.onError((Throwable)e);
            return null;
        }
    }

    public static long clientSeqNum(DirectBuffer buffer, int sbeHeaderOffset) {
        int templateId = buffer.getShort(sbeHeaderOffset + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        if (templateId < 514) {
            return -1L;
        }
        int messageOffset = sbeHeaderOffset + 8;
        int fieldOffset = AbstractILink3Offsets.clientSeqNumOffset(templateId);
        return AbstractILink3Offsets.seqNum(buffer, messageOffset + fieldOffset);
    }

    public static void clientSeqNum(int templateId, MutableDirectBuffer buffer, int messageOffset, long seqNum) {
        int fieldOffset = AbstractILink3Offsets.clientSeqNumOffset(templateId);
        AbstractILink3Offsets.seqNum(buffer, messageOffset + fieldOffset, seqNum);
    }

    private static int clientSeqNumOffset(int templateId) {
        return templateId == 537 ? 16 : 17;
    }

    public static long exchangeSeqNum(DirectBuffer buffer, int messageOffset) {
        return AbstractILink3Offsets.seqNum(buffer, messageOffset + 0);
    }

    private static long seqNum(DirectBuffer buffer, int index) {
        return (long)buffer.getInt(index, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    private static void seqNum(MutableDirectBuffer buffer, int index, long seqNum) {
        buffer.putInt(index, (int)seqNum, ByteOrder.LITTLE_ENDIAN);
    }

    public abstract int seqNumOffset(int var1);

    public abstract int seqNum(int var1, DirectBuffer var2, int var3);

    public abstract int possRetransOffset(int var1);

    public abstract int possRetrans(int var1, DirectBuffer var2, int var3);

    public abstract int sendingTimeEpochOffset(int var1);
}

