/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.ReplayMessagesDecoder;

public class ReplayMessagesEncoder {
    public static final int BLOCK_LENGTH = 44;
    public static final int TEMPLATE_ID = 53;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 12;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ReplayMessagesEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 44;
    }

    public int sbeTemplateId() {
        return 53;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ReplayMessagesEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 44);
        return this;
    }

    public ReplayMessagesEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(44).templateId(53).schemaId(666).version(12);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReplayMessagesEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionId() {
        return 2;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 4;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public ReplayMessagesEncoder session(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdId() {
        return 3;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 12;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ReplayMessagesEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int replayFromSequenceNumberId() {
        return 4;
    }

    public static int replayFromSequenceNumberSinceVersion() {
        return 0;
    }

    public static int replayFromSequenceNumberEncodingOffset() {
        return 20;
    }

    public static int replayFromSequenceNumberEncodingLength() {
        return 4;
    }

    public static String replayFromSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayFromSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayFromSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int replayFromSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReplayMessagesEncoder replayFromSequenceNumber(int value) {
        this.buffer.putInt(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int replayFromSequenceIndexId() {
        return 5;
    }

    public static int replayFromSequenceIndexSinceVersion() {
        return 0;
    }

    public static int replayFromSequenceIndexEncodingOffset() {
        return 24;
    }

    public static int replayFromSequenceIndexEncodingLength() {
        return 4;
    }

    public static String replayFromSequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayFromSequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayFromSequenceIndexMinValue() {
        return -2147483647;
    }

    public static int replayFromSequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReplayMessagesEncoder replayFromSequenceIndex(int value) {
        this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int replayToSequenceNumberId() {
        return 6;
    }

    public static int replayToSequenceNumberSinceVersion() {
        return 0;
    }

    public static int replayToSequenceNumberEncodingOffset() {
        return 28;
    }

    public static int replayToSequenceNumberEncodingLength() {
        return 4;
    }

    public static String replayToSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayToSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayToSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int replayToSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReplayMessagesEncoder replayToSequenceNumber(int value) {
        this.buffer.putInt(this.offset + 28, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int replayToSequenceIndexId() {
        return 7;
    }

    public static int replayToSequenceIndexSinceVersion() {
        return 0;
    }

    public static int replayToSequenceIndexEncodingOffset() {
        return 32;
    }

    public static int replayToSequenceIndexEncodingLength() {
        return 4;
    }

    public static String replayToSequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayToSequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayToSequenceIndexMinValue() {
        return -2147483647;
    }

    public static int replayToSequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReplayMessagesEncoder replayToSequenceIndex(int value) {
        this.buffer.putInt(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int latestReplyArrivalTimeInMsId() {
        return 8;
    }

    public static int latestReplyArrivalTimeInMsSinceVersion() {
        return 0;
    }

    public static int latestReplyArrivalTimeInMsEncodingOffset() {
        return 36;
    }

    public static int latestReplyArrivalTimeInMsEncodingLength() {
        return 8;
    }

    public static String latestReplyArrivalTimeInMsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long latestReplyArrivalTimeInMsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long latestReplyArrivalTimeInMsMinValue() {
        return -9223372036854775807L;
    }

    public static long latestReplyArrivalTimeInMsMaxValue() {
        return Long.MAX_VALUE;
    }

    public ReplayMessagesEncoder latestReplyArrivalTimeInMs(long value) {
        this.buffer.putLong(this.offset + 36, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ReplayMessagesDecoder decoder = new ReplayMessagesDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 44, 12);
        return decoder.appendTo(builder);
    }
}

