/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.MetaAttribute;

public class LibraryExtendPositionDecoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 60;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 12;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LibraryExtendPositionDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int initialOffset;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 60;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public LibraryExtendPositionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 4;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionIdId() {
        return 3;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 12;
    }

    public static int sessionIdEncodingLength() {
        return 4;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sessionIdMinValue() {
        return -2147483647;
    }

    public static int sessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int stopPositionId() {
        return 4;
    }

    public static int stopPositionSinceVersion() {
        return 0;
    }

    public static int stopPositionEncodingOffset() {
        return 16;
    }

    public static int stopPositionEncodingLength() {
        return 8;
    }

    public static String stopPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long stopPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long stopPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long stopPosition() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int initialTermIdId() {
        return 5;
    }

    public static int initialTermIdSinceVersion() {
        return 0;
    }

    public static int initialTermIdEncodingOffset() {
        return 24;
    }

    public static int initialTermIdEncodingLength() {
        return 4;
    }

    public static String initialTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int initialTermIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int initialTermIdMinValue() {
        return -2147483647;
    }

    public static int initialTermIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int initialTermId() {
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int termBufferLengthId() {
        return 6;
    }

    public static int termBufferLengthSinceVersion() {
        return 0;
    }

    public static int termBufferLengthEncodingOffset() {
        return 28;
    }

    public static int termBufferLengthEncodingLength() {
        return 4;
    }

    public static String termBufferLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int termBufferLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int termBufferLengthMinValue() {
        return -2147483647;
    }

    public static int termBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int termBufferLength() {
        return this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
    }

    public static int mtuLengthId() {
        return 7;
    }

    public static int mtuLengthSinceVersion() {
        return 0;
    }

    public static int mtuLengthEncodingOffset() {
        return 32;
    }

    public static int mtuLengthEncodingLength() {
        return 4;
    }

    public static String mtuLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int mtuLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int mtuLengthMinValue() {
        return -2147483647;
    }

    public static int mtuLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int mtuLength() {
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        LibraryExtendPositionDecoder decoder = new LibraryExtendPositionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[LibraryExtendPosition](sbeTemplateId=");
        builder.append(60);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 36) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(36);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("stopPosition=");
        builder.append(this.stopPosition());
        builder.append('|');
        builder.append("initialTermId=");
        builder.append(this.initialTermId());
        builder.append('|');
        builder.append("termBufferLength=");
        builder.append(this.termBufferLength());
        builder.append('|');
        builder.append("mtuLength=");
        builder.append(this.mtuLength());
        this.limit(originalLimit);
        return builder;
    }
}

