/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.MetaAttribute;

public class FixMessageEncoder {
    public static final int BLOCK_LENGTH = 57;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 9;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final FixMessageEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int initialOffset;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 57;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 9;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public FixMessageEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 57);
        return this;
    }

    public FixMessageEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(57).templateId(1).schemaId(666).version(9);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int deprecatedMessageTypeId() {
        return 1;
    }

    public static int deprecatedMessageTypeSinceVersion() {
        return 0;
    }

    public static int deprecatedMessageTypeEncodingOffset() {
        return 0;
    }

    public static int deprecatedMessageTypeEncodingLength() {
        return 4;
    }

    public static String deprecatedMessageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int deprecatedMessageTypeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int deprecatedMessageTypeMinValue() {
        return -2147483647;
    }

    public static int deprecatedMessageTypeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FixMessageEncoder deprecatedMessageType(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionId() {
        return 2;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 4;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public FixMessageEncoder session(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int connectionId() {
        return 3;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 12;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public FixMessageEncoder connection(long value) {
        this.buffer.putLong(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int timestampId() {
        return 4;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 20;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public FixMessageEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int statusId() {
        return 5;
    }

    public static int statusSinceVersion() {
        return 0;
    }

    public static int statusEncodingOffset() {
        return 28;
    }

    public static int statusEncodingLength() {
        return 1;
    }

    public static String statusMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public FixMessageEncoder status(MessageStatus value) {
        this.buffer.putByte(this.offset + 28, (byte)value.value());
        return this;
    }

    public static int libraryIdId() {
        return 6;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 29;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FixMessageEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 29, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int bytesSentId() {
        return 7;
    }

    public static int bytesSentSinceVersion() {
        return 0;
    }

    public static int bytesSentEncodingOffset() {
        return 33;
    }

    public static int bytesSentEncodingLength() {
        return 4;
    }

    public static String bytesSentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int bytesSentNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int bytesSentMinValue() {
        return -2147483647;
    }

    public static int bytesSentMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FixMessageEncoder bytesSent(int value) {
        this.buffer.putInt(this.offset + 33, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sequenceIndexId() {
        return 8;
    }

    public static int sequenceIndexSinceVersion() {
        return 0;
    }

    public static int sequenceIndexEncodingOffset() {
        return 37;
    }

    public static int sequenceIndexEncodingLength() {
        return 4;
    }

    public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceIndexMinValue() {
        return -2147483647;
    }

    public static int sequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FixMessageEncoder sequenceIndex(int value) {
        this.buffer.putInt(this.offset + 37, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int metaDataUpdateOffsetId() {
        return 13;
    }

    public static int metaDataUpdateOffsetSinceVersion() {
        return 0;
    }

    public static int metaDataUpdateOffsetEncodingOffset() {
        return 41;
    }

    public static int metaDataUpdateOffsetEncodingLength() {
        return 4;
    }

    public static String metaDataUpdateOffsetMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int metaDataUpdateOffsetNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int metaDataUpdateOffsetMinValue() {
        return -2147483647;
    }

    public static int metaDataUpdateOffsetMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FixMessageEncoder metaDataUpdateOffset(int value) {
        this.buffer.putInt(this.offset + 41, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sequenceNumberId() {
        return 9;
    }

    public static int sequenceNumberSinceVersion() {
        return 0;
    }

    public static int sequenceNumberEncodingOffset() {
        return 45;
    }

    public static int sequenceNumberEncodingLength() {
        return 4;
    }

    public static String sequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceNumberMinValue() {
        return -2147483647;
    }

    public static int sequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FixMessageEncoder sequenceNumber(int value) {
        this.buffer.putInt(this.offset + 45, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int messageTypeId() {
        return 11;
    }

    public static int messageTypeSinceVersion() {
        return 3;
    }

    public static int messageTypeEncodingOffset() {
        return 49;
    }

    public static int messageTypeEncodingLength() {
        return 8;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long messageTypeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long messageTypeMinValue() {
        return -9223372036854775807L;
    }

    public static long messageTypeMaxValue() {
        return Long.MAX_VALUE;
    }

    public FixMessageEncoder messageType(long value) {
        this.buffer.putLong(this.offset + 49, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int metaDataId() {
        return 12;
    }

    public static String metaDataCharacterEncoding() {
        return "UTF-8";
    }

    public static String metaDataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int metaDataHeaderLength() {
        return 2;
    }

    public FixMessageEncoder putMetaData(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FixMessageEncoder putMetaData(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FixMessageEncoder metaData(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int bodyId() {
        return 10;
    }

    public static String bodyCharacterEncoding() {
        return "US-ASCII";
    }

    public static String bodyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int bodyHeaderLength() {
        return 2;
    }

    public FixMessageEncoder putBody(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FixMessageEncoder putBody(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FixMessageEncoder body(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 2, value);
        return this;
    }

    public FixMessageEncoder body(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i) {
            char charValue = value.charAt(i);
            byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
            this.buffer.putByte(limit + 2 + i, byteValue);
        }
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        FixMessageDecoder writer = new FixMessageDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.initialOffset, 57, 9);
        return writer.appendTo(builder);
    }
}

