/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.AsciiStringDecoder;

public class AsciiStringEncoder {
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 9;
    public static final int ENCODED_LENGTH = -1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public AsciiStringEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return -1;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 9;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 2;
    }

    public static int lengthNullValue() {
        return 65535;
    }

    public static int lengthMinValue() {
        return 0;
    }

    public static int lengthMaxValue() {
        return 65534;
    }

    public AsciiStringEncoder length(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int varDataEncodingOffset() {
        return 2;
    }

    public static int varDataEncodingLength() {
        return -1;
    }

    public static byte varDataNullValue() {
        return 0;
    }

    public static byte varDataMinValue() {
        return 32;
    }

    public static byte varDataMaxValue() {
        return 126;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        AsciiStringDecoder writer = new AsciiStringDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset);
        return writer.appendTo(builder);
    }
}

