/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.nio.charset.StandardCharsets;
import org.agrona.MutableDirectBuffer;

public final class CodecUtil {
    public static final byte[] BODY_LENGTH = "9=0000\u0001".getBytes(StandardCharsets.US_ASCII);
    public static final int MISSING_INT = Integer.MIN_VALUE;
    public static final char MISSING_CHAR = '\u0001';
    public static final long MISSING_LONG = Long.MIN_VALUE;
    public static final char ENUM_MISSING_CHAR = '\u0001';
    public static final int ENUM_MISSING_INT = Integer.MIN_VALUE;
    public static final String ENUM_MISSING_STRING = Character.toString('\u0001');
    public static final char ENUM_UNKNOWN_CHAR = '\u0002';
    public static final int ENUM_UNKNOWN_INT = Integer.MAX_VALUE;
    public static final String ENUM_UNKNOWN_STRING = Character.toString('\u0002');
    private static final char[] WHITESPACE = "                                                         ".toCharArray();

    private CodecUtil() {
    }

    @Deprecated
    public static byte[] toBytes(CharSequence value, byte[] oldBuffer) {
        int length = value.length();
        byte[] buffer = oldBuffer.length < length ? new byte[length] : oldBuffer;
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)value.charAt(i);
        }
        return buffer;
    }

    @Deprecated
    public static byte[] toBytes(char[] value, byte[] oldBuffer, int length) {
        return CodecUtil.toBytes(value, oldBuffer, 0, length);
    }

    @Deprecated
    public static byte[] toBytes(char[] value, byte[] oldBuffer, int offset, int length) {
        byte[] buffer = oldBuffer.length < length ? new byte[length] : oldBuffer;
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)value[i + offset];
        }
        return buffer;
    }

    public static byte[] toBytes(char[] value, int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)value[i];
        }
        return buffer;
    }

    public static void toBytes(CharSequence value, MutableDirectBuffer buffer) {
        int length = value.length();
        if (buffer.capacity() < length) {
            buffer.wrap(new byte[length]);
        }
        for (int i = 0; i < length; ++i) {
            buffer.putByte(i, (byte)value.charAt(i));
        }
    }

    public static void toBytes(char[] value, MutableDirectBuffer oldBuffer, int length) {
        CodecUtil.toBytes(value, oldBuffer, 0, length);
    }

    public static void toBytes(char[] value, MutableDirectBuffer buffer, int offset, int length) {
        if (buffer.capacity() < length) {
            buffer.wrap(new byte[length]);
        }
        for (int i = 0; i < length; ++i) {
            buffer.putByte(i, (byte)value[i + offset]);
        }
    }

    public static boolean equals(char[] value, char[] expected, int offset, int expectedOffset, int length) {
        if (value.length < length || expected.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (value[i + offset] == expected[i + expectedOffset]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] value, char[] expected, int length) {
        return CodecUtil.equals(value, expected, 0, 0, length);
    }

    public static boolean equals(char[] value, String expected, int length) {
        if (value.length < length || expected.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (value[i] == expected.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(char[] value, int offset, int length) {
        int result = 1;
        for (int i = offset; i < offset + length; ++i) {
            result = 31 * result + value[i];
        }
        return result;
    }

    public static void indent(StringBuilder builder, int level) {
        int numberOfSpaces = 2 * level;
        char[] whitespace = WHITESPACE;
        if (numberOfSpaces > whitespace.length) {
            for (int i = 0; i < level; ++i) {
                builder.append(whitespace, 0, 2);
            }
        } else {
            builder.append(whitespace, 0, numberOfSpaces);
        }
    }

    public static void appendData(StringBuilder builder, byte[] dataField, int length) {
        for (int i = 0; i < length; ++i) {
            builder.append((char)dataField[i]);
        }
    }

    public static void appendBuffer(StringBuilder builder, MutableDirectBuffer buffer, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            builder.append((char)buffer.getByte(i));
        }
    }
}

