/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;
import uk.co.real_logic.artio.storage.messages.MetaDataRecordDecoder;

public class MetaDataRecordEncoder {
    public static final int BLOCK_LENGTH = 4;
    public static final int TEMPLATE_ID = 29;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 3;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final MetaDataRecordEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int initialOffset;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 4;
    }

    public int sbeTemplateId() {
        return 29;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public MetaDataRecordEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 4);
        return this;
    }

    public MetaDataRecordEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(4).templateId(29).schemaId(666).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int checksumId() {
        return 1;
    }

    public static int checksumSinceVersion() {
        return 0;
    }

    public static int checksumEncodingOffset() {
        return 0;
    }

    public static int checksumEncodingLength() {
        return 4;
    }

    public static String checksumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int checksumNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int checksumMinValue() {
        return -2147483647;
    }

    public static int checksumMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MetaDataRecordEncoder checksum(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int metaDataId() {
        return 2;
    }

    public static String metaDataCharacterEncoding() {
        return "UTF-8";
    }

    public static String metaDataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int metaDataHeaderLength() {
        return 2;
    }

    public MetaDataRecordEncoder putMetaData(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public MetaDataRecordEncoder putMetaData(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public MetaDataRecordEncoder metaData(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        MetaDataRecordDecoder writer = new MetaDataRecordDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.initialOffset, 4, 3);
        return writer.appendTo(builder);
    }
}

