/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.messages.SessionStatus;
import uk.co.real_logic.artio.messages.SlowStatus;

public class ManageSessionDecoder {
    public static final int BLOCK_LENGTH = 77;
    public static final int TEMPLATE_ID = 8;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 2;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ManageSessionDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 77;
    }

    public int sbeTemplateId() {
        return 8;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ManageSessionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int connectionId() {
        return 2;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 4;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long connection() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionId() {
        return 3;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 12;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long session() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastSentSequenceNumberId() {
        return 4;
    }

    public static int lastSentSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastSentSequenceNumberEncodingOffset() {
        return 20;
    }

    public static int lastSentSequenceNumberEncodingLength() {
        return 4;
    }

    public static String lastSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int lastSentSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lastSentSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int lastSentSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int lastSentSequenceNumber() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastReceivedSequenceNumberId() {
        return 5;
    }

    public static int lastReceivedSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastReceivedSequenceNumberEncodingOffset() {
        return 24;
    }

    public static int lastReceivedSequenceNumberEncodingLength() {
        return 4;
    }

    public static String lastReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int lastReceivedSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lastReceivedSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int lastReceivedSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int lastReceivedSequenceNumber() {
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logonTimeId() {
        return 6;
    }

    public static int logonTimeSinceVersion() {
        return 0;
    }

    public static int logonTimeEncodingOffset() {
        return 28;
    }

    public static int logonTimeEncodingLength() {
        return 8;
    }

    public static String logonTimeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long logonTimeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logonTimeMinValue() {
        return -9223372036854775807L;
    }

    public static long logonTimeMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logonTime() {
        return this.buffer.getLong(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionStatusId() {
        return 7;
    }

    public static int sessionStatusSinceVersion() {
        return 0;
    }

    public static int sessionStatusEncodingOffset() {
        return 36;
    }

    public static int sessionStatusEncodingLength() {
        return 1;
    }

    public static String sessionStatusMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public SessionStatus sessionStatus() {
        return SessionStatus.get((short)(this.buffer.getByte(this.offset + 36) & 0xFF));
    }

    public static int slowStatusId() {
        return 8;
    }

    public static int slowStatusSinceVersion() {
        return 0;
    }

    public static int slowStatusEncodingOffset() {
        return 37;
    }

    public static int slowStatusEncodingLength() {
        return 1;
    }

    public static String slowStatusMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public SlowStatus slowStatus() {
        return SlowStatus.get((short)(this.buffer.getByte(this.offset + 37) & 0xFF));
    }

    public static int connectionTypeId() {
        return 9;
    }

    public static int connectionTypeSinceVersion() {
        return 0;
    }

    public static int connectionTypeEncodingOffset() {
        return 38;
    }

    public static int connectionTypeEncodingLength() {
        return 1;
    }

    public static String connectionTypeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public ConnectionType connectionType() {
        return ConnectionType.get((short)(this.buffer.getByte(this.offset + 38) & 0xFF));
    }

    public static int sessionStateId() {
        return 10;
    }

    public static int sessionStateSinceVersion() {
        return 0;
    }

    public static int sessionStateEncodingOffset() {
        return 39;
    }

    public static int sessionStateEncodingLength() {
        return 1;
    }

    public static String sessionStateMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public SessionState sessionState() {
        return SessionState.get((short)(this.buffer.getByte(this.offset + 39) & 0xFF));
    }

    public static int heartbeatIntervalInSId() {
        return 11;
    }

    public static int heartbeatIntervalInSSinceVersion() {
        return 0;
    }

    public static int heartbeatIntervalInSEncodingOffset() {
        return 40;
    }

    public static int heartbeatIntervalInSEncodingLength() {
        return 4;
    }

    public static String heartbeatIntervalInSMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int heartbeatIntervalInSNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int heartbeatIntervalInSMinValue() {
        return -2147483647;
    }

    public static int heartbeatIntervalInSMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int heartbeatIntervalInS() {
        return this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replyToIdId() {
        return 12;
    }

    public static int replyToIdSinceVersion() {
        return 0;
    }

    public static int replyToIdEncodingOffset() {
        return 44;
    }

    public static int replyToIdEncodingLength() {
        return 8;
    }

    public static String replyToIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long replyToIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long replyToIdMinValue() {
        return -9223372036854775807L;
    }

    public static long replyToIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long replyToId() {
        return this.buffer.getLong(this.offset + 44, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sequenceIndexId() {
        return 13;
    }

    public static int sequenceIndexSinceVersion() {
        return 0;
    }

    public static int sequenceIndexEncodingOffset() {
        return 52;
    }

    public static int sequenceIndexEncodingLength() {
        return 4;
    }

    public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int sequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceIndexMinValue() {
        return -2147483647;
    }

    public static int sequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sequenceIndex() {
        return this.buffer.getInt(this.offset + 52, ByteOrder.LITTLE_ENDIAN);
    }

    public static int closedResendIntervalId() {
        return 22;
    }

    public static int closedResendIntervalSinceVersion() {
        return 0;
    }

    public static int closedResendIntervalEncodingOffset() {
        return 56;
    }

    public static int closedResendIntervalEncodingLength() {
        return 1;
    }

    public static String closedResendIntervalMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public Bool closedResendInterval() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 56) & 0xFF));
    }

    public static int resendRequestChunkSizeId() {
        return 23;
    }

    public static int resendRequestChunkSizeSinceVersion() {
        return 0;
    }

    public static int resendRequestChunkSizeEncodingOffset() {
        return 57;
    }

    public static int resendRequestChunkSizeEncodingLength() {
        return 4;
    }

    public static String resendRequestChunkSizeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int resendRequestChunkSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int resendRequestChunkSizeMinValue() {
        return -2147483647;
    }

    public static int resendRequestChunkSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int resendRequestChunkSize() {
        return this.buffer.getInt(this.offset + 57, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sendRedundantResendRequestsId() {
        return 24;
    }

    public static int sendRedundantResendRequestsSinceVersion() {
        return 0;
    }

    public static int sendRedundantResendRequestsEncodingOffset() {
        return 61;
    }

    public static int sendRedundantResendRequestsEncodingLength() {
        return 1;
    }

    public static String sendRedundantResendRequestsMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public Bool sendRedundantResendRequests() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 61) & 0xFF));
    }

    public static int enableLastMsgSeqNumProcessedId() {
        return 25;
    }

    public static int enableLastMsgSeqNumProcessedSinceVersion() {
        return 0;
    }

    public static int enableLastMsgSeqNumProcessedEncodingOffset() {
        return 62;
    }

    public static int enableLastMsgSeqNumProcessedEncodingLength() {
        return 1;
    }

    public static String enableLastMsgSeqNumProcessedMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public Bool enableLastMsgSeqNumProcessed() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 62) & 0xFF));
    }

    public static int awaitingResendId() {
        return 21;
    }

    public static int awaitingResendSinceVersion() {
        return 0;
    }

    public static int awaitingResendEncodingOffset() {
        return 63;
    }

    public static int awaitingResendEncodingLength() {
        return 1;
    }

    public static String awaitingResendMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public AwaitingResend awaitingResend() {
        return AwaitingResend.get((short)(this.buffer.getByte(this.offset + 63) & 0xFF));
    }

    public static int lastResentMsgSeqNoId() {
        return 28;
    }

    public static int lastResentMsgSeqNoSinceVersion() {
        return 1;
    }

    public static int lastResentMsgSeqNoEncodingOffset() {
        return 64;
    }

    public static int lastResentMsgSeqNoEncodingLength() {
        return 4;
    }

    public static String lastResentMsgSeqNoMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "optional";
            }
        }
        return "";
    }

    public static int lastResentMsgSeqNoNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lastResentMsgSeqNoMinValue() {
        return -2147483647;
    }

    public static int lastResentMsgSeqNoMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int lastResentMsgSeqNo() {
        if (this.parentMessage.actingVersion < 1) {
            return Integer.MIN_VALUE;
        }
        return this.buffer.getInt(this.offset + 64, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastResendChunkMsgSeqNumId() {
        return 29;
    }

    public static int lastResendChunkMsgSeqNumSinceVersion() {
        return 1;
    }

    public static int lastResendChunkMsgSeqNumEncodingOffset() {
        return 68;
    }

    public static int lastResendChunkMsgSeqNumEncodingLength() {
        return 4;
    }

    public static String lastResendChunkMsgSeqNumMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "optional";
            }
        }
        return "";
    }

    public static int lastResendChunkMsgSeqNumNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lastResendChunkMsgSeqNumMinValue() {
        return -2147483647;
    }

    public static int lastResendChunkMsgSeqNumMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int lastResendChunkMsgSeqNum() {
        if (this.parentMessage.actingVersion < 1) {
            return Integer.MIN_VALUE;
        }
        return this.buffer.getInt(this.offset + 68, ByteOrder.LITTLE_ENDIAN);
    }

    public static int endOfResendRequestRangeId() {
        return 30;
    }

    public static int endOfResendRequestRangeSinceVersion() {
        return 1;
    }

    public static int endOfResendRequestRangeEncodingOffset() {
        return 72;
    }

    public static int endOfResendRequestRangeEncodingLength() {
        return 4;
    }

    public static String endOfResendRequestRangeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "optional";
            }
        }
        return "";
    }

    public static int endOfResendRequestRangeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int endOfResendRequestRangeMinValue() {
        return -2147483647;
    }

    public static int endOfResendRequestRangeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int endOfResendRequestRange() {
        if (this.parentMessage.actingVersion < 1) {
            return Integer.MIN_VALUE;
        }
        return this.buffer.getInt(this.offset + 72, ByteOrder.LITTLE_ENDIAN);
    }

    public static int awaitingHeartbeatId() {
        return 31;
    }

    public static int awaitingHeartbeatSinceVersion() {
        return 1;
    }

    public static int awaitingHeartbeatEncodingOffset() {
        return 76;
    }

    public static int awaitingHeartbeatEncodingLength() {
        return 1;
    }

    public static String awaitingHeartbeatMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "optional";
            }
        }
        return "";
    }

    public Bool awaitingHeartbeat() {
        if (this.parentMessage.actingVersion < 1) {
            return Bool.NULL_VAL;
        }
        return Bool.get((short)(this.buffer.getByte(this.offset + 76) & 0xFF));
    }

    public static int localCompIdId() {
        return 14;
    }

    public static int localCompIdSinceVersion() {
        return 0;
    }

    public static String localCompIdCharacterEncoding() {
        return "UTF-8";
    }

    public static String localCompIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int localCompIdHeaderLength() {
        return 2;
    }

    public int localCompIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getLocalCompId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLocalCompId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLocalCompId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String localCompId() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int localSubIdId() {
        return 15;
    }

    public static int localSubIdSinceVersion() {
        return 0;
    }

    public static String localSubIdCharacterEncoding() {
        return "UTF-8";
    }

    public static String localSubIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int localSubIdHeaderLength() {
        return 2;
    }

    public int localSubIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getLocalSubId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLocalSubId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLocalSubId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String localSubId() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int localLocationIdId() {
        return 16;
    }

    public static int localLocationIdSinceVersion() {
        return 0;
    }

    public static String localLocationIdCharacterEncoding() {
        return "UTF-8";
    }

    public static String localLocationIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int localLocationIdHeaderLength() {
        return 2;
    }

    public int localLocationIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getLocalLocationId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLocalLocationId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLocalLocationId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String localLocationId() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int remoteCompIdId() {
        return 17;
    }

    public static int remoteCompIdSinceVersion() {
        return 0;
    }

    public static String remoteCompIdCharacterEncoding() {
        return "UTF-8";
    }

    public static String remoteCompIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int remoteCompIdHeaderLength() {
        return 2;
    }

    public int remoteCompIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getRemoteCompId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getRemoteCompId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapRemoteCompId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String remoteCompId() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int remoteSubIdId() {
        return 18;
    }

    public static int remoteSubIdSinceVersion() {
        return 0;
    }

    public static String remoteSubIdCharacterEncoding() {
        return "UTF-8";
    }

    public static String remoteSubIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int remoteSubIdHeaderLength() {
        return 2;
    }

    public int remoteSubIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getRemoteSubId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getRemoteSubId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapRemoteSubId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String remoteSubId() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int remoteLocationIdId() {
        return 19;
    }

    public static int remoteLocationIdSinceVersion() {
        return 0;
    }

    public static String remoteLocationIdCharacterEncoding() {
        return "UTF-8";
    }

    public static String remoteLocationIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int remoteLocationIdHeaderLength() {
        return 2;
    }

    public int remoteLocationIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getRemoteLocationId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getRemoteLocationId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapRemoteLocationId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String remoteLocationId() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int addressId() {
        return 20;
    }

    public static int addressSinceVersion() {
        return 0;
    }

    public static String addressCharacterEncoding() {
        return "UTF-8";
    }

    public static String addressMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int addressHeaderLength() {
        return 2;
    }

    public int addressLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getAddress(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getAddress(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapAddress(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String address() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int usernameId() {
        return 26;
    }

    public static int usernameSinceVersion() {
        return 0;
    }

    public static String usernameCharacterEncoding() {
        return "UTF-8";
    }

    public static String usernameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int usernameHeaderLength() {
        return 2;
    }

    public int usernameLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getUsername(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getUsername(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapUsername(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String username() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int passwordId() {
        return 27;
    }

    public static int passwordSinceVersion() {
        return 0;
    }

    public static String passwordCharacterEncoding() {
        return "UTF-8";
    }

    public static String passwordMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int passwordHeaderLength() {
        return 2;
    }

    public int passwordLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getPassword(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getPassword(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapPassword(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String password() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int fixDictionaryId() {
        return 32;
    }

    public static int fixDictionarySinceVersion() {
        return 0;
    }

    public static String fixDictionaryCharacterEncoding() {
        return "UTF-8";
    }

    public static String fixDictionaryMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int fixDictionaryHeaderLength() {
        return 2;
    }

    public int fixDictionaryLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getFixDictionary(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getFixDictionary(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapFixDictionary(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String fixDictionary() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ManageSession](sbeTemplateId=");
        builder.append(8);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 2) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(2);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 77) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(77);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("connection=");
        builder.append(this.connection());
        builder.append('|');
        builder.append("session=");
        builder.append(this.session());
        builder.append('|');
        builder.append("lastSentSequenceNumber=");
        builder.append(this.lastSentSequenceNumber());
        builder.append('|');
        builder.append("lastReceivedSequenceNumber=");
        builder.append(this.lastReceivedSequenceNumber());
        builder.append('|');
        builder.append("logonTime=");
        builder.append(this.logonTime());
        builder.append('|');
        builder.append("sessionStatus=");
        builder.append((Object)this.sessionStatus());
        builder.append('|');
        builder.append("slowStatus=");
        builder.append((Object)this.slowStatus());
        builder.append('|');
        builder.append("connectionType=");
        builder.append((Object)this.connectionType());
        builder.append('|');
        builder.append("sessionState=");
        builder.append((Object)this.sessionState());
        builder.append('|');
        builder.append("heartbeatIntervalInS=");
        builder.append(this.heartbeatIntervalInS());
        builder.append('|');
        builder.append("replyToId=");
        builder.append(this.replyToId());
        builder.append('|');
        builder.append("sequenceIndex=");
        builder.append(this.sequenceIndex());
        builder.append('|');
        builder.append("closedResendInterval=");
        builder.append((Object)this.closedResendInterval());
        builder.append('|');
        builder.append("resendRequestChunkSize=");
        builder.append(this.resendRequestChunkSize());
        builder.append('|');
        builder.append("sendRedundantResendRequests=");
        builder.append((Object)this.sendRedundantResendRequests());
        builder.append('|');
        builder.append("enableLastMsgSeqNumProcessed=");
        builder.append((Object)this.enableLastMsgSeqNumProcessed());
        builder.append('|');
        builder.append("awaitingResend=");
        builder.append((Object)this.awaitingResend());
        builder.append('|');
        builder.append("lastResentMsgSeqNo=");
        builder.append(this.lastResentMsgSeqNo());
        builder.append('|');
        builder.append("lastResendChunkMsgSeqNum=");
        builder.append(this.lastResendChunkMsgSeqNum());
        builder.append('|');
        builder.append("endOfResendRequestRange=");
        builder.append(this.endOfResendRequestRange());
        builder.append('|');
        builder.append("awaitingHeartbeat=");
        builder.append((Object)this.awaitingHeartbeat());
        builder.append('|');
        builder.append("localCompId=");
        builder.append('\'').append(this.localCompId()).append('\'');
        builder.append('|');
        builder.append("localSubId=");
        builder.append('\'').append(this.localSubId()).append('\'');
        builder.append('|');
        builder.append("localLocationId=");
        builder.append('\'').append(this.localLocationId()).append('\'');
        builder.append('|');
        builder.append("remoteCompId=");
        builder.append('\'').append(this.remoteCompId()).append('\'');
        builder.append('|');
        builder.append("remoteSubId=");
        builder.append('\'').append(this.remoteSubId()).append('\'');
        builder.append('|');
        builder.append("remoteLocationId=");
        builder.append('\'').append(this.remoteLocationId()).append('\'');
        builder.append('|');
        builder.append("address=");
        builder.append('\'').append(this.address()).append('\'');
        builder.append('|');
        builder.append("username=");
        builder.append('\'').append(this.username()).append('\'');
        builder.append('|');
        builder.append("password=");
        builder.append('\'').append(this.password()).append('\'');
        builder.append('|');
        builder.append("fixDictionary=");
        builder.append('\'').append(this.fixDictionary()).append('\'');
        this.limit(originalLimit);
        return builder;
    }
}

