/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import org.agrona.LangUtil;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.builder.AbstractHeartbeatEncoder;
import uk.co.real_logic.artio.builder.AbstractLogonEncoder;
import uk.co.real_logic.artio.builder.AbstractLogoutEncoder;
import uk.co.real_logic.artio.builder.AbstractRejectEncoder;
import uk.co.real_logic.artio.builder.AbstractResendRequestEncoder;
import uk.co.real_logic.artio.builder.AbstractSequenceResetEncoder;
import uk.co.real_logic.artio.builder.AbstractTestRequestEncoder;
import uk.co.real_logic.artio.decoder.AbstractHeartbeatDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogoutDecoder;
import uk.co.real_logic.artio.decoder.AbstractRejectDecoder;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.decoder.AbstractSequenceResetDecoder;
import uk.co.real_logic.artio.decoder.AbstractTestRequestDecoder;
import uk.co.real_logic.artio.decoder.AbstractUserRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;

public class FixDictionaryGenerator {
    private static final String TEMPLATE = "public class FixDictionaryImpl implements FixDictionary\n{\n    public String beginString()\n    {\n        return \"%1$s\";\n    }\n\n    public AbstractLogonEncoder makeLogonEncoder()\n    {\n        return new LogonEncoder();\n    }\n\n    public AbstractResendRequestEncoder makeResendRequestEncoder()\n    {\n        return new ResendRequestEncoder();\n    }\n\n    public AbstractLogoutEncoder makeLogoutEncoder()\n    {\n        return new LogoutEncoder();\n    }\n\n    public AbstractHeartbeatEncoder makeHeartbeatEncoder()\n    {\n        return new HeartbeatEncoder();\n    }\n\n    public AbstractRejectEncoder makeRejectEncoder()\n    {\n        return new RejectEncoder();\n    }\n\n    public AbstractTestRequestEncoder makeTestRequestEncoder()\n    {\n        return new TestRequestEncoder();\n    }\n\n    public AbstractSequenceResetEncoder makeSequenceResetEncoder()\n    {\n        return new SequenceResetEncoder();\n    }\n\n    public AbstractLogonDecoder makeLogonDecoder()\n    {\n        return new LogonDecoder();\n    }\n\n    public AbstractLogoutDecoder makeLogoutDecoder()\n    {\n        return new LogoutDecoder();\n    }\n\n    public AbstractRejectDecoder makeRejectDecoder()\n    {\n        return new RejectDecoder();\n    }\n\n    public AbstractTestRequestDecoder makeTestRequestDecoder()\n    {\n        return new TestRequestDecoder();\n    }\n\n    public AbstractSequenceResetDecoder makeSequenceResetDecoder()\n    {\n        return new SequenceResetDecoder();\n    }\n\n    public AbstractHeartbeatDecoder makeHeartbeatDecoder()\n    {\n        return new HeartbeatDecoder();\n    }\n\n    public AbstractResendRequestDecoder makeResendRequestDecoder()\n    {\n        return new ResendRequestDecoder();\n    }\n\n    public AbstractUserRequestDecoder makeUserRequestDecoder()\n    {\n        return %2$s;\n    }\n\n    public SessionHeaderDecoder makeHeaderDecoder()\n    {\n        return new HeaderDecoder();\n    }\n\n";
    private final Dictionary dictionary;
    private final OutputManager outputManager;
    private final String encoderPackage;
    private final String decoderPackage;
    private final String parentPackage;

    public FixDictionaryGenerator(Dictionary dictionary, OutputManager outputManager, String encoderPackage, String decoderPackage, String parentPackage) {
        this.dictionary = dictionary;
        this.outputManager = outputManager;
        this.encoderPackage = encoderPackage;
        this.decoderPackage = decoderPackage;
        this.parentPackage = parentPackage;
    }

    public void generate() {
        boolean hasUserRequest = this.dictionary.messages().stream().anyMatch(message -> message.name().equals("UserRequest"));
        this.outputManager.withOutput("FixDictionaryImpl", out -> {
            try {
                out.append(GenerationUtil.fileHeader(this.parentPackage));
                out.append(GenerationUtil.importFor(FixDictionary.class));
                out.append(GenerationUtil.importFor(AbstractLogonEncoder.class));
                out.append(GenerationUtil.importFor(this.encoderPackage + ".LogonEncoder"));
                out.append(GenerationUtil.importFor(AbstractResendRequestEncoder.class));
                out.append(GenerationUtil.importFor(this.encoderPackage + ".ResendRequestEncoder"));
                out.append(GenerationUtil.importFor(AbstractLogoutEncoder.class));
                out.append(GenerationUtil.importFor(this.encoderPackage + ".LogoutEncoder"));
                out.append(GenerationUtil.importFor(AbstractHeartbeatEncoder.class));
                out.append(GenerationUtil.importFor(this.encoderPackage + ".HeartbeatEncoder"));
                out.append(GenerationUtil.importFor(AbstractRejectEncoder.class));
                out.append(GenerationUtil.importFor(this.encoderPackage + ".RejectEncoder"));
                out.append(GenerationUtil.importFor(AbstractTestRequestEncoder.class));
                out.append(GenerationUtil.importFor(this.encoderPackage + ".TestRequestEncoder"));
                out.append(GenerationUtil.importFor(AbstractSequenceResetEncoder.class));
                out.append(GenerationUtil.importFor(this.encoderPackage + ".SequenceResetEncoder"));
                out.append(GenerationUtil.importFor(AbstractLogonDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".LogonDecoder"));
                out.append(GenerationUtil.importFor(AbstractLogoutDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".LogoutDecoder"));
                out.append(GenerationUtil.importFor(AbstractRejectDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".RejectDecoder"));
                out.append(GenerationUtil.importFor(AbstractTestRequestDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".TestRequestDecoder"));
                out.append(GenerationUtil.importFor(AbstractSequenceResetDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".SequenceResetDecoder"));
                out.append(GenerationUtil.importFor(AbstractHeartbeatDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".HeartbeatDecoder"));
                out.append(GenerationUtil.importFor(AbstractResendRequestDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".ResendRequestDecoder"));
                out.append(GenerationUtil.importFor(AbstractUserRequestDecoder.class));
                if (hasUserRequest) {
                    out.append(GenerationUtil.importFor(this.decoderPackage + ".UserRequestDecoder"));
                }
                out.append(GenerationUtil.importFor(SessionHeaderDecoder.class));
                out.append(GenerationUtil.importFor(this.decoderPackage + ".HeaderDecoder"));
                String userRequestConstructor = hasUserRequest ? "new UserRequestDecoder()" : "null";
                out.append(String.format(TEMPLATE, this.dictionary.beginString(), userRequestConstructor));
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            finally {
                out.append("}\n");
            }
        });
    }
}

