/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.util.function.Predicate;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;

public final class IntDictionary {
    private static final int MISSING_FIELD = -1;
    private static final int CAPACITY = 1024;
    private final Int2ObjectHashMap<IntHashSet> map = new Int2ObjectHashMap();

    public static IntDictionary requiredFields(Dictionary dictionary) {
        return IntDictionary.fields(dictionary, Entry::required);
    }

    public static IntDictionary allFields(Dictionary dictionary) {
        return IntDictionary.fields(dictionary, entry -> true);
    }

    private static IntDictionary fields(Dictionary dictionary, Predicate<Entry> entryPredicate) {
        IntDictionary fields = new IntDictionary();
        dictionary.messages().forEach(message -> {
            int type = message.packedType();
            message.entries().stream().filter(entryPredicate).filter(entry -> entry.element() instanceof Field).map(entry -> (Field)entry.element()).forEach(field -> fields.put(type, field.number()));
        });
        return fields;
    }

    public void put(int key, int value) {
        this.valuesOrDefault(key).add(value);
    }

    public void putAll(int key, int ... valuesToAdd) {
        IntHashSet values = this.valuesOrDefault(key);
        for (int value : valuesToAdd) {
            values.add(value);
        }
    }

    private IntHashSet valuesOrDefault(int key) {
        return (IntHashSet)this.map.computeIfAbsent(key, ignore -> new IntHashSet(1024));
    }

    public IntHashSet values(int key) {
        return (IntHashSet)this.map.get(key);
    }

    public boolean contains(int key, int value) {
        IntHashSet fields = this.values(key);
        return fields != null && fields.contains(value);
    }
}

