/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

public enum SessionReplyStatus {
    OK(0),
    UNKNOWN_SESSION(1),
    UNKNOWN_LIBRARY(2),
    OTHER_SESSION_OWNER(3),
    SESSION_NOT_LOGGED_IN(4),
    SEQUENCE_NUMBER_TOO_HIGH(5),
    MISSING_MESSAGES(6),
    INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES(7),
    NULL_VAL(255);

    private final short value;

    private SessionReplyStatus(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    public static SessionReplyStatus get(short value) {
        switch (value) {
            case 0: {
                return OK;
            }
            case 1: {
                return UNKNOWN_SESSION;
            }
            case 2: {
                return UNKNOWN_LIBRARY;
            }
            case 3: {
                return OTHER_SESSION_OWNER;
            }
            case 4: {
                return SESSION_NOT_LOGGED_IN;
            }
            case 5: {
                return SEQUENCE_NUMBER_TOO_HIGH;
            }
            case 6: {
                return MISSING_MESSAGES;
            }
            case 7: {
                return INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES;
            }
        }
        if (255 == value) {
            return NULL_VAL;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

