/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class AsciiFormatter {
    private static final int DEFAULT_LENGTH = 10;
    private static final Pattern PATTERN = Pattern.compile("%s");
    private final byte[][] segments;
    private final byte[] numberBuffer = new byte[MutableAsciiBuffer.LONGEST_INT_LENGTH + 1];
    private final MutableAsciiBuffer numberFlyweight = new MutableAsciiBuffer(this.numberBuffer);
    private byte[] value = new byte[10];
    private int index = 0;
    private int encodedSoFar = 0;

    public AsciiFormatter(CharSequence formatString) {
        String[] splitFormatString = PATTERN.split(formatString);
        int numberOfSegments = splitFormatString.length;
        this.segments = new byte[numberOfSegments][];
        for (int i = 0; i < numberOfSegments; ++i) {
            this.segments[i] = splitFormatString[i].getBytes(StandardCharsets.US_ASCII);
        }
        this.append(this.segments[0]);
    }

    public AsciiFormatter with(byte[] field) {
        return this.with(field, field.length);
    }

    public AsciiFormatter with(byte[] field, int length) {
        this.append(field, length);
        ++this.encodedSoFar;
        if (this.encodedSoFar < this.segments.length) {
            this.append(this.segments[this.encodedSoFar]);
        }
        return this;
    }

    public AsciiFormatter with(int number) {
        int length = this.numberFlyweight.putIntAscii(0, number);
        return this.with(this.numberBuffer, length);
    }

    public AsciiFormatter clear() {
        this.encodedSoFar = 0;
        this.index = 0;
        this.append(this.segments[0]);
        return this;
    }

    public int length() {
        return this.index;
    }

    public byte[] value() {
        return this.value;
    }

    private void append(byte[] toAppend) {
        this.append(toAppend, toAppend.length);
    }

    private void append(byte[] toAppend, int toAppendLength) {
        byte[] value = this.value;
        int index = this.index;
        int requiredLength = index + toAppendLength;
        if (value.length < requiredLength) {
            byte[] newValue = new byte[requiredLength];
            System.arraycopy(value, 0, newValue, 0, index);
            value = newValue;
        }
        System.arraycopy(toAppend, 0, value, index, toAppendLength);
        this.index = index += toAppendLength;
        this.value = value;
    }
}

