/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.AsciiSequenceView;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntHashSet;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import uk.co.real_logic.artio.dictionary.StandardFixConstants;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

public abstract class Generator {
    public static final String MSG_TYPE = "MsgType";
    public static final String BEGIN_STRING = "BeginString";
    public static final String BODY_LENGTH = "BodyLength";
    public static final String EXPAND_INDENT = ".toString().replace(\"\\n\", \"\\n  \")";
    public static final String CODEC_VALIDATION_ENABLED = "CODEC_VALIDATION_ENABLED";
    public static final String CODEC_REJECT_UNKNOWN_FIELD_ENABLED = "CODEC_REJECT_UNKNOWN_FIELD_ENABLED";
    public static final String MESSAGE_FIELDS = "messageFields";
    private static final String COMMON_COMPOUND_IMPORTS = "import %1$s.Header%2$s;\nimport %1$s.Trailer%2$s;\n";
    protected final Dictionary dictionary;
    protected final String builderPackage;
    private String builderCommonPackage;
    protected final OutputManager outputManager;
    protected final Class<?> validationClass;
    protected final Class<?> rejectUnknownClass;
    protected final boolean flyweightsEnabled;

    protected String commonCompoundImports(String form, boolean headerWrapsTrailer, String messageFieldsSet) {
        String headerParameter = headerWrapsTrailer ? "trailer" : "";
        return String.format("    %3$s    private Trailer%1$s trailer = new Trailer%1$s();\n\n    public Trailer%1$s trailer()\n    {\n        return trailer;\n    }\n\n    private Header%1$s header = new Header%1$s(%2$s);\n\n    public Header%1$s header()\n    {\n        return header;\n    }\n\n", form, headerParameter, messageFieldsSet);
    }

    protected Generator(Dictionary dictionary, String thisPackage, String commonPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownClass, boolean flyweightsEnabled) {
        this.dictionary = dictionary;
        this.builderPackage = thisPackage;
        this.builderCommonPackage = commonPackage;
        this.outputManager = outputManager;
        this.validationClass = validationClass;
        this.rejectUnknownClass = rejectUnknownClass;
        this.flyweightsEnabled = flyweightsEnabled;
    }

    public void generate() {
        this.generateAggregateFile(this.dictionary.header(), AggregateType.HEADER);
        this.generateAggregateFile(this.dictionary.trailer(), AggregateType.TRAILER);
        this.dictionary.components().forEach((name, component) -> this.generateAggregateFile((Aggregate)component, AggregateType.COMPONENT));
        this.dictionary.messages().forEach(msg -> this.generateAggregateFile((Aggregate)msg, AggregateType.MESSAGE));
    }

    protected abstract void generateAggregateFile(Aggregate var1, AggregateType var2);

    protected abstract Class<?> topType(AggregateType var1);

    protected void generateImports(String compoundSuffix, AggregateType type, Writer out, Class<?> ... extraImports) throws IOException {
        out.append(GenerationUtil.importFor(MutableDirectBuffer.class)).append(GenerationUtil.importFor(AsciiSequenceView.class)).append(GenerationUtil.importStaticFor(CodecUtil.class)).append(GenerationUtil.importStaticFor(StandardFixConstants.class)).append(GenerationUtil.importFor(this.topType(AggregateType.MESSAGE)));
        if (this.topType(AggregateType.GROUP) != this.topType(AggregateType.MESSAGE)) {
            out.append(GenerationUtil.importFor(this.topType(AggregateType.GROUP)));
        }
        out.append(type == AggregateType.MESSAGE ? String.format(COMMON_COMPOUND_IMPORTS, this.builderPackage, compoundSuffix) : "").append(GenerationUtil.importFor(DecimalFloat.class)).append(GenerationUtil.importFor(MutableAsciiBuffer.class)).append(GenerationUtil.importFor(AsciiBuffer.class)).append(GenerationUtil.importFor(LocalMktDateEncoder.class)).append(GenerationUtil.importFor(UtcTimestampEncoder.class)).append(GenerationUtil.importFor(StandardCharsets.class)).append(GenerationUtil.importFor(Arrays.class)).append(GenerationUtil.importFor(CharArraySet.class)).append(GenerationUtil.importFor(IntHashSet.class)).append(GenerationUtil.importFor(IntHashSet.IntIterator.class)).append(GenerationUtil.importFor(EncodingException.class));
        for (Class<?> extraImport : extraImports) {
            out.append(GenerationUtil.importFor(extraImport));
        }
        out.append(GenerationUtil.importStaticFor(StandardCharsets.class, "US_ASCII")).append(GenerationUtil.importStaticFor(this.validationClass, CODEC_VALIDATION_ENABLED)).append(GenerationUtil.importStaticFor(this.rejectUnknownClass, CODEC_REJECT_UNKNOWN_FIELD_ENABLED));
        if (!this.builderPackage.equals(this.builderCommonPackage) && !this.builderCommonPackage.isEmpty()) {
            out.append(GenerationUtil.importFor(this.builderCommonPackage + ".*"));
        }
    }

    protected String classDeclaration(String className, List<String> interfaces, boolean isStatic) {
        String interfaceList = interfaces.isEmpty() ? "" : " implements " + String.join((CharSequence)", ", interfaces);
        return String.format("\n\npublic %3$sclass %1$s%2$s\n{\n", className, interfaceList, isStatic ? "static " : "");
    }

    protected String completeResetMethod(boolean isMessage, List<Entry> entries, String additionalReset) {
        StringBuilder methods = new StringBuilder();
        String resetEntries = this.resetEntries(entries, methods);
        if (isMessage) {
            return String.format("    public void reset()\n    {\n        header.reset();\n        trailer.reset();\n        resetMessage();\n%2$s    }\n\n    public void resetMessage()\n    {\n%1$s    }\n\n%3$s", resetEntries, additionalReset, methods);
        }
        return String.format("    public void reset()\n    {\n%s%s    }\n\n%s", resetEntries, additionalReset, methods);
    }

    protected String resetEntries(List<Entry> entries, StringBuilder methods) {
        return this.resetFields(entries, methods) + this.resetComponents(entries, methods) + this.resetGroups(entries, methods);
    }

    private String resetFields(List<Entry> entries, StringBuilder methods) {
        return this.resetAllBy(entries, methods, Entry::isField, entry -> this.resetField(entry.required(), (Field)entry.element()), this::callResetMethod);
    }

    protected String resetAllBy(List<Entry> entries, StringBuilder methods, Predicate<Entry> predicate, Function<Entry, String> methodFactory, Function<Entry, String> callFactory) {
        methods.append(entries.stream().filter(predicate).map(methodFactory).collect(Collectors.joining()));
        return entries.stream().filter(predicate).map(callFactory).collect(Collectors.joining());
    }

    private String resetGroups(List<Entry> entries, StringBuilder methods) {
        return this.resetAllBy(entries, methods, Entry::isGroup, this::resetGroup, this::callResetMethod);
    }

    protected abstract String resetGroup(Entry var1);

    private String resetField(boolean isRequired, Field field) {
        String name = field.name();
        if (this.isNotResettableField(name)) {
            return "";
        }
        if (!isRequired) {
            return this.optionalReset(field, name);
        }
        switch (field.type()) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return this.resetRequiredInt(field);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return this.resetRequiredFloat(name);
            }
            case CHAR: {
                return this.resetFieldValue(field, "MISSING_CHAR");
            }
            case DATA: 
            case XMLDATA: {
                return this.resetFieldValue(field, "null");
            }
            case BOOLEAN: {
                return this.resetFieldValue(field, "false");
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return this.resetStringBasedData(name);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.resetTemporalValue(name);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)field.type()));
    }

    protected abstract String resetRequiredInt(Field var1);

    protected abstract String optionalReset(Field var1, String var2);

    protected abstract String resetTemporalValue(String var1);

    protected abstract String resetComponents(List<Entry> var1, StringBuilder var2);

    protected abstract String resetStringBasedData(String var1);

    protected String nameOfResetMethod(String name) {
        return "reset" + name;
    }

    private String callResetMethod(Entry entry) {
        if (this.isNotResettableField(entry.name())) {
            return "";
        }
        return String.format("        %1$s();\n", this.nameOfResetMethod(entry.name()));
    }

    protected String callComponentReset(Entry entry) {
        return String.format("        %1$s.reset();\n", JavaUtil.formatPropertyName((String)entry.name()));
    }

    protected String hasField(Entry entry) {
        String name = entry.name();
        return entry.required() ? "" : String.format("    private boolean has%1$s;\n\n", name);
    }

    protected String resetNothing(String name) {
        return String.format("    public void %1$s()\n    {\n    }\n\n", this.nameOfResetMethod(name));
    }

    private boolean isNotResettableField(String name) {
        return this.isDerivedField(name) || this.isPreCalculatedField(name);
    }

    private boolean isPreCalculatedField(String name) {
        return "MessageName".equals(name) || BEGIN_STRING.equals(name) || MSG_TYPE.equals(name);
    }

    private boolean isDerivedField(String name) {
        return this.isBodyLength(name) || this.isCheckSum(name);
    }

    protected abstract String resetRequiredFloat(String var1);

    protected String resetLength(String name) {
        return String.format("    public void %1$s()\n    {\n        %2$sLength = 0;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name));
    }

    protected String resetByFlag(String name) {
        return String.format("    public void %2$s()\n    {\n        has%1$s = false;\n    }\n\n", name, this.nameOfResetMethod(name));
    }

    protected String resetFieldValue(Field field, String resetValue) {
        String name = field.name();
        boolean hasLengthField = field.type().hasLengthField(this.flyweightsEnabled);
        String lengthReset = hasLengthField ? "        %2$sLength = 0;\n" : "";
        return String.format("    public void %1$s()\n    {\n" + lengthReset + "        %2$s = %3$s;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name), resetValue);
    }

    protected String toString(Aggregate aggregate, boolean hasCommonCompounds) {
        String parameters;
        String suffix;
        String prefix;
        String entriesToString = aggregate.entries().stream().map(this::entryToString).collect(Collectors.joining(" + \n"));
        String string = prefix = !hasCommonCompounds ? "" : "\"  \\\"header\\\": \" + header.toString().replace(\"\\n\", \"\\n  \") + \"\\n\" + ";
        if (aggregate instanceof Group) {
            suffix = this.toStringGroupSuffix();
            parameters = this.toStringGroupParameters();
        } else {
            suffix = "";
            parameters = "";
        }
        return String.format("    public String toString(%5$s)\n    {\n        String entries = %1$s\n%2$s;\n\n        entries = \"{\\n  \\\"MessageName\\\": \\\"%4$s\\\",\\n\" + entries + \"}\";\n%3$s        return entries;\n    }\n\n", prefix, entriesToString, suffix, aggregate.name(), parameters);
    }

    protected abstract String toStringGroupParameters();

    protected abstract String toStringGroupSuffix();

    protected String entryToString(Entry entry) {
        if (this.isBodyLength(entry)) {
            return "\"\"";
        }
        Entry.Element element = entry.element();
        String name = entry.name();
        if (element instanceof Field) {
            Field field = (Field)element;
            String value = this.fieldToString(field);
            String formatter = String.format("String.format(\"  \\\"%s\\\": \\\"%%s\\\",\\n\", %s)", name, value);
            boolean hasFlag = this.toStringChecksHasGetter(entry, field);
            return "             " + (hasFlag ? String.format("(has%s() ? %s : \"\")", name, formatter) : formatter);
        }
        if (element instanceof Group) {
            return this.groupEntryToString((Group)element, name);
        }
        if (element instanceof Component) {
            return this.componentToString((Component)element);
        }
        return "\"\"";
    }

    protected abstract boolean toStringChecksHasGetter(Entry var1, Field var2);

    protected abstract String groupEntryToString(Group var1, String var2);

    protected abstract boolean hasFlag(Entry var1, Field var2);

    protected String hasGetter(String name) {
        return String.format("    public boolean has%s()\n    {\n        return has%1$s;\n    }\n\n", name);
    }

    protected abstract String componentToString(Component var1);

    protected String fieldToString(Field field) {
        String fieldName = JavaUtil.formatPropertyName((String)field.name());
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.stringToString(fieldName);
            }
            case DATA: 
            case XMLDATA: {
                if (this.flyweightsEnabled) {
                    return String.format("Arrays.toString(%1$s())", fieldName);
                }
                return String.format("Arrays.toString(%1$s)", fieldName);
            }
        }
        if (this.flyweightsEnabled) {
            return String.format("%1$s()", fieldName);
        }
        return fieldName;
    }

    protected boolean isCheckSum(Entry entry) {
        return entry != null && this.isCheckSum(entry.name());
    }

    private boolean isCheckSum(String name) {
        return "CheckSum".equals(name);
    }

    protected boolean isBodyLength(Entry entry) {
        return entry != null && this.isBodyLength(entry.name());
    }

    protected boolean isBeginString(Entry entry) {
        return entry != null && BEGIN_STRING.equals(entry.name());
    }

    protected boolean isBodyLength(String name) {
        return BODY_LENGTH.equals(name);
    }

    protected abstract String stringToString(String var1);

    protected String indent(int times, String suffix) {
        StringBuilder sb = new StringBuilder(times * 4 + suffix.length());
        IntStream.range(0, times).forEach(ignore -> sb.append("    "));
        sb.append(suffix);
        return sb.toString();
    }
}

