/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.CalendricalUtil;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class LocalMktDateDecoder {
    public static final int MIN_EPOCH_DAYS = -719162;
    public static final int MAX_EPOCH_DAYS = 2932896;
    public static final int LENGTH = 8;
    private final AsciiBuffer buffer = new MutableAsciiBuffer();

    public int decode(byte[] bytes) {
        this.buffer.wrap(bytes);
        return LocalMktDateDecoder.decode(this.buffer, 0, 1);
    }

    public static int decode(AsciiBuffer timestamp, int offset, int length) {
        int endYear = offset + 4;
        int endMonth = endYear + 2;
        int endDay = endMonth + 2;
        int year = timestamp.getNatural(offset, endYear);
        int month = CalendricalUtil.getValidInt(timestamp, endYear, endMonth, 1, 12);
        int day = CalendricalUtil.getValidInt(timestamp, endMonth, endDay, 1, 31);
        return CalendricalUtil.toEpochDay(year, month, day);
    }
}

