/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import java.math.BigDecimal;

public final class DecimalFloat
implements Comparable<DecimalFloat> {
    private static final int SCALE_NAN_VALUE = -128;
    private static final long VALUE_NAN_VALUE = Long.MIN_VALUE;
    private static final double DOUBLE_NAN_VALUE = Double.NaN;
    private static final long VALUE_MAX_VAL = 999999999999999999L;
    private static final double VALUE_MAX_VAL_AS_DOUBLE = 1.0E18;
    private static final long VALUE_MIN_VAL = -999999999999999999L;
    private static final double VALUE_MIN_VAL_AS_DOUBLE = -1.0E18;
    private static final int SCALE_MAX_VAL = 127;
    private static final int SCALE_MIN_VAL = 0;
    public static final DecimalFloat MIN_VALUE = new DecimalFloat(-999999999999999999L, 0);
    public static final DecimalFloat MAX_VALUE = new DecimalFloat(999999999999999999L, 0);
    public static final DecimalFloat ZERO = new DecimalFloat();
    public static final DecimalFloat NAN = DecimalFloat.getNaN();
    public static final DecimalFloat MISSING_FLOAT = ZERO;
    private static final int HIGHEST_POWER_OF_TEN = 18;
    private static final long[] POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, Long.MAX_VALUE};
    private static final double FRACTION_LOWER_THRESHOLD = 1.0E-7;
    private static final double FRACTION_UPPER_THRESHOLD = 0.9999999;
    private long value;
    private int scale;

    public DecimalFloat() {
        this(0L, 0);
    }

    public DecimalFloat(long value) {
        this(value, 0);
    }

    public DecimalFloat(long value, int scale) {
        this.setAndNormalise(value, scale);
    }

    public void reset() {
        this.setAndNormalise(0L, 0);
    }

    public long value() {
        return this.value;
    }

    public int scale() {
        return this.scale;
    }

    public DecimalFloat set(DecimalFloat other) {
        this.value = other.value;
        this.scale = other.scale;
        return this;
    }

    public DecimalFloat fromLong(long value) {
        this.setAndNormalise(value, 0);
        return this;
    }

    public DecimalFloat set(long value, int scale) {
        this.setAndNormalise(value, scale);
        return this;
    }

    @Deprecated
    public DecimalFloat value(long value) {
        this.value = value;
        return this;
    }

    @Deprecated
    public DecimalFloat scale(int scale) {
        this.scale = scale;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalFloat that = (DecimalFloat)o;
        return this.scale == that.scale && this.value == that.value;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        return 31 * result + this.scale;
    }

    public String toString() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.value, this.scale);
        return bigDecimal.toPlainString();
    }

    @Override
    public int compareTo(DecimalFloat other) {
        int otherDigitsBeforeDecimalPoint;
        long otherValue;
        long value = this.value;
        boolean isPositive = value >= 0L;
        int negativeComparison = Boolean.compare(isPositive, (otherValue = other.value) >= 0L);
        if (negativeComparison != 0) {
            return negativeComparison;
        }
        int digitsBeforeDecimalPoint = this.digitsBeforeDecimalPoint(value);
        int digitComparison = Integer.compare(digitsBeforeDecimalPoint, otherDigitsBeforeDecimalPoint = other.digitsBeforeDecimalPoint(otherValue));
        if (digitComparison == 0) {
            return Long.compare(value, otherValue);
        }
        if (value == 0L) {
            return -1;
        }
        if (otherValue == 0L) {
            return 1;
        }
        return isPositive ? digitComparison : -1 * digitComparison;
    }

    private int digitsBeforeDecimalPoint(long value) {
        long absValue = Math.abs(value);
        int digitsInvalue = absValue < 10L ? 1 : (absValue < 100L ? 2 : (absValue < 1000L ? 3 : (absValue < 10000L ? 4 : (absValue < 100000L ? 5 : (absValue < 1000000L ? 6 : (absValue < 10000000L ? 7 : (absValue < 100000000L ? 8 : (absValue < 1000000000L ? 9 : (absValue < 10000000000L ? 10 : (absValue < 100000000000L ? 11 : (absValue < 1000000000000L ? 12 : (absValue < 10000000000000L ? 13 : (absValue < 100000000000000L ? 14 : (absValue < 1000000000000000L ? 15 : (absValue < 10000000000000000L ? 16 : (absValue < 100000000000000000L ? 17 : (absValue < 1000000000000000000L ? 18 : 19)))))))))))))))));
        return digitsInvalue - this.scale;
    }

    public double toDouble() {
        if (this.isNaNValue()) {
            return Double.NaN;
        }
        return DecimalFloat.toDouble(this.value, this.scale);
    }

    public boolean fromDouble(double doubleValue) {
        if (Double.isNaN(doubleValue)) {
            this.value = Long.MIN_VALUE;
            this.scale = -128;
            return true;
        }
        if (!Double.isFinite(doubleValue) || DecimalFloat.isOutsideLimits(doubleValue, -1.0E18, 1.0E18)) {
            return false;
        }
        if (doubleValue == 0.0) {
            this.value = 0L;
            this.scale = 0;
            return true;
        }
        boolean isNegative = doubleValue < 0.0;
        double remainingValue = Math.abs(doubleValue);
        long newValue = (long)remainingValue;
        if (DecimalFloat.isOutsideLimits(newValue, -999999999999999999L, 999999999999999999L)) {
            return false;
        }
        int newScale = 0;
        if ((remainingValue -= (double)newValue) == 0.0) {
            this.setAndNormalise(DecimalFloat.signedValue(isNegative, newValue), newScale);
            return true;
        }
        while (DecimalFloat.canValueAcceptMoreDigits(newValue, newScale) && (newValue == 0L || !DecimalFloat.isOutsideLimits(remainingValue, 1.0E-7, 0.9999999))) {
            double digit = Math.floor(remainingValue *= 10.0);
            remainingValue -= digit;
            newValue = newValue * 10L + (long)digit;
            ++newScale;
        }
        if (0.9999999 < remainingValue) {
            ++newValue;
        }
        this.setAndNormalise(DecimalFloat.signedValue(isNegative, newValue), newScale);
        return true;
    }

    public DecimalFloat fromString(CharSequence string) {
        return this.fromString(string, 0, string.length());
    }

    public DecimalFloat fromString(CharSequence string, int start, int length) {
        boolean negative;
        int index;
        int offset = start;
        int end = offset + length;
        for (int index2 = end - 1; this.isSpace(string, index2) && index2 > offset; --index2) {
            --end;
        }
        int endDiff = 0;
        for (int index3 = end - 1; this.isZero(string, index3) && index3 > offset; --index3) {
            ++endDiff;
        }
        boolean isFloatingPoint = false;
        for (index = end - endDiff - 1; index > offset; --index) {
            if (string.charAt(index) != '.') continue;
            isFloatingPoint = true;
            break;
        }
        if (isFloatingPoint) {
            end -= endDiff;
        }
        for (index = offset; this.isSpace(string, index) && index < end; ++index) {
            ++offset;
        }
        boolean bl = negative = string.charAt(offset) == '-';
        if (negative) {
            ++offset;
        }
        for (int index4 = offset; this.isZero(string, index4) && index4 < end; ++index4) {
            ++offset;
        }
        int scale = 0;
        long value = 0L;
        for (int index5 = offset; index5 < end; ++index5) {
            char charValue = string.charAt(index5);
            if (charValue == '.') {
                scale = end - (index5 + 1);
                continue;
            }
            int digit = this.getDigit(index5, charValue);
            value = value * 10L + (long)digit;
        }
        this.set(negative ? -1L * value : value, scale);
        return this;
    }

    private int getDigit(int index, char charValue) {
        int numericValue = Character.getNumericValue(charValue);
        if (numericValue == -1) {
            throw new NumberFormatException("'" + charValue + "' isn't a valid digit @ " + index);
        }
        return numericValue;
    }

    private boolean isSpace(CharSequence input, int index) {
        return Character.isSpaceChar(input.charAt(index));
    }

    private boolean isZero(CharSequence input, int index) {
        return input.charAt(index) == '0';
    }

    public boolean isNaNValue() {
        return this.value == Long.MIN_VALUE && this.scale == -128;
    }

    private static DecimalFloat getNaN() {
        DecimalFloat nanFloat = new DecimalFloat();
        nanFloat.value = Long.MIN_VALUE;
        nanFloat.scale = -128;
        return nanFloat;
    }

    private void setAndNormalise(long value, int scale) {
        this.value = value;
        this.scale = scale;
        this.normalise();
    }

    private void normalise() {
        int scale;
        long value = this.value;
        if (value == 0L) {
            scale = 0;
        } else if (0 < scale) {
            for (scale = this.scale; value % 10L == 0L && 0 < scale; --scale) {
                value /= 10L;
            }
        } else if (scale < 0) {
            while (!DecimalFloat.isOutsideLimits(value, -999999999999999999L, 999999999999999999L) && scale < 0) {
                value *= 10L;
                ++scale;
            }
        }
        if (DecimalFloat.isOutsideLimits(scale, 0L, 127L) || DecimalFloat.isOutsideLimits(value, -999999999999999999L, 999999999999999999L)) {
            throw new ArithmeticException("Out of range: value: " + this.value + ", scale: " + this.scale);
        }
        this.value = value;
        this.scale = scale;
    }

    private static double toDouble(long value, int scale) {
        int remainingPowersOfTen;
        double divisor = 1.0;
        for (remainingPowersOfTen = scale; remainingPowersOfTen >= 18; remainingPowersOfTen -= 18) {
            divisor *= (double)POWERS_OF_TEN[18];
        }
        return (double)value / (divisor *= (double)POWERS_OF_TEN[remainingPowersOfTen]);
    }

    private static boolean canValueAcceptMoreDigits(long value, int scale) {
        return value <= POWERS_OF_TEN[17] && scale < 127;
    }

    private static boolean isOutsideLimits(long value, long lowerBound, long upperBound) {
        return value < lowerBound || upperBound < value;
    }

    private static boolean isOutsideLimits(double value, double lowerBound, double upperBound) {
        return value < lowerBound || upperBound < value;
    }

    private static long signedValue(boolean isNegative, long value) {
        return isNegative ? -value : value;
    }
}

