/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.CalendricalUtil;
import uk.co.real_logic.artio.fields.UtcTimeOnlyEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class UtcTimestampEncoder {
    public static final long MIN_EPOCH_MILLIS = -62135596800000L;
    public static final long MAX_EPOCH_MILLIS = 253402300799999L;
    public static final long MIN_EPOCH_MICROS = -62135596800000000L;
    public static final long MAX_EPOCH_MICROS = 253402300799999999L;
    public static final int LENGTH_WITHOUT_MILLISECONDS = 17;
    public static final int LENGTH_WITH_MILLISECONDS = 21;
    public static final int LENGTH_WITH_MICROSECONDS = 24;
    private static final int LENGTH_OF_DATE = 8;
    private static final int LENGTH_OF_DATE_AND_DASH = 9;
    private final boolean usesMilliseconds;
    private final byte[] bytes = new byte[24];
    private final MutableAsciiBuffer flyweight = new MutableAsciiBuffer(this.bytes);
    private long startOfNextDayInFraction;
    private long beginningOfDayInFraction;

    public UtcTimestampEncoder() {
        this(true);
    }

    public UtcTimestampEncoder(boolean usesMilliseconds) {
        this.usesMilliseconds = usesMilliseconds;
        this.flyweight.wrap(this.bytes);
    }

    public int encode(long epochFraction) {
        if (this.usesMilliseconds) {
            return UtcTimestampEncoder.encode(epochFraction, this.flyweight, 0);
        }
        return UtcTimestampEncoder.encodeMicros(epochFraction, this.flyweight, 0);
    }

    public int initialise(long epochFraction) {
        int lengthWithFraction;
        int fractionFieldLength;
        long fractionInDay;
        long fractionInSecond;
        long maxEpochFraction;
        long minEpochFraction;
        if (this.usesMilliseconds) {
            minEpochFraction = -62135596800000L;
            maxEpochFraction = 253402300799999L;
            fractionInSecond = 1000L;
            fractionInDay = 86400000L;
            fractionFieldLength = 3;
            lengthWithFraction = 21;
        } else {
            minEpochFraction = -62135596800000000L;
            maxEpochFraction = 253402300799999999L;
            fractionInSecond = 1000000L;
            fractionInDay = 86400000000L;
            fractionFieldLength = 6;
            lengthWithFraction = 24;
        }
        UtcTimestampEncoder.validate(epochFraction, minEpochFraction, maxEpochFraction);
        long localSecond = UtcTimestampEncoder.localSecond(epochFraction, fractionInSecond);
        long epochDay = UtcTimestampEncoder.epochDay(localSecond);
        int fractionOfSecond = UtcTimestampEncoder.fractionOfSecond(epochFraction, fractionInSecond);
        this.startOfNextDayInFraction = (epochDay + 1L) * fractionInDay;
        this.beginningOfDayInFraction = this.startOfNextDayInFraction - fractionInDay;
        CalendricalUtil.encodeDate(epochDay, this.flyweight, 0);
        this.flyweight.putChar(8, '-');
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, this.flyweight, 9, fractionFieldLength);
        return fractionOfSecond > 0 ? lengthWithFraction : 17;
    }

    public int update(long epochFraction) {
        int lengthWithFraction;
        int fractionFieldLength;
        long fractionInSecond;
        if (epochFraction > this.startOfNextDayInFraction || epochFraction < this.beginningOfDayInFraction) {
            return this.initialise(epochFraction);
        }
        if (this.usesMilliseconds) {
            fractionInSecond = 1000L;
            fractionFieldLength = 3;
            lengthWithFraction = 21;
        } else {
            fractionInSecond = 1000000L;
            fractionFieldLength = 6;
            lengthWithFraction = 24;
        }
        long localSecond = UtcTimestampEncoder.localSecond(epochFraction, fractionInSecond);
        int fractionOfSecond = UtcTimestampEncoder.fractionOfSecond(epochFraction, fractionInSecond);
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, this.flyweight, 9, fractionFieldLength);
        return fractionOfSecond > 0 ? lengthWithFraction : 17;
    }

    public byte[] buffer() {
        return this.bytes;
    }

    public static int encode(long epochMillis, MutableAsciiBuffer string, int offset) {
        return UtcTimestampEncoder.encodeFraction(epochMillis, string, offset, -62135596800000L, 253402300799999L, 1000L, 21, 3);
    }

    public static int encodeMicros(long epochMicros, MutableAsciiBuffer string, int offset) {
        return UtcTimestampEncoder.encodeFraction(epochMicros, string, offset, -62135596800000000L, 253402300799999999L, 1000000L, 24, 6);
    }

    private static int encodeFraction(long epochFraction, MutableAsciiBuffer string, int offset, long minEpochFraction, long maxEpochFraction, long fractionInSecond, int lengthWithFraction, int fractionFieldLength) {
        UtcTimestampEncoder.validate(epochFraction, minEpochFraction, maxEpochFraction);
        long localSecond = UtcTimestampEncoder.localSecond(epochFraction, fractionInSecond);
        long epochDay = UtcTimestampEncoder.epochDay(localSecond);
        int fractionOfSecond = UtcTimestampEncoder.fractionOfSecond(epochFraction, fractionInSecond);
        CalendricalUtil.encodeDate(epochDay, string, offset);
        string.putChar(offset + 8, '-');
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, string, offset + 9, fractionFieldLength);
        return fractionOfSecond > 0 ? lengthWithFraction : 17;
    }

    private static long epochDay(long localSecond) {
        return Math.floorDiv(localSecond, 86400L);
    }

    private static int fractionOfSecond(long epochFraction, long fractionInSecond) {
        return (int)Math.floorMod(epochFraction, fractionInSecond);
    }

    private static long localSecond(long epochFraction, long fractionInSecond) {
        return Math.floorDiv(epochFraction, fractionInSecond);
    }

    private static void validate(long epochFraction, long minEpochFraction, long maxEpochFraction) {
        if (epochFraction < minEpochFraction || epochFraction > maxEpochFraction) {
            throw new IllegalArgumentException(epochFraction + " is outside of the valid range for this encoder");
        }
    }
}

