/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.ir;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.agrona.Verify;
import uk.co.real_logic.artio.dictionary.ir.Entry;

public final class Field
implements Entry.Element {
    private final int number;
    private final String name;
    private Type type;
    private final List<Value> values;

    public static Field registerField(Map<String, Field> nameToField, int number, String name, Type type) {
        Field field = new Field(number, name, type);
        nameToField.put(name, field);
        return field;
    }

    public Field(int number, String name, Type type) {
        this.number = number;
        this.name = name;
        this.type = type;
        this.values = new ArrayList<Value>();
    }

    public Type type() {
        return this.type;
    }

    public void type(Type type) {
        Verify.notNull((Object)((Object)type), (String)"type");
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    public int number() {
        return this.number;
    }

    public List<Value> values() {
        return this.values;
    }

    public Field addValue(String representation, String description) {
        this.values().add(new Value(representation, description));
        return this;
    }

    public boolean isEnum() {
        return !this.values.isEmpty();
    }

    public String toString() {
        return "EnumField{number=" + this.number + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", values=" + this.values + '}';
    }

    public static class Value {
        private final String representation;
        private final String description;

        public Value(String representation, String description) {
            this.representation = representation;
            this.description = description;
        }

        public String representation() {
            return this.representation;
        }

        public String description() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return Objects.equals(this.representation, value.representation) && Objects.equals(this.description, value.description);
        }

        public int hashCode() {
            int result = this.representation.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Value{representation=" + this.representation + ", description='" + this.description + '\'' + '}';
        }
    }

    public static enum Type {
        INT(false, true, false, false, false, false),
        LENGTH(false, true, false, false, false, false),
        SEQNUM(false, true, false, false, false, false),
        NUMINGROUP(false, true, false, false, false, false),
        DAYOFMONTH(false, true, false, false, false, false),
        FLOAT(false, false, true, false, false, false),
        PRICE(false, false, true, false, false, false),
        PRICEOFFSET(false, false, true, false, false, false),
        QTY(false, false, true, false, false, false),
        PERCENTAGE(false, false, true, false, false, false),
        AMT(false, false, true, false, false, false),
        CHAR(false, false, false, false, false, false),
        MULTIPLECHARVALUE(true, false, false, true, true, true),
        STRING(true, false, false, true, true, false),
        MULTIPLEVALUESTRING(true, false, false, true, true, true),
        MULTIPLESTRINGVALUE(true, false, false, true, true, true),
        CURRENCY(true, false, false, true, true, false),
        EXCHANGE(true, false, false, true, true, false),
        COUNTRY(true, false, false, true, true, false),
        LANGUAGE(true, false, false, true, true, false),
        DATA(false, false, false, false, false, false),
        XMLDATA(false, false, false, false, false, false),
        BOOLEAN(false, false, false, false, false, false),
        UTCTIMESTAMP(true, false, false, true, true, false),
        UTCTIMEONLY(true, false, false, true, true, false),
        UTCDATEONLY(true, false, false, true, true, false),
        LOCALMKTDATE(true, false, false, true, true, false),
        MONTHYEAR(true, false, false, true, true, false),
        TZTIMEONLY(true, false, false, true, true, false),
        TZTIMESTAMP(true, false, false, true, true, false);

        private final boolean isStringBased;
        private final boolean isIntBased;
        private final boolean isFloatBased;
        private final boolean hasLengthField;
        private final boolean hasOffsetField;
        private final boolean isMultiValue;

        private Type(boolean isStringBased, boolean isIntBased, boolean isFloatBased, boolean hasLengthField, boolean hasOffsetField, boolean isMultiValue) {
            this.isStringBased = isStringBased;
            this.isIntBased = isIntBased;
            this.isFloatBased = isFloatBased;
            this.hasLengthField = hasLengthField;
            this.hasOffsetField = hasOffsetField;
            this.isMultiValue = isMultiValue;
        }

        public boolean isStringBased() {
            return this.isStringBased;
        }

        public boolean isIntBased() {
            return this.isIntBased;
        }

        public boolean isFloatBased() {
            return this.isFloatBased;
        }

        public boolean hasLengthField() {
            return this.hasLengthField;
        }

        public boolean hasOffsetField() {
            return this.hasOffsetField;
        }

        public boolean isMultiValue() {
            return this.isMultiValue;
        }

        public static Type lookup(String name) {
            if ("UTCDATE".equals(name)) {
                return UTCDATEONLY;
            }
            return Type.valueOf(name);
        }
    }
}

