/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class UtcTimeOnlyEncoder {
    public static final int LENGTH_WITHOUT_MILLISECONDS = 8;
    public static final int LENGTH_WITH_MILLISECONDS = 12;
    public static final int LENGTH_WITH_MICROSECONDS = 15;
    public static final int LENGTH_WITH_NANOSECONDS = 18;
    private final MutableAsciiBuffer flyweight = new MutableAsciiBuffer();

    public int encode(long millisecondOfDay, byte[] bytes) {
        this.flyweight.wrap(bytes);
        return UtcTimeOnlyEncoder.encode(millisecondOfDay, this.flyweight, 0);
    }

    public static int encode(long millisecondOfDay, MutableAsciiBuffer string, int offset) {
        long localSecond = Math.floorDiv(millisecondOfDay, 1000L);
        int fractionOfSecond = (int)Math.floorMod(millisecondOfDay, 1000L);
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, string, offset, 3);
        return fractionOfSecond > 0 ? 12 : 8;
    }

    public static int encodeMicros(long microsecondOfDay, MutableAsciiBuffer string, int offset) {
        long localSecond = Math.floorDiv(microsecondOfDay, 1000000L);
        int fractionOfSecond = (int)Math.floorMod(microsecondOfDay, 1000000L);
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, string, offset, 6);
        return fractionOfSecond > 0 ? 15 : 8;
    }

    public static int encodeNanos(long nanosecondOfDay, MutableAsciiBuffer string, int offset) {
        long localSecond = Math.floorDiv(nanosecondOfDay, 1000000000L);
        int fractionOfSecond = (int)Math.floorMod(nanosecondOfDay, 1000000000L);
        UtcTimeOnlyEncoder.encodeFraction(localSecond, fractionOfSecond, string, offset, 9);
        return fractionOfSecond > 0 ? 18 : 8;
    }

    static void encodeFraction(long epochSecond, int fractionOfSecond, MutableAsciiBuffer string, int offset, int fractionFieldLength) {
        int secondOfDay = Math.floorMod(epochSecond, 86400);
        int hours = secondOfDay / 3600;
        int minutes = (secondOfDay -= hours * 3600) / 60;
        string.putNaturalPaddedIntAscii(offset, 2, hours);
        string.putChar(offset + 2, ':');
        string.putNaturalPaddedIntAscii(offset + 3, 2, minutes);
        string.putChar(offset + 5, ':');
        string.putNaturalPaddedIntAscii(offset + 6, 2, secondOfDay -= minutes * 60);
        string.putChar(offset + 8, '.');
        string.putNaturalPaddedIntAscii(offset + 9, fractionFieldLength, fractionOfSecond);
    }
}

