/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.InitialAcceptedSessionOwner;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class ControlNotificationDecoder {
    public static final int BLOCK_LENGTH = 5;
    public static final int TEMPLATE_ID = 39;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 26;
    public static final String SEMANTIC_VERSION = "0.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ControlNotificationDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final SessionsDecoder sessions = new SessionsDecoder(this);
    private final DisconnectedSessionsDecoder disconnectedSessions = new DisconnectedSessionsDecoder(this);

    public int sbeBlockLength() {
        return 5;
    }

    public int sbeTemplateId() {
        return 39;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 26;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ControlNotificationDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ControlNotificationDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (39 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ControlNotificationDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, BYTE_ORDER);
    }

    public static int initialAcceptedSessionOwnerId() {
        return 3;
    }

    public static int initialAcceptedSessionOwnerSinceVersion() {
        return 10;
    }

    public static int initialAcceptedSessionOwnerEncodingOffset() {
        return 4;
    }

    public static int initialAcceptedSessionOwnerEncodingLength() {
        return 1;
    }

    public static String initialAcceptedSessionOwnerMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short initialAcceptedSessionOwnerRaw() {
        if (this.parentMessage.actingVersion < 10) {
            return 255;
        }
        return (short)(this.buffer.getByte(this.offset + 4) & 0xFF);
    }

    public InitialAcceptedSessionOwner initialAcceptedSessionOwner() {
        if (this.parentMessage.actingVersion < 10) {
            return InitialAcceptedSessionOwner.NULL_VAL;
        }
        return InitialAcceptedSessionOwner.get((short)(this.buffer.getByte(this.offset + 4) & 0xFF));
    }

    public static long sessionsDecoderId() {
        return 2L;
    }

    public static int sessionsDecoderSinceVersion() {
        return 0;
    }

    public SessionsDecoder sessions() {
        this.sessions.wrap(this.buffer);
        return this.sessions;
    }

    public static long disconnectedSessionsDecoderId() {
        return 4L;
    }

    public static int disconnectedSessionsDecoderSinceVersion() {
        return 0;
    }

    public DisconnectedSessionsDecoder disconnectedSessions() {
        this.disconnectedSessions.wrap(this.buffer);
        return this.disconnectedSessions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ControlNotificationDecoder decoder = new ControlNotificationDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ControlNotification](sbeTemplateId=");
        builder.append(39);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 26) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(26);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 5) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(5);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("initialAcceptedSessionOwner=");
        builder.append((Object)this.initialAcceptedSessionOwner());
        builder.append('|');
        builder.append("sessions=[");
        int sessionsOriginalOffset = this.sessions.offset;
        int sessionsOriginalIndex = this.sessions.index;
        SessionsDecoder sessions = this.sessions();
        if (sessions.count() > 0) {
            while (sessions.hasNext()) {
                sessions.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        sessions.offset = sessionsOriginalOffset;
        sessions.index = sessionsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("disconnectedSessions=[");
        int disconnectedSessionsOriginalOffset = this.disconnectedSessions.offset;
        int disconnectedSessionsOriginalIndex = this.disconnectedSessions.index;
        DisconnectedSessionsDecoder disconnectedSessions = this.disconnectedSessions();
        if (disconnectedSessions.count() > 0) {
            while (disconnectedSessions.hasNext()) {
                disconnectedSessions.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        disconnectedSessions.offset = disconnectedSessionsOriginalOffset;
        disconnectedSessions.index = disconnectedSessionsOriginalIndex;
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public ControlNotificationDecoder sbeSkip() {
        DisconnectedSessionsDecoder disconnectedSessions;
        this.sbeRewind();
        SessionsDecoder sessions = this.sessions();
        if (sessions.count() > 0) {
            while (sessions.hasNext()) {
                sessions.next();
                sessions.sbeSkip();
            }
        }
        if ((disconnectedSessions = this.disconnectedSessions()).count() > 0) {
            while (disconnectedSessions.hasNext()) {
                disconnectedSessions.next();
                disconnectedSessions.sbeSkip();
            }
        }
        return this;
    }

    public static final class SessionsDecoder
    implements Iterable<SessionsDecoder>,
    Iterator<SessionsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final ControlNotificationDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        SessionsDecoder(ControlNotificationDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public SessionsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int actingVersion() {
            return this.parentMessage.actingVersion;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<SessionsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int sessionIdId() {
            return 10;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long sessionId() {
            return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("sessionId=");
            builder.append(this.sessionId());
            builder.append(')');
            return builder;
        }

        public SessionsDecoder sbeSkip() {
            return this;
        }
    }

    public static final class DisconnectedSessionsDecoder
    implements Iterable<DisconnectedSessionsDecoder>,
    Iterator<DisconnectedSessionsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final ControlNotificationDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        DisconnectedSessionsDecoder(ControlNotificationDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public DisconnectedSessionsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int actingVersion() {
            return this.parentMessage.actingVersion;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<DisconnectedSessionsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int sessionIdId() {
            return 10;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long sessionId() {
            return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("sessionId=");
            builder.append(this.sessionId());
            builder.append(')');
            return builder;
        }

        public DisconnectedSessionsDecoder sbeSkip() {
            return this;
        }
    }
}

