/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.ResetSequenceNumber;
import uk.co.real_logic.artio.messages.SequenceNumberType;

public final class InitiateConnectionDecoder {
    public static final int BLOCK_LENGTH = 37;
    public static final int TEMPLATE_ID = 11;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 26;
    public static final String SEMANTIC_VERSION = "0.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final InitiateConnectionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 37;
    }

    public int sbeTemplateId() {
        return 11;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 26;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public InitiateConnectionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public InitiateConnectionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (11 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public InitiateConnectionDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, BYTE_ORDER);
    }

    public static int requestedInitialReceivedSequenceNumberId() {
        return 2;
    }

    public static int requestedInitialReceivedSequenceNumberSinceVersion() {
        return 0;
    }

    public static int requestedInitialReceivedSequenceNumberEncodingOffset() {
        return 4;
    }

    public static int requestedInitialReceivedSequenceNumberEncodingLength() {
        return 4;
    }

    public static String requestedInitialReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int requestedInitialReceivedSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestedInitialReceivedSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int requestedInitialReceivedSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int requestedInitialReceivedSequenceNumber() {
        return this.buffer.getInt(this.offset + 4, BYTE_ORDER);
    }

    public static int sequenceNumberTypeId() {
        return 3;
    }

    public static int sequenceNumberTypeSinceVersion() {
        return 0;
    }

    public static int sequenceNumberTypeEncodingOffset() {
        return 8;
    }

    public static int sequenceNumberTypeEncodingLength() {
        return 1;
    }

    public static String sequenceNumberTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short sequenceNumberTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 8) & 0xFF);
    }

    public SequenceNumberType sequenceNumberType() {
        return SequenceNumberType.get((short)(this.buffer.getByte(this.offset + 8) & 0xFF));
    }

    public static int portId() {
        return 4;
    }

    public static int portSinceVersion() {
        return 0;
    }

    public static int portEncodingOffset() {
        return 9;
    }

    public static int portEncodingLength() {
        return 4;
    }

    public static String portMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int portNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int portMinValue() {
        return -2147483647;
    }

    public static int portMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int port() {
        return this.buffer.getInt(this.offset + 9, BYTE_ORDER);
    }

    public static int heartbeatIntervalInSId() {
        return 5;
    }

    public static int heartbeatIntervalInSSinceVersion() {
        return 0;
    }

    public static int heartbeatIntervalInSEncodingOffset() {
        return 13;
    }

    public static int heartbeatIntervalInSEncodingLength() {
        return 4;
    }

    public static String heartbeatIntervalInSMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int heartbeatIntervalInSNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int heartbeatIntervalInSMinValue() {
        return -2147483647;
    }

    public static int heartbeatIntervalInSMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int heartbeatIntervalInS() {
        return this.buffer.getInt(this.offset + 13, BYTE_ORDER);
    }

    public static int resetSequenceNumberId() {
        return 6;
    }

    public static int resetSequenceNumberSinceVersion() {
        return 0;
    }

    public static int resetSequenceNumberEncodingOffset() {
        return 17;
    }

    public static int resetSequenceNumberEncodingLength() {
        return 1;
    }

    public static String resetSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short resetSequenceNumberRaw() {
        return (short)(this.buffer.getByte(this.offset + 17) & 0xFF);
    }

    public ResetSequenceNumber resetSequenceNumber() {
        return ResetSequenceNumber.get((short)(this.buffer.getByte(this.offset + 17) & 0xFF));
    }

    public static int correlationIdId() {
        return 7;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 18;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 18, BYTE_ORDER);
    }

    public static int requestedInitialSentSequenceNumberId() {
        return 17;
    }

    public static int requestedInitialSentSequenceNumberSinceVersion() {
        return 0;
    }

    public static int requestedInitialSentSequenceNumberEncodingOffset() {
        return 26;
    }

    public static int requestedInitialSentSequenceNumberEncodingLength() {
        return 4;
    }

    public static String requestedInitialSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int requestedInitialSentSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestedInitialSentSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int requestedInitialSentSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int requestedInitialSentSequenceNumber() {
        return this.buffer.getInt(this.offset + 26, BYTE_ORDER);
    }

    public static int closedResendIntervalId() {
        return 18;
    }

    public static int closedResendIntervalSinceVersion() {
        return 0;
    }

    public static int closedResendIntervalEncodingOffset() {
        return 30;
    }

    public static int closedResendIntervalEncodingLength() {
        return 1;
    }

    public static String closedResendIntervalMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short closedResendIntervalRaw() {
        return (short)(this.buffer.getByte(this.offset + 30) & 0xFF);
    }

    public Bool closedResendInterval() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 30) & 0xFF));
    }

    public static int resendRequestChunkSizeId() {
        return 19;
    }

    public static int resendRequestChunkSizeSinceVersion() {
        return 0;
    }

    public static int resendRequestChunkSizeEncodingOffset() {
        return 31;
    }

    public static int resendRequestChunkSizeEncodingLength() {
        return 4;
    }

    public static String resendRequestChunkSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int resendRequestChunkSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int resendRequestChunkSizeMinValue() {
        return -2147483647;
    }

    public static int resendRequestChunkSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int resendRequestChunkSize() {
        return this.buffer.getInt(this.offset + 31, BYTE_ORDER);
    }

    public static int sendRedundantResendRequestsId() {
        return 20;
    }

    public static int sendRedundantResendRequestsSinceVersion() {
        return 0;
    }

    public static int sendRedundantResendRequestsEncodingOffset() {
        return 35;
    }

    public static int sendRedundantResendRequestsEncodingLength() {
        return 1;
    }

    public static String sendRedundantResendRequestsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short sendRedundantResendRequestsRaw() {
        return (short)(this.buffer.getByte(this.offset + 35) & 0xFF);
    }

    public Bool sendRedundantResendRequests() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 35) & 0xFF));
    }

    public static int enableLastMsgSeqNumProcessedId() {
        return 21;
    }

    public static int enableLastMsgSeqNumProcessedSinceVersion() {
        return 0;
    }

    public static int enableLastMsgSeqNumProcessedEncodingOffset() {
        return 36;
    }

    public static int enableLastMsgSeqNumProcessedEncodingLength() {
        return 1;
    }

    public static String enableLastMsgSeqNumProcessedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short enableLastMsgSeqNumProcessedRaw() {
        return (short)(this.buffer.getByte(this.offset + 36) & 0xFF);
    }

    public Bool enableLastMsgSeqNumProcessed() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 36) & 0xFF));
    }

    public static int hostId() {
        return 8;
    }

    public static int hostSinceVersion() {
        return 0;
    }

    public static String hostCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String hostMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int hostHeaderLength() {
        return 2;
    }

    public int hostLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipHost() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getHost(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getHost(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapHost(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String host() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int senderCompIdId() {
        return 9;
    }

    public static int senderCompIdSinceVersion() {
        return 0;
    }

    public static String senderCompIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String senderCompIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int senderCompIdHeaderLength() {
        return 2;
    }

    public int senderCompIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipSenderCompId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getSenderCompId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSenderCompId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapSenderCompId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String senderCompId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int senderSubIdId() {
        return 10;
    }

    public static int senderSubIdSinceVersion() {
        return 0;
    }

    public static String senderSubIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String senderSubIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int senderSubIdHeaderLength() {
        return 2;
    }

    public int senderSubIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipSenderSubId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getSenderSubId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSenderSubId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapSenderSubId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String senderSubId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int senderLocationIdId() {
        return 11;
    }

    public static int senderLocationIdSinceVersion() {
        return 0;
    }

    public static String senderLocationIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String senderLocationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int senderLocationIdHeaderLength() {
        return 2;
    }

    public int senderLocationIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipSenderLocationId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getSenderLocationId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSenderLocationId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapSenderLocationId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String senderLocationId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int targetCompIdId() {
        return 12;
    }

    public static int targetCompIdSinceVersion() {
        return 0;
    }

    public static String targetCompIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String targetCompIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int targetCompIdHeaderLength() {
        return 2;
    }

    public int targetCompIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipTargetCompId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getTargetCompId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getTargetCompId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapTargetCompId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String targetCompId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int targetSubIdId() {
        return 13;
    }

    public static int targetSubIdSinceVersion() {
        return 0;
    }

    public static String targetSubIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String targetSubIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int targetSubIdHeaderLength() {
        return 2;
    }

    public int targetSubIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipTargetSubId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getTargetSubId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getTargetSubId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapTargetSubId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String targetSubId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int targetLocationIdId() {
        return 14;
    }

    public static int targetLocationIdSinceVersion() {
        return 0;
    }

    public static String targetLocationIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String targetLocationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int targetLocationIdHeaderLength() {
        return 2;
    }

    public int targetLocationIdLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipTargetLocationId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getTargetLocationId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getTargetLocationId(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapTargetLocationId(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String targetLocationId() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int usernameId() {
        return 15;
    }

    public static int usernameSinceVersion() {
        return 0;
    }

    public static String usernameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String usernameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int usernameHeaderLength() {
        return 2;
    }

    public int usernameLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipUsername() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getUsername(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getUsername(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapUsername(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String username() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int passwordId() {
        return 16;
    }

    public static int passwordSinceVersion() {
        return 0;
    }

    public static String passwordCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String passwordMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int passwordHeaderLength() {
        return 2;
    }

    public int passwordLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipPassword() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getPassword(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getPassword(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapPassword(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String password() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int fixDictionaryId() {
        return 22;
    }

    public static int fixDictionarySinceVersion() {
        return 0;
    }

    public static String fixDictionaryCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String fixDictionaryMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int fixDictionaryHeaderLength() {
        return 2;
    }

    public int fixDictionaryLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipFixDictionary() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getFixDictionary(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getFixDictionary(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapFixDictionary(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String fixDictionary() {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        InitiateConnectionDecoder decoder = new InitiateConnectionDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[InitiateConnection](sbeTemplateId=");
        builder.append(11);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 26) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(26);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 37) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(37);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("requestedInitialReceivedSequenceNumber=");
        builder.append(this.requestedInitialReceivedSequenceNumber());
        builder.append('|');
        builder.append("sequenceNumberType=");
        builder.append((Object)this.sequenceNumberType());
        builder.append('|');
        builder.append("port=");
        builder.append(this.port());
        builder.append('|');
        builder.append("heartbeatIntervalInS=");
        builder.append(this.heartbeatIntervalInS());
        builder.append('|');
        builder.append("resetSequenceNumber=");
        builder.append((Object)this.resetSequenceNumber());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("requestedInitialSentSequenceNumber=");
        builder.append(this.requestedInitialSentSequenceNumber());
        builder.append('|');
        builder.append("closedResendInterval=");
        builder.append((Object)this.closedResendInterval());
        builder.append('|');
        builder.append("resendRequestChunkSize=");
        builder.append(this.resendRequestChunkSize());
        builder.append('|');
        builder.append("sendRedundantResendRequests=");
        builder.append((Object)this.sendRedundantResendRequests());
        builder.append('|');
        builder.append("enableLastMsgSeqNumProcessed=");
        builder.append((Object)this.enableLastMsgSeqNumProcessed());
        builder.append('|');
        builder.append("host=");
        builder.append('\'').append(this.host()).append('\'');
        builder.append('|');
        builder.append("senderCompId=");
        builder.append('\'').append(this.senderCompId()).append('\'');
        builder.append('|');
        builder.append("senderSubId=");
        builder.append('\'').append(this.senderSubId()).append('\'');
        builder.append('|');
        builder.append("senderLocationId=");
        builder.append('\'').append(this.senderLocationId()).append('\'');
        builder.append('|');
        builder.append("targetCompId=");
        builder.append('\'').append(this.targetCompId()).append('\'');
        builder.append('|');
        builder.append("targetSubId=");
        builder.append('\'').append(this.targetSubId()).append('\'');
        builder.append('|');
        builder.append("targetLocationId=");
        builder.append('\'').append(this.targetLocationId()).append('\'');
        builder.append('|');
        builder.append("username=");
        builder.append('\'').append(this.username()).append('\'');
        builder.append('|');
        builder.append("password=");
        builder.append('\'').append(this.password()).append('\'');
        builder.append('|');
        builder.append("fixDictionary=");
        builder.append('\'').append(this.fixDictionary()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public InitiateConnectionDecoder sbeSkip() {
        this.sbeRewind();
        this.skipHost();
        this.skipSenderCompId();
        this.skipSenderSubId();
        this.skipSenderLocationId();
        this.skipTargetCompId();
        this.skipTargetSubId();
        this.skipTargetLocationId();
        this.skipUsername();
        this.skipPassword();
        this.skipFixDictionary();
        return this;
    }
}

