/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.sbe_util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import uk.co.real_logic.artio.messages.MessageSchemaLocation;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrEncoder;
import uk.co.real_logic.sbe.xml.IrGenerator;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.ParserOptions;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public final class MessageSchemaIr {
    private static final String PATH = "message-schema.xml";
    public static final Ir SCHEMA_IR = MessageSchemaIr.loadIr();
    public static final ByteBuffer SCHEMA_BUFFER = MessageSchemaIr.encodeSchema();

    private static Ir loadIr() {
        Ir ir;
        block8: {
            InputStream in = MessageSchemaLocation.class.getResourceAsStream(PATH);
            try {
                MessageSchema schema = XmlSchemaParser.parse((InputStream)in, (ParserOptions)ParserOptions.DEFAULT);
                ir = new IrGenerator().generate(schema);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            in.close();
        }
        return ir;
    }

    private static ByteBuffer encodeSchema() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        try (IrEncoder irEncoder = new IrEncoder(byteBuffer, SCHEMA_IR);){
            irEncoder.encode();
        }
        byteBuffer.flip();
        return byteBuffer;
    }
}

