/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.InputStream;
import java.util.function.BiFunction;
import org.agrona.generation.OutputManager;
import org.agrona.generation.PackageOutputManager;
import uk.co.real_logic.artio.dictionary.generation.GeneratorDictionaryConfiguration;
import uk.co.real_logic.artio.dictionary.generation.SharedCodecConfiguration;

public final class CodecConfiguration {
    public static final String FIX_CODECS_ALLOW_DUPLICATE_FIELDS_PROPERTY = "fix.codecs.allow_duplicate_fields";
    public static final String WRAP_EMPTY_BUFFER = "fix.codecs.wrap_empty_buffer";
    public static final String PARENT_PACKAGE_PROPERTY = "fix.codecs.parent_package";
    public static final String FLYWEIGHTS_ENABLED_PROPERTY = "fix.codecs.flyweight";
    public static final String REJECT_UNKNOWN_ENUM_VALUE_PROPERTY = "reject.unknown.enum.value";
    public static final String FIX_TAGS_IN_JAVADOC = "fix.codecs.tags_in_javadoc";
    public static final String DEFAULT_PARENT_PACKAGE = "uk.co.real_logic.artio";
    public static final String DEFAULT_FIX_TAGS_IN_JAVADOC = "true";
    private String parentPackage = System.getProperty("fix.codecs.parent_package", "uk.co.real_logic.artio");
    private boolean flyweightsEnabled = Boolean.getBoolean("fix.codecs.flyweight");
    private boolean wrapEmptyBuffer = Boolean.getBoolean("fix.codecs.wrap_empty_buffer");
    private boolean fixTagsInJavadoc = Boolean.parseBoolean(System.getProperty("fix.codecs.tags_in_javadoc", "true"));
    private SharedCodecConfiguration sharedCodecConfiguration;
    private String codecRejectUnknownEnumValueEnabled;
    private String outputPath;
    private BiFunction<String, String, OutputManager> outputManagerFactory = PackageOutputManager::new;
    private final GeneratorDictionaryConfiguration nonSharedDictionary = new GeneratorDictionaryConfiguration(null, null, null, Boolean.getBoolean("fix.codecs.allow_duplicate_fields"));

    public CodecConfiguration outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    public CodecConfiguration parentPackage(String parentPackage) {
        this.parentPackage = parentPackage;
        return this;
    }

    public CodecConfiguration flyweightsEnabled(boolean flyweightsEnabled) {
        this.flyweightsEnabled = flyweightsEnabled;
        return this;
    }

    public CodecConfiguration wrapEmptyBuffer(boolean wrapEmptyBuffer) {
        this.wrapEmptyBuffer = wrapEmptyBuffer;
        return this;
    }

    public CodecConfiguration allowDuplicateFields(boolean allowDuplicateFields) {
        this.nonSharedDictionary.allowDuplicateFields(allowDuplicateFields);
        return this;
    }

    public CodecConfiguration fileNames(String ... fileNames) {
        this.nonSharedDictionary.fileNames(fileNames);
        return this;
    }

    public CodecConfiguration fileStreams(InputStream ... fileStreams) {
        this.nonSharedDictionary.fileStreams(fileStreams);
        return this;
    }

    CodecConfiguration outputManagerFactory(BiFunction<String, String, OutputManager> outputManagerFactory) {
        this.outputManagerFactory = outputManagerFactory;
        return this;
    }

    public CodecConfiguration codecRejectUnknownEnumValueEnabled(String codecRejectUnknownEnumValueEnabled) {
        this.codecRejectUnknownEnumValueEnabled = codecRejectUnknownEnumValueEnabled;
        return this;
    }

    public SharedCodecConfiguration sharedCodecsEnabled() {
        this.sharedCodecConfiguration = new SharedCodecConfiguration(this.nonSharedDictionary().allowDuplicateFields());
        return this.sharedCodecConfiguration;
    }

    public CodecConfiguration fixTagsInJavadoc(boolean fixTagsInJavadoc) {
        this.fixTagsInJavadoc = fixTagsInJavadoc;
        return this;
    }

    String outputPath() {
        return this.outputPath;
    }

    String parentPackage() {
        return this.parentPackage;
    }

    boolean flyweightsEnabled() {
        return this.flyweightsEnabled;
    }

    boolean wrapEmptyBuffer() {
        return this.wrapEmptyBuffer;
    }

    String codecRejectUnknownEnumValueEnabled() {
        return this.codecRejectUnknownEnumValueEnabled;
    }

    SharedCodecConfiguration sharedCodecConfiguration() {
        return this.sharedCodecConfiguration;
    }

    public GeneratorDictionaryConfiguration nonSharedDictionary() {
        return this.nonSharedDictionary;
    }

    BiFunction<String, String, OutputManager> outputManagerFactory() {
        return this.outputManagerFactory;
    }

    public boolean fixTagsInJavadoc() {
        return this.fixTagsInJavadoc;
    }

    void conclude() {
        if (this.outputPath() == null) {
            throw new IllegalArgumentException("Missing outputPath() configuration property");
        }
        if (this.codecRejectUnknownEnumValueEnabled == null) {
            String rejectUnknownEnumPropertyValue = System.getProperty(REJECT_UNKNOWN_ENUM_VALUE_PROPERTY);
            String string = this.codecRejectUnknownEnumValueEnabled = rejectUnknownEnumPropertyValue != null ? rejectUnknownEnumPropertyValue : "CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED";
        }
        if (this.sharedCodecConfiguration != null) {
            if (this.nonSharedDictionary.hasStreams()) {
                throw new IllegalArgumentException("Cannot mix shared codec configuration with providing file streams or names via the non-shared configuration option. If you want to provide dictionaries for sharing then use SharedCodecConfiguration.withDictionary().");
            }
        } else if (!this.nonSharedDictionary.hasStreams()) {
            throw new IllegalArgumentException("Please provide a path to the XML files either through the fileNames() or fileStreams() option.");
        }
    }
}

