/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util.float_parsing;

import uk.co.real_logic.artio.util.float_parsing.CharReader;

public final class CharSequenceCharReader
implements CharReader<CharSequence> {
    private static final char ZERO = '0';
    public static final CharSequenceCharReader INSTANCE = new CharSequenceCharReader();

    private CharSequenceCharReader() {
    }

    @Override
    public boolean isSpace(CharSequence data, int index) {
        return Character.isSpaceChar(data.charAt(index));
    }

    @Override
    public char charAt(CharSequence data, int index) {
        return data.charAt(index);
    }

    @Override
    public CharSequence asString(CharSequence data, int offset, int length) {
        return data.subSequence(offset, offset + length);
    }

    @Override
    public boolean isZero(CharSequence data, int index) {
        return data.charAt(index) == '0';
    }

    @Override
    public int getDigit(CharSequence data, int index, char charValue) {
        if (charValue < '0' || charValue > '9') {
            throw new NumberFormatException("'" + charValue + "' isn't a valid digit @ " + index);
        }
        return charValue - 48;
    }
}

