/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import java.time.Year;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class CalendricalUtil {
    static final int SECONDS_IN_MINUTE = 60;
    static final int SECONDS_IN_HOUR = 3600;
    static final int SECONDS_IN_DAY = 86400;
    static final long MILLIS_IN_SECOND = 1000L;
    static final long MICROS_IN_MILLIS = 1000L;
    static final long MICROS_IN_SECOND = 1000000L;
    public static final long NANOS_IN_MICROS = 1000L;
    public static final long NANOS_IN_MILLIS = 1000000L;
    static final long NANOS_IN_SECOND = 1000000000L;
    static final long MILLIS_IN_DAY = 86400000L;
    static final long MICROS_IN_DAY = 86400000000L;
    static final long NANOS_IN_DAY = 86400000000000L;
    private static final int MAX_DAYS_IN_YEAR = 365;
    private static final int MONTHS_IN_YEAR = 12;
    private static final int DAYS_IN_400_YEAR_CYCLE = 146097;
    private static final int DAYS_UNTIL_START_OF_UNIX_EPOCH = 719528;
    private static final int MIN_MONTH = 1;
    private static final int MAX_MONTH = 12;
    private static final int MIN_DAY_OF_MONTH = 1;
    private static final int MAX_DAY_OF_MONTH = 31;

    private CalendricalUtil() {
    }

    public static boolean isValidMonth(int month) {
        return month >= 1 && month <= 12;
    }

    public static boolean isValidDayOfMonth(int dayOfMonth) {
        return dayOfMonth >= 1 && dayOfMonth <= 31;
    }

    static int getValidInt(AsciiBuffer timestamp, int startInclusive, int endExclusive, int min, int max) {
        int value = timestamp.getNatural(startInclusive, endExclusive);
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format("Invalid value: %s outside of range %d-%d", value, min, max));
        }
        return value;
    }

    static int toEpochDay(int year, int month, int day) {
        return CalendricalUtil.yearsToDays(year) + CalendricalUtil.monthsToDays(month, year) + (day - 1) - 719528;
    }

    private static int monthsToDays(int month, int year) {
        int days = (367 * month - 362) / 12;
        if (month > 2) {
            --days;
            if (!Year.isLeap(year)) {
                --days;
            }
        }
        return days;
    }

    private static int yearsToDays(int years) {
        return 365 * years + (years + 3) / 4 - (years + 99) / 100 + (years + 399) / 400;
    }

    static void encodeDate(long epochDay, MutableAsciiBuffer string, int offset) {
        long zeroDay = epochDay + 719528L - 60L;
        long yearEstimate = (400L * zeroDay + 591L) / 146097L;
        long dayEstimate = CalendricalUtil.estimateDayOfYear(zeroDay, yearEstimate);
        if (dayEstimate < 0L) {
            dayEstimate = CalendricalUtil.estimateDayOfYear(zeroDay, --yearEstimate);
        }
        int marchDay0 = (int)dayEstimate;
        int marchMonth0 = (marchDay0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int day = marchDay0 - (marchMonth0 * 306 + 5) / 10 + 1;
        int year = (int)(yearEstimate + (long)(marchMonth0 / 10));
        string.putNaturalPaddedIntAscii(offset, 4, year);
        string.putNaturalPaddedIntAscii(offset + 4, 2, month);
        string.putNaturalPaddedIntAscii(offset + 6, 2, day);
    }

    private static long estimateDayOfYear(long zeroDay, long yearEst) {
        return zeroDay - (365L * yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
    }
}

