/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.generation.OutputManager;
import org.agrona.generation.ResourceConsumer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.FieldBagEncoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.generation.Generator;
import uk.co.real_logic.artio.dictionary.generation.OptionalSessionFields;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.AnyFields;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

class EncoderGenerator
extends Generator {
    private static final Set<String> USED_SESSION_CODECS = new HashSet<String>(Arrays.asList("LogonEncoder", "ResendRequestEncoder", "LogoutEncoder", "HeartbeatEncoder", "RejectEncoder", "TestRequestEncoder", "SequenceResetEncoder", "BusinessMessageRejectEncoder"));
    private static final String TRAILER_ENCODE_PREFIX = "    long finishMessage(final MutableAsciiBuffer buffer, final int messageStart, final int offset)\n    {\n        int position = offset;\n\n        final int checkSum = buffer.computeChecksum(messageStart, position);\n        buffer.putBytes(position, checkSumHeader, 0, checkSumHeaderLength);\n        position += checkSumHeaderLength;\n        buffer.putNaturalPaddedIntAscii(position, 3, checkSum);\n        position += 3;\n        buffer.putSeparator(position);\n        position++;\n\n        return Encoder.result(position - messageStart, messageStart);\n    }\n    int startTrailer(final MutableAsciiBuffer buffer, final int offset)\n    {\n        final int start = offset;\n        int position = start;\n\n";
    private static final String HEADER_ENCODE_PREFIX = "    int finishHeader(final MutableAsciiBuffer buffer, final int bodyStart, final int bodyLength)\n    {\n        int position = bodyStart - 1;\n\n        buffer.putSeparator(position);\n        position = buffer.putNaturalIntAsciiFromEnd(bodyLength, position);\n        position -= bodyLengthHeaderLength;\n        buffer.putBytes(position, bodyLengthHeader, 0, bodyLengthHeaderLength);\n\n        if (beginStringLength > 0) {\n        position--;\n        buffer.putSeparator(position);\n        position -= beginStringLength;\n        buffer.putBytes(position, beginString, beginStringOffset, beginStringLength);\n        position -= beginStringHeaderLength;\n        buffer.putBytes(position, beginStringHeader, 0, beginStringHeaderLength);\n        } else if (CODEC_VALIDATION_ENABLED)\n        {\n            throw new EncodingException(\"Missing Field: BeginString\");\n        }\n\n        return position;\n    }\n\n    // 35=...| + other header fields\n    public long startMessage(final MutableAsciiBuffer buffer, final int offset)\n    {\n        final int start = offset + beginStringLength + 16;\n        int position = start;";
    private static final String GROUP_ENCODE_PREFIX = "    public int encode(final MutableAsciiBuffer buffer, final int offset, final int remainingElements)\n    {\n        if (remainingElements == 0)\n        {\n            return 0;\n        }\n\n        int position = offset;\n\n";
    private static final String MESSAGE_ENCODE_PREFIX = "    public long encode(final MutableAsciiBuffer buffer, final int offset)\n    {\n        final long startMessageResult = header.startMessage(buffer, offset);\n        final int bodyStart = Encoder.offset(startMessageResult);\n        int position = bodyStart + Encoder.length(startMessageResult);\n\n";
    private static final String OTHER_ENCODE_PREFIX = "    public int encode(final MutableAsciiBuffer buffer, final int offset)\n    {\n        int position = offset;\n\n";
    private static final String RESET_NEXT_GROUP = "        if (next != null)        {\n            next.reset();\n        }\n";
    private final byte[] buffer = new byte[MutableAsciiBuffer.LONGEST_INT_LENGTH + 1];
    private final MutableAsciiBuffer string = new MutableAsciiBuffer(this.buffer);
    private final String beginString;

    static String encoderClassName(String name) {
        return JavaUtil.formatClassName((String)(name + "Encoder"));
    }

    EncoderGenerator(Dictionary dictionary, String builderPackage, String builderCommonPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownFieldClass, Class<?> rejectUnknownEnumValueClass, String codecRejectUnknownEnumValueEnabled, boolean fixTagsInJavadoc) {
        super(dictionary, builderPackage, builderCommonPackage, outputManager, validationClass, rejectUnknownFieldClass, rejectUnknownEnumValueClass, false, codecRejectUnknownEnumValueEnabled, fixTagsInJavadoc);
        Component header = dictionary.header();
        this.validateHasField(header, "BeginString");
        this.validateHasField(header, "BodyLength");
        this.beginString = dictionary.beginString();
    }

    private void validateHasField(Component header, String fieldName) {
        if (!header.hasField(fieldName)) {
            throw new IllegalArgumentException("Header does not contain needed field : " + fieldName);
        }
    }

    @Override
    protected void generateAggregateFile(Aggregate aggregate, AggregateType aggregateType) {
        String className = EncoderGenerator.encoderClassName(aggregate.name());
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.thisPackage));
            if (USED_SESSION_CODECS.contains(className)) {
                out.append(GenerationUtil.importFor("uk.co.real_logic.artio.builder.Abstract" + className));
            }
            out.append(GenerationUtil.importFor(Generated.class));
            this.generateImports("Encoder", aggregateType, (Writer)out, DirectBuffer.class, MutableDirectBuffer.class, UnsafeBuffer.class, AsciiSequenceView.class, FieldBagEncoder.class);
            this.generateAggregateClass(aggregate, aggregateType, className, (Writer)out);
        });
    }

    @Override
    protected Class<?> topType(AggregateType aggregateType) {
        return Encoder.class;
    }

    @Override
    protected String resetGroup(Entry entry) {
        Group group = (Group)entry.element();
        String name = group.name();
        Entry numberField = group.numberField();
        String resetMethod = this.nameOfResetMethod(name);
        if (this.isSharedParent()) {
            return String.format("    public abstract void %1$s();\n\n", resetMethod);
        }
        return String.format("    public void %1$s()\n    {\n        if (%2$s != null)\n        {\n            %2$s.reset();\n        }\n        %3$s = 0;\n        has%4$s = false;\n    }\n\n", resetMethod, JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField.name()), numberField.name());
    }

    private void generateAggregateClass(Aggregate aggregate, AggregateType type, String className, Writer out) throws IOException {
        List<Object> interfaces;
        boolean isMessage;
        this.push(aggregate);
        boolean isHeader = type == AggregateType.HEADER;
        boolean bl = isMessage = type == AggregateType.MESSAGE;
        if (isMessage) {
            String parentName = USED_SESSION_CODECS.contains(className) ? "Abstract" + className : Encoder.class.getSimpleName();
            interfaces = Collections.singletonList(parentName);
        } else {
            interfaces = isHeader ? Collections.singletonList(SessionHeaderEncoder.class.getName()) : Collections.emptyList();
        }
        out.append(this.classDeclaration(className, interfaces, type == AggregateType.GROUP, aggregate.isInParent()));
        out.append(this.constructor(className, aggregate, type, this.dictionary));
        if (isMessage && !this.isSharedParent()) {
            out.append(this.commonCompoundImports("Encoder", false, ""));
        } else if (type == AggregateType.GROUP) {
            Group group = (Group)aggregate;
            if (this.isSharedParent()) {
                out.append(this.abstractNextMethod(group));
            } else {
                out.append(this.nextMethod(group));
            }
        } else if (type == AggregateType.HEADER) {
            out.append(String.format("\n    %2$s static final byte[] DEFAULT_BEGIN_STRING=\"%1$s\".getBytes(StandardCharsets.US_ASCII);\n\n", this.beginString, this.scope));
        }
        this.precomputedHeaders(out, aggregate.entries());
        this.generateSetters(out, className, aggregate.entries());
        out.append(this.encodeMethod(aggregate.entries(), type));
        String resetMethod = this.completeResetMethod(aggregate, isMessage, type);
        out.append(resetMethod);
        out.append(this.generateAppendTo(aggregate, isMessage));
        out.append(this.generateCopyTo(aggregate));
        out.append("}\n");
        this.pop();
    }

    private String classDeclaration(String className, List<String> interfaces, boolean isGroup, boolean inParent) {
        String extendsClause;
        String interfaceList;
        String string = interfaceList = interfaces.isEmpty() ? "" : " implements " + String.join((CharSequence)", ", interfaces);
        if (inParent) {
            String qualifiedName = className;
            if (isGroup) {
                qualifiedName = this.qualifiedAggregateStackNames(aggregate -> EncoderGenerator.encoderClassName(aggregate.name()));
            }
            extendsClause = " extends " + this.parentDictPackage() + "." + qualifiedName;
        } else {
            extendsClause = "";
        }
        return String.format("\n@Generated(\"uk.co.real_logic.artio\")\npublic %3$s%4$sclass %1$s%5$s%2$s\n{\n", className, interfaceList, isGroup ? "static " : "", this.isSharedParent() ? "abstract " : "", extendsClause);
    }

    private String completeResetMethod(Aggregate aggregate, boolean isMessage, AggregateType type) {
        String additionalReset;
        switch (type) {
            case GROUP: {
                additionalReset = RESET_NEXT_GROUP;
                break;
            }
            case HEADER: {
                additionalReset = "        beginStringAsCopy(DEFAULT_BEGIN_STRING, 0, DEFAULT_BEGIN_STRING.length);\n";
                break;
            }
            default: {
                additionalReset = "";
            }
        }
        return super.completeResetMethod(isMessage, aggregate.entries(), additionalReset, aggregate.isInParent());
    }

    private void generateGroupClass(Group group, Writer out) throws IOException {
        String className = EncoderGenerator.encoderClassName(group.name());
        this.generateAggregateClass(group, AggregateType.GROUP, className, out);
    }

    private String nextMethod(Group group) {
        return String.format("    private %1$s next = null;\n\n    public %1$s next()\n    {\n        if (next == null)\n        {\n            next = new %1$s();\n        }\n        return next;\n    }\n\n", EncoderGenerator.encoderClassName(group.name()));
    }

    private String abstractNextMethod(Group group) {
        return String.format("    public abstract %1$s next();\n\n", EncoderGenerator.encoderClassName(group.name()));
    }

    private String constructor(String className, Aggregate aggregate, AggregateType type, Dictionary dictionary) {
        if (type == AggregateType.MESSAGE) {
            Component header = dictionary.header();
            Message message = (Message)aggregate;
            long packedType = message.packedType();
            String fullType = message.fullType();
            String msgType = header.hasField("MsgType") && !this.isSharedParent() ? String.format("        header.msgType(\"%s\");\n", fullType) : "";
            return String.format("    public long messageType()\n    {\n        return %sL;\n    }\n\n    public %s()\n    {\n%s    }\n\n", packedType, className, msgType);
        }
        if (type == AggregateType.HEADER) {
            return String.format("    public %s()\n    {\n        beginStringAsCopy(DEFAULT_BEGIN_STRING, 0, DEFAULT_BEGIN_STRING.length);\n    }\n\n", className);
        }
        return "";
    }

    private void generateSetters(Writer out, String className, List<Entry> entries) throws IOException {
        List<String> optionalFields = OptionalSessionFields.ENCODER_OPTIONAL_SESSION_FIELDS.get(className);
        HashSet<String> missingOptionalFields = optionalFields == null ? Collections.emptySet() : new HashSet<String>(optionalFields);
        for (Entry entry : entries) {
            this.generateSetter(className, entry, out, missingOptionalFields);
        }
        this.generateMissingOptionalSessionFields(out, className, missingOptionalFields);
        this.generateOptionalSessionFieldsSupportedMethods(optionalFields, missingOptionalFields, out);
    }

    private void generateMissingOptionalSessionFields(Writer out, String className, Set<String> missingOptionalFields) throws IOException {
        block4: for (String optionalField : missingOptionalFields) {
            String propertyName = JavaUtil.formatPropertyName((String)optionalField);
            Field.Type type = OptionalSessionFields.OPTIONAL_FIELD_TYPES.get(optionalField);
            switch (type) {
                case STRING: {
                    this.generateMissingStringOptionalSessionFields(out, className, optionalField, propertyName);
                    continue block4;
                }
                case INT: {
                    out.append(String.format("    public %2$s %1$s(final int value)\n    {\n        throw new UnsupportedOperationException();\n    }\n", propertyName, className));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown field type for: '" + optionalField + "'");
        }
    }

    private void generateMissingStringOptionalSessionFields(Writer out, String className, String optionalField, String propertyName) throws IOException {
        out.append(String.format("    public %2$s %1$s(final DirectBuffer value, final int offset, final int length)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final DirectBuffer value, final int length)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final DirectBuffer value)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final byte[] value, final int offset, final int length)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final byte[] value, final int length)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final byte[] value)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public boolean has%3$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public String %1$sAsString()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final CharSequence value)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final AsciiSequenceView value)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final char[] value, final int offset, final int length)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final char[] value, final int length)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public %2$s %1$s(final char[] value)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public MutableDirectBuffer %1$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public void reset%3$s()\n    {\n        throw new UnsupportedOperationException();\n    }", propertyName, className, optionalField));
    }

    private void generateSetter(String className, Entry entry, Writer out, Set<String> optionalFields) {
        if (!this.isBodyLength(entry)) {
            entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> {
                optionalFields.remove(field.name());
                if (!entry.isInParent()) {
                    out.append(this.generateFieldSetter(className, (Field)field));
                }
            }), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.generateGroup(className, (Group)group, out, optionalFields)), (ResourceConsumer<Component>)((ResourceConsumer)component -> this.generateComponentField(EncoderGenerator.encoderClassName(entry.name()), (Component)component, out)), (ResourceConsumer<AnyFields>)((ResourceConsumer)anyFields -> this.generateAnyFields(entry, out)));
        }
    }

    private String generateFieldSetter(String className, Field field) {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        String hasField = String.format("    %2$s boolean has%1$s;\n\n", name, this.scope) + this.hasGetter(name);
        String javadoc = this.generateAccessorJavadoc(field);
        String hasAssign = String.format("        has%s = true;\n", name);
        String enumSetter = this.shouldGenerateClassEnumMethods(field) ? this.enumSetter(className, fieldName, EnumGenerator.enumName(field.name())) : "";
        Function<String, String> generateSetter = type -> this.generateSetter(name, (String)type, fieldName, hasField, className, hasAssign, enumSetter, javadoc);
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return this.generateStringSetter(className, fieldName, name, enumSetter, javadoc);
            }
            case BOOLEAN: {
                return generateSetter.apply("boolean");
            }
            case CHAR: {
                return generateSetter.apply("char");
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return generateSetter.apply("int");
            }
            case LONG: {
                return generateSetter.apply("long");
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return this.decimalFloatSetter(fieldName, hasField, className, hasAssign, enumSetter, javadoc);
            }
            case DATA: 
            case XMLDATA: {
                return generateSetter.apply("byte[]") + this.generateCopyingDataSetter(className, fieldName, hasAssign, javadoc);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCDATEONLY: 
            case UTCTIMEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.generateBytesSetter(className, fieldName, name, javadoc);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)field.type()));
    }

    private String generateCopyingDataSetter(String className, String fieldName, String hasAssign, String javadoc) {
        return String.format("    %4$spublic %2$s %1$sAsCopy(final byte[] value, final int offset, final int length)\n    {\n        %1$s = copyInto(%1$s, value, offset, length);\n%3$s        return this;\n    }\n\n", fieldName, className, hasAssign, javadoc);
    }

    private void generateGroup(String className, Group group, Writer out, Set<String> optionalFields) throws IOException {
        this.generateGroupClass(group, out);
        Entry numberField = group.numberField();
        boolean inParent = group.isInParent();
        if (!inParent) {
            this.generateSetter(className, numberField, out, optionalFields);
        }
        if (this.isSharedParent()) {
            out.append(String.format("\n    public abstract %1$s %2$s(final int numberOfElements);\n\n", EncoderGenerator.encoderClassName(group.name()), JavaUtil.formatPropertyName((String)group.name())));
        } else {
            out.append(String.format("\n    private %1$s %2$s = null;\n\n    public %1$s %2$s(final int numberOfElements)\n    {\n        has%3$s = true;\n        %4$s = numberOfElements;\n        if (%2$s == null)\n        {\n            %2$s = new %1$s();\n        }\n        return %2$s;\n    }\n\n", EncoderGenerator.encoderClassName(group.name()), JavaUtil.formatPropertyName((String)group.name()), numberField.name(), JavaUtil.formatPropertyName((String)numberField.name())));
        }
    }

    private String generateBytesSetter(String className, String fieldName, String name, String javadoc) {
        return String.format("    %4$s final MutableDirectBuffer %1$s = new UnsafeBuffer();\n    %4$s byte[] %1$sInternalBuffer = %1$s.byteArray();\n    %4$s int %1$sOffset = 0;\n    %4$s int %1$sLength = 0;\n\n    %5$spublic %2$s %1$s(final DirectBuffer value, final int offset, final int length)\n    {\n        %1$s.wrap(value);\n        %1$sOffset = offset;\n        %1$sLength = length;\n        return this;\n    }\n\n    %5$spublic %2$s %1$s(final DirectBuffer value, final int length)\n    {\n        return %1$s(value, 0, length);\n    }\n\n    %5$spublic %2$s %1$s(final DirectBuffer value)\n    {\n        return %1$s(value, 0, value.capacity());\n    }\n\n    %5$spublic %2$s %1$s(final byte[] value, final int offset, final int length)\n    {\n        %1$s.wrap(value);\n        %1$sOffset = offset;\n        %1$sLength = length;\n        return this;\n    }\n\n    %5$spublic %2$s %1$sAsCopy(final byte[] value, final int offset, final int length)\n    {\n        if (copyInto(%1$s, value, offset, length))\n        {\n            %1$sInternalBuffer = %1$s.byteArray();\n        }\n        %1$sOffset = 0;\n        %1$sLength = length;\n        return this;\n    }\n\n    %5$spublic %2$s %1$s(final byte[] value, final int length)\n    {\n        return %1$s(value, 0, length);\n    }\n\n    %5$spublic %2$s %1$s(final byte[] value)\n    {\n        return %1$s(value, 0, value.length);\n    }\n\n    %5$spublic boolean has%3$s()\n    {\n        return %1$sLength > 0;\n    }\n\n    %5$spublic MutableDirectBuffer %1$s()\n    {\n        return %1$s;\n    }\n\n    %5$spublic String %1$sAsString()\n    {\n        return %1$s.getStringWithoutLengthAscii(%1$sOffset, %1$sLength);\n    }\n\n", fieldName, className, name, this.scope, javadoc);
    }

    private String generateStringSetter(String className, String fieldName, String name, String enumSetter, String javadoc) {
        return String.format("%2$s    %5$spublic %3$s %1$s(final CharSequence value)\n    {\n        if (toBytes(value, %1$s))\n        {\n            %1$sInternalBuffer = %1$s.byteArray();\n        }\n        %1$sOffset = 0;\n        %1$sLength = value.length();\n        return this;\n    }\n\n    %5$spublic %3$s %1$s(final AsciiSequenceView value)\n    {\n        final DirectBuffer buffer = value.buffer();\n        if (buffer != null)\n        {\n            %1$s.wrap(buffer);\n            %1$sOffset = value.offset();\n            %1$sLength = value.length();\n        }\n        return this;\n    }\n\n    %5$spublic %3$s %1$s(final char[] value)\n    {\n        return %1$s(value, 0, value.length);\n    }\n\n    %5$spublic %3$s %1$s(final char[] value, final int length)\n    {\n        return %1$s(value, 0, length);\n    }\n\n    %5$spublic %3$s %1$s(final char[] value, final int offset, final int length)\n    {\n        if (toBytes(value, %1$s, offset, length))\n        {\n            %1$sInternalBuffer = %1$s.byteArray();\n        }\n        %1$sOffset = 0;\n        %1$sLength = length;\n        return this;\n    }\n\n%4$s", fieldName, this.generateBytesSetter(className, fieldName, name, javadoc), className, enumSetter, javadoc);
    }

    private String generateSetter(String name, String type, String fieldName, String optionalField, String className, String optionalAssign, String enumSetter, String javadoc) {
        return String.format("    %1$s %2$s %3$s;\n\n%4$s    %8$spublic %5$s %3$s(%2$s value)\n    {\n        %3$s = value;\n%6$s        return this;\n    }\n\n    %8$spublic %2$s %3$s()\n    {\n        return %3$s;\n    }\n\n%7$s", this.isBodyLength(name) ? "public" : this.scope, type, fieldName, optionalField, className, optionalAssign, enumSetter, javadoc);
    }

    private String decimalFloatSetter(String fieldName, String optionalField, String className, String optionalAssign, String enumSetter, String javadoc) {
        return String.format("    %6$s final DecimalFloat %1$s = new DecimalFloat();\n\n%2$s    %7$spublic %3$s %1$s(ReadOnlyDecimalFloat value)\n    {\n        %1$s.set(value);\n%4$s        return this;\n    }\n\n    %7$spublic %3$s %1$s(long value, int scale)\n    {\n        %1$s.set(value, scale);\n%4$s        return this;\n    }\n\n    %7$spublic DecimalFloat %1$s()\n    {\n        return %1$s;\n    }\n\n%5$s", fieldName, optionalField, className, optionalAssign, enumSetter, this.scope, javadoc);
    }

    private String enumSetter(String className, String fieldName, String enumType) {
        return String.format("    public %1$s %2$s(%3$s value)\n    {\n        if (CODEC_VALIDATION_ENABLED)\n        {\n            if (value == %3$s.ARTIO_UNKNOWN)\n            {\n                throw new EncodingException(\"Invalid Value Field: " + fieldName + " Value: \" + value );\n            }\n            if (value == %3$s.NULL_VAL)\n            {\n                return this;\n            }\n        }\n        return %2$s(value.representation());\n    }\n\n", className, fieldName, enumType);
    }

    private String encodeMethod(List<Entry> entries, AggregateType aggregateType) {
        String suffix;
        String prefix;
        if (this.isSharedParent()) {
            return "";
        }
        switch (aggregateType) {
            case TRAILER: {
                prefix = TRAILER_ENCODE_PREFIX;
                break;
            }
            case GROUP: {
                prefix = GROUP_ENCODE_PREFIX;
                break;
            }
            case MESSAGE: {
                prefix = MESSAGE_ENCODE_PREFIX;
                break;
            }
            case HEADER: {
                prefix = HEADER_ENCODE_PREFIX;
                break;
            }
            default: {
                prefix = OTHER_ENCODE_PREFIX;
            }
        }
        String body = entries.stream().map(this::encodeEntry).collect(Collectors.joining("\n"));
        if (aggregateType == AggregateType.MESSAGE) {
            suffix = "        position += trailer.startTrailer(buffer, position);\n\n        final int messageStart = header.finishHeader(buffer, bodyStart, position - bodyStart);\n        return trailer.finishMessage(buffer, messageStart, position);\n    }\n\n";
        } else if (aggregateType == AggregateType.HEADER) {
            suffix = "\n        return Encoder.result(position - start, start);\n    }\n\n";
        } else if (aggregateType == AggregateType.TRAILER) {
            suffix = "        return position - start;\n    }\n\n";
        } else {
            suffix = "        return position - offset;\n    }\n\n";
            if (aggregateType == AggregateType.GROUP) {
                suffix = "        if (next != null)\n        {\n            position += next.encode(buffer, position, remainingElements - 1);\n        }\n" + suffix;
            }
        }
        return prefix + body + suffix;
    }

    private String encodeEntry(Entry entry) {
        if (this.isBodyLength(entry) || this.isBeginString(entry) || this.isCheckSum(entry)) {
            return "";
        }
        return entry.matchEntry(this::encodeField, this::encodeGroup, this::encodeComponent, this::encodeAnyFields);
    }

    private String encodeField(Entry entry) {
        boolean needsIndent;
        String enablingPrefix;
        boolean needsMissingThrow;
        Entry.Element element = entry.element();
        Field field = (Field)element;
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        boolean mustCheckFlag = this.hasFlag(entry, field);
        boolean mustCheckLength = type.hasLengthField(false);
        boolean bl = needsMissingThrow = (mustCheckFlag || mustCheckLength) && entry.required() && !"MsgSeqNum".equals(name);
        if (mustCheckFlag) {
            enablingPrefix = String.format("        if (has%s)\n        {\n", name);
            needsIndent = true;
        } else if (mustCheckLength) {
            enablingPrefix = String.format("        if (%sLength > 0)\n        {\n", fieldName);
            needsIndent = true;
        } else {
            enablingPrefix = "";
            needsIndent = false;
        }
        String enablingSuffix = this.enablingSuffix(name, mustCheckFlag, mustCheckLength, needsMissingThrow);
        String tag = this.formatTag(fieldName, enablingPrefix);
        String indent = this.indent(needsIndent);
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return this.putValue(fieldName, tag, "Int", enablingSuffix, indent);
            }
            case LONG: {
                return this.putValue(fieldName, tag, "Long", enablingSuffix, indent);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return this.putValue(fieldName, tag, "Float", enablingSuffix, indent);
            }
            case CHAR: {
                return this.putValue(fieldName, tag, "Char", enablingSuffix, indent);
            }
            case BOOLEAN: {
                return this.putValue(fieldName, tag, "Boolean", enablingSuffix, indent);
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCDATEONLY: 
            case UTCTIMEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.encodeStringField(fieldName, enablingSuffix, tag, indent);
            }
            case DATA: 
            case XMLDATA: {
                return String.format("%1$s%4$s        buffer.putBytes(position, %2$s);\n%4$s        position += %2$s.length;\n%4$s        buffer.putSeparator(position);\n%4$s        position++;\n%3$s", tag, fieldName, enablingSuffix, indent);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private String enablingSuffix(String name, boolean mustCheckFlag, boolean mustCheckLength, boolean needsMissingThrow) {
        String enablingSuffix;
        String string = enablingSuffix = mustCheckFlag || mustCheckLength ? "        }\n" : "";
        if (needsMissingThrow) {
            enablingSuffix = enablingSuffix + "        else if (" + "CODEC_VALIDATION_ENABLED" + ")\n        {\n            throw new EncodingException(\"Missing Field: " + name + "\");\n        }\n";
        }
        return enablingSuffix;
    }

    private String encodeStringField(String fieldName, String optionalSuffix, String tag, String indent) {
        return String.format("%1$s%4$s        buffer.putBytes(position, %2$s, %2$sOffset, %2$sLength);\n%4$s        position += %2$sLength;\n%4$s        buffer.putSeparator(position);\n%4$s        position++;\n%3$s", tag, fieldName, optionalSuffix, indent);
    }

    private String encodeGroup(Entry entry) {
        Group group = (Group)entry.element();
        return String.format("%1$s\n        if (%2$s != null)\n        {\n            position += %2$s.encode(buffer, position, %3$s);\n        }\n\n", this.encodeField(group.numberField()), JavaUtil.formatPropertyName((String)group.name()), JavaUtil.formatPropertyName((String)group.numberField().name()));
    }

    private String encodeComponent(Entry entry) {
        return String.format("            position += %1$s.encode(buffer, position);\n", JavaUtil.formatPropertyName((String)entry.name()));
    }

    private void generateAnyFields(Entry entry, Writer out) throws IOException {
        if (this.isSharedParent()) {
            out.write(String.format("    public abstract FieldBagEncoder %1$s();\n\n", JavaUtil.formatPropertyName((String)entry.name())));
        } else {
            out.write(String.format("    private final FieldBagEncoder %1$s = new FieldBagEncoder();\n\n    public FieldBagEncoder %1$s()\n    {\n        return %1$s;\n    }\n\n", JavaUtil.formatPropertyName((String)entry.name())));
        }
    }

    @Override
    protected String resetAnyFields(List<Entry> entries, StringBuilder methods) {
        if (this.isSharedParent()) {
            return "";
        }
        return this.resetAllBy(entries, methods, Entry::isAnyFields, entry -> "", this::resetAnyFields);
    }

    private String resetAnyFields(Entry entry) {
        return String.format("        %1$s.reset();\n", JavaUtil.formatPropertyName((String)entry.name()));
    }

    private String encodeAnyFields(Entry entry) {
        if (this.isSharedParent()) {
            return "";
        }
        return String.format("        if (!%1$s.isEmpty())\n        {\n            position += %1$s.encode(buffer, position);\n        }\n\n", JavaUtil.formatPropertyName((String)entry.name()));
    }

    @Override
    protected String anyFieldsAppendTo(AnyFields element) {
        if (this.isSharedParent()) {
            return "";
        }
        return String.format("        if (!%1$s.isEmpty())\n        {\n            indent(builder, level);\n            builder.append(\"\\\"%2$s\\\": \\\"\");\n            %1$s.appendTo(builder);\n            builder.append(\"\\\",\\n\");\n        }\n", JavaUtil.formatPropertyName((String)element.name()), element.name());
    }

    private String anyFieldsCopyTo(AnyFields element, String encoderName) {
        if (this.isSharedParent()) {
            return "";
        }
        return String.format("        %1$s.copyTo(%2$s.%1$s());\n", JavaUtil.formatPropertyName((String)element.name()), encoderName);
    }

    private String formatTag(String fieldName, String optionalPrefix) {
        String indent = this.indent(!optionalPrefix.isEmpty());
        return String.format("%1$s%3$s        buffer.putBytes(position, %2$sHeader, 0, %2$sHeaderLength);\n%3$s        position += %2$sHeaderLength;\n", optionalPrefix, fieldName, indent);
    }

    private String indent(boolean needsIndent) {
        return needsIndent ? "    " : "";
    }

    private String putValue(String fieldName, String tag, String type, String optionalSuffix, String indent) {
        return String.format("%1$s%5$s        position += buffer.put%2$sAscii(position, %3$s);\n%5$s        buffer.putSeparator(position);\n%5$s        position++;\n%4$s", tag, type, fieldName, optionalSuffix, indent);
    }

    private void precomputedHeaders(Writer out, List<Entry> entries) throws IOException {
        for (Entry entry : entries) {
            Entry.Element element = entry.element();
            if (element instanceof Field) {
                this.precomputedFieldHeader(out, (Field)element);
                continue;
            }
            if (!(element instanceof Group)) continue;
            Group group = (Group)element;
            Entry numberFieldEntry = group.numberField();
            this.precomputedFieldHeader(out, (Field)numberFieldEntry.element());
        }
    }

    private void precomputedFieldHeader(Writer out, Field field) throws IOException {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        int length = this.string.putIntAscii(0, field.number());
        String bytes = IntStream.range(0, length).mapToObj(i -> String.valueOf(this.buffer[i])).collect(Collectors.joining(", ", "", ", (byte) '='"));
        out.append(String.format("    %4$s static final int %sHeaderLength = %d;\n    %4$s static final byte[] %1$sHeader = new byte[] {%s};\n\n", fieldName, length + 1, bytes, this.scope));
    }

    @Override
    protected String stringAppendTo(String fieldName) {
        return String.format("appendBuffer(builder, %1$s, %1$sOffset, %1$sLength)", fieldName);
    }

    @Override
    protected String timeAppendTo(String fieldName) {
        return this.stringAppendTo(fieldName);
    }

    @Override
    protected String dataAppendTo(Field field, String fieldName) {
        Field associatedLengthField = field.associatedLengthField();
        Objects.requireNonNull(associatedLengthField, "Length field for: " + fieldName);
        String lengthName = JavaUtil.formatPropertyName((String)associatedLengthField.name());
        return String.format("appendData(builder, %1$s, %2$s)", fieldName, lengthName);
    }

    @Override
    protected String componentAppendTo(Component component) {
        if (this.isSharedParent()) {
            return "";
        }
        String name = component.name();
        return String.format("    indent(builder, level);\n    builder.append(\"\\\"%1$s\\\": \");\n    %2$s.appendTo(builder, level + 1);\n    builder.append(\"\\n\");\n", name, JavaUtil.formatPropertyName((String)name));
    }

    private void generateComponentField(String className, Component element, Writer out) throws IOException {
        if (this.isSharedParent()) {
            out.append(String.format("    public abstract %1$s %2$s();\n\n", className, JavaUtil.formatPropertyName((String)element.name())));
        } else {
            out.append(String.format("    private final %1$s %2$s = new %1$s();\n    public %1$s %2$s()\n    {\n        return %2$s;\n    }\n\n", className, JavaUtil.formatPropertyName((String)element.name())));
        }
    }

    @Override
    protected String resetLength(String name) {
        return String.format("    public void %1$s()\n    {\n        %2$sLength = 0;\n        %2$s.wrap(%2$sInternalBuffer);\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name));
    }

    @Override
    protected String resetRequiredFloat(String name) {
        return this.resetByFlag(name);
    }

    @Override
    protected String resetRequiredInt(Field field) {
        return this.resetByFlag(field.name());
    }

    @Override
    protected String resetRequiredLong(Field field) {
        return this.resetByFlag(field.name());
    }

    @Override
    protected boolean hasFlag(Entry entry, Field field) {
        Field.Type type = field.type();
        return !entry.required() && !type.hasLengthField(false) || type.isFloatBased() || type.isIntBased() || type.isCharBased();
    }

    @Override
    protected String resetTemporalValue(String name) {
        return this.resetLength(name);
    }

    @Override
    protected String resetComponents(List<Entry> entries, StringBuilder methods) {
        if (this.isSharedParent()) {
            return "";
        }
        return entries.stream().filter(Entry::isComponent).map(this::callComponentReset).collect(Collectors.joining());
    }

    private String callComponentReset(Entry entry) {
        return String.format("        %1$s.reset();\n", JavaUtil.formatPropertyName((String)entry.name()));
    }

    @Override
    protected String resetStringBasedData(String name) {
        return this.resetLength(name);
    }

    @Override
    protected String groupEntryAppendTo(Group group, String name) {
        if (this.isSharedParent()) {
            return "";
        }
        Entry numberField = group.numberField();
        return String.format("        if (has%2$s)\n        {\n            indent(builder, level);\n            builder.append(\"\\\"%1$s\\\": [\\n\");\n            final int %3$s = this.%3$s;\n            %5$s %4$s = this.%4$s;\n            for (int i = 0; i < %3$s; i++)\n            {\n                indent(builder, level);\n                %4$s.appendTo(builder, level + 1);\n                if (i < (%3$s - 1))\n                {\n                    builder.append(',');\n                }\n                builder.append('\\n');\n                %4$s = %4$s.next();\n            }\n            indent(builder, level);\n            builder.append(\"],\\n\");\n        }\n", name, group.numberField().name(), JavaUtil.formatPropertyName((String)numberField.name()), JavaUtil.formatPropertyName((String)name), EncoderGenerator.encoderClassName(name));
    }

    private String generateCopyTo(Aggregate aggregate) {
        String entriesCopyTo = aggregate.entries().stream().map(this::generateEntryCopyTo).collect(Collectors.joining("\n"));
        String name = aggregate.name();
        return String.format("    public %1$s copyTo(final Encoder encoder)\n    {\n        return copyTo((%1$s)encoder);\n    }\n\n    public %1$s copyTo(final %1$s encoder)\n    {\n        encoder.reset();\n%2$s        return encoder;\n    }\n\n", EncoderGenerator.encoderClassName(name), entriesCopyTo);
    }

    private String generateEntryCopyTo(Entry entry) {
        return this.generateEntryCopyTo(entry, "encoder");
    }

    private String generateEntryCopyTo(Entry entry, String encoderName) {
        if (this.isBodyLength(entry)) {
            return "";
        }
        Entry.Element element = entry.element();
        String name = entry.name();
        if (element instanceof Field) {
            Field field = (Field)element;
            if (this.appendToChecksHasGetter(entry, field)) {
                return String.format("        if (has%1$s())\n        {\n%2$s\n        }\n", name, this.indentedFieldCopyTo(encoderName, field, "            "));
            }
            return this.indentedFieldCopyTo(encoderName, field, "        ");
        }
        if (element instanceof Group) {
            return this.groupEntryCopyTo((Group)element, name, encoderName);
        }
        if (element instanceof Component) {
            return this.componentCopyTo((Component)element, encoderName);
        }
        if (element instanceof AnyFields) {
            return this.anyFieldsCopyTo((AnyFields)element, encoderName);
        }
        return "";
    }

    private String indentedFieldCopyTo(String encoderName, Field field, String replacement) {
        String fieldCopyTo = this.fieldCopyTo(field, encoderName);
        return NEWLINE.matcher(fieldCopyTo).replaceAll(replacement);
    }

    protected String groupEntryCopyTo(Group group, String name, String encoderName) {
        if (this.isSharedParent()) {
            return "";
        }
        String numberField = group.numberField().name();
        return String.format("        if (has%1$s)\n        {\n            final int size = this.%4$s;\n            %2$s %3$s = this.%3$s;\n            %6$s %3$sEncoder = %5$s.%3$s(size);\n            for (int i = 0; i < size; i++)\n            {\n                if (%3$s != null)\n                {\n                    %3$s.copyTo(%3$sEncoder);\n                    %3$s = %3$s.next();\n                    %3$sEncoder = %3$sEncoder.next();\n                }\n            }\n        }\n", numberField, EncoderGenerator.encoderClassName(name), JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField), encoderName, EncoderGenerator.encoderClassName(name));
    }

    protected String componentCopyTo(Component component, String encoderName) {
        if (this.isSharedParent()) {
            return "";
        }
        String name = component.name();
        String varName = JavaUtil.formatPropertyName((String)name);
        return String.format("\n        %1$s.copyTo(%2$s.%1$s());", varName, encoderName);
    }

    private String fieldCopyTo(Field field, String encoderName) {
        String fieldName = JavaUtil.formatPropertyName((String)field.name());
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCDATEONLY: 
            case UTCTIMEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return String.format("%2$s.%1$sAsCopy(%1$s.byteArray(), 0, %1$sLength);", fieldName, encoderName);
            }
            case INT: 
            case BOOLEAN: 
            case CHAR: 
            case LENGTH: 
            case SEQNUM: 
            case DAYOFMONTH: 
            case LONG: 
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return String.format("%2$s.%1$s(this.%1$s());", fieldName, encoderName);
            }
            case DATA: 
            case XMLDATA: {
                String lengthName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
                return String.format("%3$s.%1$sAsCopy(this.%1$s(), 0, %2$s());%n%3$s.%2$s(%2$s());", fieldName, lengthName, encoderName);
            }
        }
        return "";
    }

    @Override
    protected String optionalReset(Field field, String name) {
        return field.type().hasLengthField(false) ? this.resetLength(name) : this.resetByFlag(name);
    }

    @Override
    protected boolean appendToChecksHasGetter(Entry entry, Field field) {
        return this.hasFlag(entry, field) || field.type().hasLengthField(false);
    }
}

