/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.storage.messages.Bool;
import uk.co.real_logic.artio.storage.messages.ConnectionBackpressureDecoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class ConnectionBackpressureEncoder {
    public static final int BLOCK_LENGTH = 17;
    public static final int TEMPLATE_ID = 34;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 11;
    public static final String SEMANTIC_VERSION = "0.1";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConnectionBackpressureEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 17;
    }

    public int sbeTemplateId() {
        return 34;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ConnectionBackpressureEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 17);
        return this;
    }

    public ConnectionBackpressureEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(17).templateId(34).schemaId(666).version(11);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int connectionIdId() {
        return 1;
    }

    public static int connectionIdSinceVersion() {
        return 0;
    }

    public static int connectionIdEncodingOffset() {
        return 0;
    }

    public static int connectionIdEncodingLength() {
        return 8;
    }

    public static String connectionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ConnectionBackpressureEncoder connectionId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sequenceNumberId() {
        return 2;
    }

    public static int sequenceNumberSinceVersion() {
        return 0;
    }

    public static int sequenceNumberEncodingOffset() {
        return 8;
    }

    public static int sequenceNumberEncodingLength() {
        return 4;
    }

    public static String sequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceNumberMinValue() {
        return -2147483647;
    }

    public static int sequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ConnectionBackpressureEncoder sequenceNumber(int value) {
        this.buffer.putInt(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int isReplayId() {
        return 3;
    }

    public static int isReplaySinceVersion() {
        return 0;
    }

    public static int isReplayEncodingOffset() {
        return 12;
    }

    public static int isReplayEncodingLength() {
        return 1;
    }

    public static String isReplayMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ConnectionBackpressureEncoder isReplay(Bool value) {
        this.buffer.putByte(this.offset + 12, (byte)value.value());
        return this;
    }

    public static int writtenId() {
        return 4;
    }

    public static int writtenSinceVersion() {
        return 0;
    }

    public static int writtenEncodingOffset() {
        return 13;
    }

    public static int writtenEncodingLength() {
        return 4;
    }

    public static String writtenMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int writtenNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int writtenMinValue() {
        return -2147483647;
    }

    public static int writtenMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ConnectionBackpressureEncoder written(int value) {
        this.buffer.putInt(this.offset + 13, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ConnectionBackpressureDecoder decoder = new ConnectionBackpressureDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 17, 11);
        return decoder.appendTo(builder);
    }
}

