/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.storage.messages.Bool;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class ConnectionBackpressureDecoder {
    public static final int BLOCK_LENGTH = 17;
    public static final int TEMPLATE_ID = 34;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 11;
    public static final String SEMANTIC_VERSION = "0.1";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConnectionBackpressureDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 17;
    }

    public int sbeTemplateId() {
        return 34;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ConnectionBackpressureDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ConnectionBackpressureDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (34 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ConnectionBackpressureDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int connectionIdId() {
        return 1;
    }

    public static int connectionIdSinceVersion() {
        return 0;
    }

    public static int connectionIdEncodingOffset() {
        return 0;
    }

    public static int connectionIdEncodingLength() {
        return 8;
    }

    public static String connectionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long connectionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sequenceNumberId() {
        return 2;
    }

    public static int sequenceNumberSinceVersion() {
        return 0;
    }

    public static int sequenceNumberEncodingOffset() {
        return 8;
    }

    public static int sequenceNumberEncodingLength() {
        return 4;
    }

    public static String sequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceNumberMinValue() {
        return -2147483647;
    }

    public static int sequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sequenceNumber() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int isReplayId() {
        return 3;
    }

    public static int isReplaySinceVersion() {
        return 0;
    }

    public static int isReplayEncodingOffset() {
        return 12;
    }

    public static int isReplayEncodingLength() {
        return 1;
    }

    public static String isReplayMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short isReplayRaw() {
        return (short)(this.buffer.getByte(this.offset + 12) & 0xFF);
    }

    public Bool isReplay() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 12) & 0xFF));
    }

    public static int writtenId() {
        return 4;
    }

    public static int writtenSinceVersion() {
        return 0;
    }

    public static int writtenEncodingOffset() {
        return 13;
    }

    public static int writtenEncodingLength() {
        return 4;
    }

    public static String writtenMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int writtenNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int writtenMinValue() {
        return -2147483647;
    }

    public static int writtenMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int written() {
        return this.buffer.getInt(this.offset + 13, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ConnectionBackpressureDecoder decoder = new ConnectionBackpressureDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ConnectionBackpressure](sbeTemplateId=");
        builder.append(34);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 11) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(11);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 17) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(17);
        builder.append("):");
        builder.append("connectionId=");
        builder.append(this.connectionId());
        builder.append('|');
        builder.append("sequenceNumber=");
        builder.append(this.sequenceNumber());
        builder.append('|');
        builder.append("isReplay=");
        builder.append((Object)this.isReplay());
        builder.append('|');
        builder.append("written=");
        builder.append(this.written());
        this.limit(originalLimit);
        return builder;
    }

    public ConnectionBackpressureDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

