/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.ir;

import java.util.Map;
import java.util.Objects;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;

public final class Group
extends Aggregate
implements Entry.Element {
    private final Entry numberField;

    public Group(String name, Entry numberField) {
        super(name);
        Objects.requireNonNull(numberField);
        this.numberField = numberField;
    }

    public Entry numberField() {
        return this.numberField;
    }

    public static Group of(Field field, Map<String, Field> fields) {
        String name = field.name();
        String normalisedName = name.startsWith("No") ? name.substring(2) : name;
        String fieldName = name + "GroupCounter";
        String groupName = normalisedName + "Group";
        Field numberField = new Field(field.number(), fieldName, Field.Type.NUMINGROUP);
        fields.put(numberField.name(), numberField);
        return new Group(groupName, new Entry(false, numberField));
    }

    @Override
    public String toString() {
        return "Group{numberField=" + this.numberField + super.toString();
    }
}

