/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.ir;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.agrona.Verify;
import uk.co.real_logic.artio.dictionary.ir.Entry;

public final class Field
implements Entry.Element {
    private final int number;
    private final String name;
    private boolean isInParent;
    private Type type;
    private final List<Value> values;
    private boolean hasSharedSometimesEnumClash;
    private Field associatedLengthField;

    public static Field registerField(Map<String, Field> nameToField, int number, String name, Type type) {
        Field field = new Field(number, name, type);
        nameToField.put(name, field);
        return field;
    }

    public Field(int number, String name, Type type) {
        this.number = number;
        this.name = name;
        this.type = type;
        this.values = new ArrayList<Value>();
    }

    public Type type() {
        return this.type;
    }

    public Field associatedLengthField() {
        return this.associatedLengthField;
    }

    public void associatedLengthField(Field associatedLengthField) {
        this.associatedLengthField = associatedLengthField;
    }

    public void type(Type type) {
        Verify.notNull((Object)((Object)type), (String)"type");
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    public int number() {
        return this.number;
    }

    public List<Value> values() {
        return this.values;
    }

    public Field addValue(String representation, String description) {
        this.values().add(new Value(representation, description));
        return this;
    }

    public boolean isEnum() {
        return !this.values.isEmpty();
    }

    public boolean hasSharedSometimesEnumClash() {
        return this.hasSharedSometimesEnumClash;
    }

    public void hasSharedSometimesEnumClash(boolean hasSharedSometimesEnumClash) {
        this.hasSharedSometimesEnumClash = hasSharedSometimesEnumClash;
    }

    public String toString() {
        return "Field{number=" + this.number + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", hasSharedSometimesEnumClash=" + this.hasSharedSometimesEnumClash + ", associatedLengthField=" + this.associatedLengthField + ", values=" + this.values + '}';
    }

    public boolean isInParent() {
        return this.isInParent;
    }

    public void isInParent(boolean isInParent) {
        this.isInParent = isInParent;
    }

    public static class Value {
        private final String representation;
        private final String description;
        private List<String> alternativeNames;

        public Value(String representation, String description) {
            this.representation = representation;
            this.description = description;
        }

        public String representation() {
            return this.representation;
        }

        public String description() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return Objects.equals(this.representation, value.representation) && Objects.equals(this.description, value.description);
        }

        public int hashCode() {
            int result = this.representation.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }

        public List<String> alternativeNames() {
            return this.alternativeNames;
        }

        public void alternativeNames(List<String> alternativeNames) {
            this.alternativeNames = alternativeNames;
        }

        public String toString() {
            return "Value{representation=" + this.representation + ", description='" + this.description + '\'' + ", alternativeNames='" + this.alternativeNames + '\'' + '}';
        }
    }

    public static enum Type {
        INT(false, true, false, false, false),
        LENGTH(false, true, false, false, false),
        SEQNUM(false, true, false, false, false),
        NUMINGROUP(false, true, false, false, false),
        DAYOFMONTH(false, true, false, false, false),
        LONG(false, true, false, false, false),
        FLOAT(false, false, true, false, false),
        PRICE(false, false, true, false, false),
        PRICEOFFSET(false, false, true, false, false),
        QTY(false, false, true, false, false),
        QUANTITY(false, false, true, false, false),
        PERCENTAGE(false, false, true, false, false),
        AMT(false, false, true, false, false),
        CHAR(false, false, false, false, true),
        MULTIPLECHARVALUE(true, false, false, true, false),
        STRING(true, false, false, false, false),
        MULTIPLEVALUESTRING(true, false, false, true, false),
        MULTIPLESTRINGVALUE(true, false, false, true, false),
        TENOR(true, false, false, true, false),
        CURRENCY(true, false, false, false, false),
        EXCHANGE(true, false, false, false, false),
        COUNTRY(true, false, false, false, false),
        LANGUAGE(true, false, false, false, false),
        DATA(false, false, false, false, false),
        XMLDATA(false, false, false, false, false),
        BOOLEAN(false, false, false, false, false),
        UTCTIMESTAMP(true, false, false, false, false),
        UTCTIMEONLY(true, false, false, false, false),
        UTCDATEONLY(true, false, false, false, false),
        LOCALMKTDATE(true, false, false, false, false),
        MONTHYEAR(true, false, false, false, false),
        TZTIMEONLY(true, false, false, false, false),
        TZTIMESTAMP(true, false, false, false, false);

        private final boolean isStringBased;
        private final boolean isIntBased;
        private final boolean isFloatBased;
        private final boolean isMultiValue;
        private final boolean isCharBased;

        private Type(boolean isStringBased, boolean isIntBased, boolean isFloatBased, boolean isMultiValue, boolean isCharBased) {
            this.isStringBased = isStringBased;
            this.isIntBased = isIntBased;
            this.isFloatBased = isFloatBased;
            this.isMultiValue = isMultiValue;
            this.isCharBased = isCharBased;
        }

        public boolean isStringBased() {
            return this.isStringBased;
        }

        public boolean isIntBased() {
            return this.isIntBased;
        }

        public boolean isFloatBased() {
            return this.isFloatBased;
        }

        public boolean isCharBased() {
            return this.isCharBased;
        }

        public boolean isDataBased() {
            return this == DATA || this == XMLDATA;
        }

        public boolean hasOffsetField(boolean flyweightsEnabled) {
            return this.hasLengthField(flyweightsEnabled) || flyweightsEnabled && this.isDataBased();
        }

        public boolean hasLengthField(boolean flyweightsEnabled) {
            return flyweightsEnabled ? this.isStringBased() || this.isIntBased() || this.isFloatBased() : this.isStringBased();
        }

        public boolean isMultiValue() {
            return this.isMultiValue;
        }

        public static Type lookup(String name) {
            if ("UTCDATE".equals(name)) {
                return UTCDATEONLY;
            }
            if ("STIRNG".equals(name)) {
                return STRING;
            }
            if ("MONTH-YEAR".equals(name)) {
                return MONTHYEAR;
            }
            if ("RATE".equals(name)) {
                return PRICE;
            }
            return Type.valueOf(name.trim());
        }
    }
}

