/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.agrona.collections.Int2ObjectHashMap;
import uk.co.real_logic.artio.dictionary.DictionaryParser;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.BaseType;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;

class CodecSharer {
    private static final Field CLASH_SENTINEL = new Field(-1, "SHARING_CLASH", Field.Type.INT);
    private static final Comparator<Map.Entry<String, Long>> ENUM_NAME_ORDER = Comparator.comparingLong(Map.Entry::getValue).thenComparingInt(e -> ((String)e.getKey()).length());
    private final List<Dictionary> inputDictionaries;
    private final Map<String, Field> sharedNameToField = new HashMap<String, Field>();
    private final Map<String, Field.Type> widenedFields = new HashMap<String, Field.Type>();
    private final Map<String, Group> sharedIdToGroup = new HashMap<String, Group>();
    private final Set<String> commonGroupIds = new HashSet<String>();
    private final Map<String, Component> sharedNameToComponent = new HashMap<String, Component>();

    CodecSharer(List<Dictionary> inputDictionaries) {
        this.inputDictionaries = inputDictionaries;
    }

    public void share() {
        this.findSharedFields();
        this.findSharedGroups();
        this.findSharedComponents();
        Map<String, Message> nameToSharedMessage = this.findSharedMessages();
        this.findComponentsWithSharedFieldsNotInAllDictionaries(nameToSharedMessage);
        Component header = this.findSharedComponent(Dictionary::header);
        Component trailer = this.findSharedComponent(Dictionary::trailer);
        String specType = "FIX";
        boolean majorVersion = false;
        boolean minorVersion = false;
        ArrayList<Message> messages = new ArrayList<Message>(nameToSharedMessage.values());
        Dictionary sharedDictionary = new Dictionary(messages, this.sharedNameToField, this.sharedNameToComponent, header, trailer, "FIX", 0, 0);
        this.updateRequiredEntries(sharedDictionary);
        sharedDictionary.shared(true);
        this.inputDictionaries.forEach(dict -> this.connectToSharedDictionary(sharedDictionary, (Dictionary)dict));
        this.inputDictionaries.add(sharedDictionary);
    }

    private void updateRequiredEntries(Dictionary sharedDictionary) {
        this.updateRequiredEntriesInAggregates(sharedDictionary.components().values());
        this.updateRequiredEntriesInAggregates(sharedDictionary.messages());
    }

    private void updateRequiredEntriesInAggregates(Collection<? extends Aggregate> aggregates) {
        aggregates.forEach(sharedComponent -> sharedComponent.allFieldsIncludingComponents().forEach(entry -> {
            boolean required = entry.required();
            entry.sharedChildEntries().forEach(childEntry -> childEntry.required(required));
        }));
    }

    private void findSharedGroups() {
        this.findSharedAggregates(this.sharedIdToGroup, this.commonGroupIds, dict -> Stream.concat(this.grpPairs(dict.messages()), this.grpPairs(dict.components().values())).collect(Collectors.toList()), (comp, sharedGroup) -> true, this::copyOf, this::sharedGroupId);
    }

    private String sharedGroupId(AggPath<Group> pair) {
        return pair.parents().stream().map(Aggregate::name).collect(Collectors.joining(".")) + "." + pair.agg().name();
    }

    private Stream<AggPath<Group>> grpPairs(Collection<? extends Aggregate> aggregates) {
        return aggregates.stream().flatMap(agg -> this.grpPairs((Aggregate)agg, Collections.emptyList()));
    }

    public Stream<AggPath<Group>> grpPairs(Aggregate aggregate, List<Aggregate> prefix) {
        List<Aggregate> parents = this.path(prefix, aggregate);
        return aggregate.entriesWith(ele -> ele instanceof Group).flatMap(e -> {
            Group group = (Group)e.element();
            Stream pair = Stream.of(new AggPath(parents, group, null));
            return Stream.concat(pair, this.grpPairs(group, parents));
        });
    }

    private List<Aggregate> path(List<Aggregate> prefix, Aggregate aggregate) {
        ArrayList<Aggregate> parents = new ArrayList<Aggregate>(prefix);
        parents.add(aggregate);
        return parents;
    }

    private void findSharedComponents() {
        this.findSharedAggregates(this.sharedNameToComponent, null, dict -> this.addFakeParents(dict.components().values()), (comp, sharedComp) -> true, this::copyOf, pair -> ((Component)pair.agg()).name());
    }

    private void findComponentsWithSharedFieldsNotInAllDictionaries(Map<String, Message> nameToSharedMessage) {
        Map<String, List<Message>> sharedMessageNameToMessages = this.inputDictionaries.stream().flatMap(dictionary -> dictionary.messages().stream().filter(msg -> nameToSharedMessage.containsKey(msg.name()))).collect(Collectors.groupingBy(Aggregate::name));
        Map<String, List<Component>> otherNameToComponents = this.inputDictionaries.stream().flatMap(dictionary -> dictionary.components().entrySet().stream().filter(e -> !this.sharedNameToComponent.containsKey(e.getKey()))).map(Map.Entry::getValue).collect(Collectors.groupingBy(Aggregate::name));
        otherNameToComponents.forEach((componentName, components) -> {
            Set<String> sharedFieldNames = this.findFieldsInAllInstancesOfComponent((List<Component>)components);
            if (sharedFieldNames.isEmpty()) {
                return;
            }
            Int2ObjectHashMap indexToSynthesizedComponent = new Int2ObjectHashMap();
            sharedMessageNameToMessages.forEach((msgName, messages) -> {
                Int2ObjectHashMap messagesWithoutComponent = new Int2ObjectHashMap();
                int withComponentCount = this.findMessagesWithoutComponent((String)componentName, (List<Message>)messages, (Int2ObjectHashMap<Message>)messagesWithoutComponent);
                if (withComponentCount > 0 && withComponentCount != messages.size()) {
                    for (Map.Entry entry : messagesWithoutComponent.entrySet()) {
                        Message message = (Message)entry.getValue();
                        List<Entry> componentFieldEntries = message.fieldEntries().filter(e -> sharedFieldNames.contains(e.name())).collect(Collectors.toList());
                        if (sharedFieldNames.size() != componentFieldEntries.size()) continue;
                        int index = (Integer)entry.getKey();
                        Component synthesizedComponent = this.lookupSynthesizedComponent((String)componentName, (Int2ObjectHashMap<Component>)indexToSynthesizedComponent, componentFieldEntries, index);
                        List<Entry> entries = message.entries();
                        entries.removeAll(componentFieldEntries);
                        entries.add(Entry.optional(synthesizedComponent));
                    }
                }
            });
            this.synthesizeParentComponent((String)componentName, sharedFieldNames, (Int2ObjectHashMap<Component>)indexToSynthesizedComponent);
        });
    }

    private void synthesizeParentComponent(String componentName, Set<String> sharedFieldNames, Int2ObjectHashMap<Component> indexToSynthesizedComponent) {
        if (!indexToSynthesizedComponent.isEmpty()) {
            Component synthesizedParentComponent = new Component(componentName);
            List<Entry> entries = synthesizedParentComponent.entries();
            for (String fieldName : sharedFieldNames) {
                entries.add(Entry.optional(this.sharedNameToField.get(fieldName)));
            }
            entries.sort(Entry.BY_NAME);
            int entrySize = entries.size();
            int i = 0;
            while (i < entrySize) {
                Entry parentEntry = entries.get(i);
                int index = i++;
                parentEntry.sharedChildEntries(indexToSynthesizedComponent.values().stream().map(comp -> comp.entries().get(index)).collect(Collectors.toList()));
            }
            this.sharedNameToComponent.put(componentName, synthesizedParentComponent);
        }
    }

    private Set<String> findFieldsInAllInstancesOfComponent(List<Component> components) {
        Component component = components.get(0);
        Set<String> sharedFieldNames = component.fieldEntries().map(Entry::name).filter(this.sharedNameToField::containsKey).collect(Collectors.toSet());
        int size = components.size();
        for (int i = 1; i < size; ++i) {
            Set fieldNames = components.get(i).fieldEntries().map(Entry::name).collect(Collectors.toSet());
            sharedFieldNames.retainAll(fieldNames);
        }
        return sharedFieldNames;
    }

    private int findMessagesWithoutComponent(String componentName, List<Message> messages, Int2ObjectHashMap<Message> messagesWithoutComponent) {
        int withComponentCount = 0;
        int messagesSize = messages.size();
        for (int i = 0; i < messagesSize; ++i) {
            Message msg = messages.get(i);
            if (msg.hasComponent(componentName)) {
                ++withComponentCount;
                continue;
            }
            messagesWithoutComponent.put(i, (Object)msg);
        }
        return withComponentCount;
    }

    private Component lookupSynthesizedComponent(String componentName, Int2ObjectHashMap<Component> indexToComponent, List<Entry> componentFieldEntries, int index) {
        Component synthesizedComponent = (Component)indexToComponent.get(index);
        if (synthesizedComponent == null) {
            synthesizedComponent = new Component(componentName);
            synthesizedComponent.isInParent(true);
            componentFieldEntries.sort(Entry.BY_NAME);
            componentFieldEntries.forEach(fieldEntry -> fieldEntry.isInParent(true));
            synthesizedComponent.entries().addAll(componentFieldEntries);
            indexToComponent.put(index, (Object)synthesizedComponent);
            this.inputDictionaries.get(index).components().put(componentName, synthesizedComponent);
        }
        return synthesizedComponent;
    }

    private Map<String, Message> findSharedMessages() {
        return this.findSharedAggregates(new HashMap(), null, dict -> this.addFakeParents(dict.messages()), (msg, sharedMessage) -> msg.packedType() == sharedMessage.packedType(), this::copyOf, pair -> ((Message)pair.agg()).name());
    }

    private <T extends Aggregate> Collection<AggPath<T>> addFakeParents(Collection<T> aggregates) {
        return aggregates.stream().map(agg -> new AggPath(Collections.emptyList(), (Aggregate)agg, null)).collect(Collectors.toList());
    }

    private <T extends Aggregate> Map<String, T> findSharedAggregates(Map<String, T> nameToAggregate, Set<String> commonAggregateNamesCopy, Function<Dictionary, Collection<AggPath<T>>> dictToAggParentPair, BiPredicate<T, T> check, CopyOf<T> copyOf, GetName<T> getName) {
        Set<String> commonAggregateNames = this.findCommonNames(dict -> this.aggregateNames((Collection)dictToAggParentPair.apply((Dictionary)dict), getName));
        if (commonAggregateNamesCopy != null) {
            commonAggregateNamesCopy.addAll(commonAggregateNames);
        }
        for (Dictionary dictionary : this.inputDictionaries) {
            dictToAggParentPair.apply(dictionary).forEach(e -> {
                Object agg = e.agg();
                String name = (String)getName.apply(e);
                if (commonAggregateNames.contains(name)) {
                    Aggregate sharedAggregate = (Aggregate)nameToAggregate.get(name);
                    if (sharedAggregate == null) {
                        Aggregate copy = (Aggregate)copyOf.apply(e.parents(), agg);
                        if (copy != null) {
                            nameToAggregate.put(name, copy);
                            ((Aggregate)agg).isInParent(true);
                        }
                    } else if (!check.test(agg, sharedAggregate)) {
                        System.err.println("Invalid types: ");
                        System.err.println(agg);
                        System.err.println(sharedAggregate);
                    } else {
                        this.mergeAggregate((Aggregate)agg, sharedAggregate);
                    }
                }
            });
        }
        this.identifyAggregateEntriesInParent(nameToAggregate, dictToAggParentPair, getName);
        return nameToAggregate;
    }

    private <T extends Aggregate> void identifyAggregateEntriesInParent(Map<String, T> nameToAggregate, Function<Dictionary, Collection<AggPath<T>>> dictToAggParentPair, GetName<T> getName) {
        this.inputDictionaries.forEach(dictionary -> ((Collection)dictToAggParentPair.apply((Dictionary)dictionary)).forEach(e -> {
            Object agg = e.agg();
            String name = (String)getName.apply(e);
            Aggregate sharedAggregate = (Aggregate)nameToAggregate.get(name);
            if (sharedAggregate != null) {
                this.identifyAggregateEntriesInParent((Aggregate)agg, sharedAggregate);
            }
        }));
    }

    private void identifyAggregateEntriesInParent(Aggregate agg, Aggregate sharedAgg) {
        sharedAgg.entries().forEach(sharedEntry -> agg.entries().forEach(entry -> {
            if (entry.name().equals(sharedEntry.name())) {
                entry.isInParent(true);
            }
        }));
    }

    private void connectToSharedDictionary(Dictionary sharedDictionary, Dictionary dict) {
        dict.sharedParent(sharedDictionary);
    }

    private void findSharedFields() {
        Set<String> commonNonEnumFieldNames = this.findCommonNonEnumFieldNames();
        Set<String> allEnumFieldNames = this.allEnumFieldNames();
        for (Dictionary dictionary : this.inputDictionaries) {
            Map<String, Field> fields = dictionary.fields();
            commonNonEnumFieldNames.forEach(fieldName -> this.mergeField(fields, (String)fieldName));
            allEnumFieldNames.forEach(enumName -> this.mergeField(fields, (String)enumName));
        }
        this.updateAssociatedLengthFields();
        this.updateFieldTypeWidening();
        this.updateSometimesEnumClashes();
        this.formUnionEnums();
    }

    private void updateAssociatedLengthFields() {
        this.sharedNameToField.values().forEach(field -> DictionaryParser.checkAssociatedLengthField(this.sharedNameToField, field, "CodecSharer"));
    }

    private void updateFieldTypeWidening() {
        this.sharedNameToField.values().removeIf(field -> field == CLASH_SENTINEL);
        this.widenedFields.forEach((name, widenedType) -> this.inputDictionaries.forEach(dict -> {
            Field field = dict.fields().get(name);
            if (field != null) {
                field.type((Field.Type)((Object)widenedType));
            }
        }));
    }

    private void updateSometimesEnumClashes() {
        this.sharedNameToField.values().forEach(sharedField -> {
            if (sharedField.hasSharedSometimesEnumClash()) {
                this.inputDictionaries.forEach(dict -> {
                    Field dictField = dict.fields().get(sharedField.name());
                    if (dictField != null) {
                        dictField.hasSharedSometimesEnumClash(true);
                    }
                });
            }
        });
    }

    private void formUnionEnums() {
        this.sharedNameToField.values().forEach(field -> {
            if (field.isEnum()) {
                List<Field.Value> fieldValues = field.values();
                Map<String, Map<String, Long>> nameToReprToCount = fieldValues.stream().collect(Collectors.groupingBy(Field.Value::description, Collectors.groupingBy(Field.Value::representation, Collectors.counting())));
                List values = nameToReprToCount.entrySet().stream().flatMap(e -> {
                    String name = (String)e.getKey();
                    Map reprToCount = (Map)e.getValue();
                    String commonRepr = this.findCommonName(reprToCount);
                    Stream<Field.Value> commonValues = LongStream.range(0L, (Long)reprToCount.get(commonRepr)).mapToObj(i -> new Field.Value(commonRepr, name));
                    HashSet otherReprs = new HashSet(reprToCount.keySet());
                    otherReprs.remove(commonRepr);
                    Stream otherValues = otherReprs.stream().flatMap(repr -> {
                        String newName = name + "_" + DictionaryParser.enumDescriptionToJavaName(repr);
                        return LongStream.range(0L, (Long)reprToCount.get(repr)).mapToObj(i -> new Field.Value((String)repr, newName));
                    });
                    return Stream.concat(commonValues, otherValues);
                }).collect(Collectors.toList());
                Map<String, Map<String, Long>> reprToNameToCount = values.stream().collect(Collectors.groupingBy(Field.Value::representation, Collectors.groupingBy(Field.Value::description, Collectors.counting())));
                List finalValues = reprToNameToCount.entrySet().stream().map(e -> {
                    String repr = (String)e.getKey();
                    Map nameToCount = (Map)e.getValue();
                    String commonName = this.findCommonName(nameToCount);
                    Field.Value value = new Field.Value(repr, commonName);
                    if (nameToCount.size() > 1) {
                        Set otherNames = nameToCount.keySet();
                        otherNames.remove(commonName);
                        value.alternativeNames(new ArrayList<String>(otherNames));
                    }
                    return value;
                }).collect(Collectors.toList());
                fieldValues.clear();
                fieldValues.addAll(finalValues);
            }
        });
    }

    private String findCommonName(Map<String, Long> nameToCount) {
        return nameToCount.entrySet().stream().max(ENUM_NAME_ORDER).get().getKey();
    }

    private void mergeField(Map<String, Field> fields, String fieldName) {
        this.sharedNameToField.compute(fieldName, (name, sharedField) -> {
            Field field = (Field)fields.get(name);
            if (field == null) {
                return sharedField;
            }
            field.isInParent(true);
            if (sharedField == null) {
                return this.copyOf(field);
            }
            Field.Type sharedType = sharedField.type();
            Field.Type type = field.type();
            BaseType sharedBaseType = BaseType.from(sharedType);
            BaseType baseType = BaseType.from(type);
            if (sharedType != type && sharedBaseType != baseType) {
                BaseType widenedBaseType = this.attemptWidenField(sharedBaseType, baseType);
                if (widenedBaseType == null) {
                    this.widenedFields.remove(name);
                    if (sharedField.isEnum()) {
                        System.err.println("Clash error for enum: " + sharedField);
                        System.out.println(field);
                    }
                    this.inputDictionaries.forEach(dict -> {
                        Field alreadySharedField = dict.fields().get(name);
                        alreadySharedField.isInParent(false);
                    });
                    return CLASH_SENTINEL;
                }
                Field.Type widenedType = BaseType.to(widenedBaseType);
                sharedField.type(widenedType);
                this.widenedFields.put((String)name, widenedType);
            }
            this.mergeEnumValues((Field)sharedField, field);
            return sharedField;
        });
    }

    private BaseType attemptWidenField(BaseType left, BaseType right) {
        BaseType widenedType = this.attemptWidenFieldOrdered(left, right);
        if (widenedType != null) {
            return widenedType;
        }
        return this.attemptWidenFieldOrdered(right, left);
    }

    private BaseType attemptWidenFieldOrdered(BaseType left, BaseType right) {
        boolean leftTimestamp;
        boolean leftChar = left == BaseType.CHAR;
        boolean leftInt = left == BaseType.INT;
        boolean bl = leftTimestamp = left == BaseType.TIMESTAMP;
        if ((leftChar || leftInt || leftTimestamp) && right == BaseType.STRING || leftChar && right == BaseType.INT) {
            return BaseType.STRING;
        }
        if (leftInt && right == BaseType.TIMESTAMP) {
            return BaseType.STRING;
        }
        return null;
    }

    private void mergeEnumValues(Field sharedField, Field field) {
        boolean isEnum;
        List<Field.Value> sharedValues = sharedField.values();
        List<Field.Value> values = field.values();
        boolean sharedIsEnum = sharedValues.isEmpty();
        if (sharedIsEnum != (isEnum = values.isEmpty())) {
            sharedField.hasSharedSometimesEnumClash(true);
        }
        sharedValues.addAll(values);
    }

    private Set<String> allEnumFieldNames() {
        return this.inputDictionaries.stream().flatMap(dict -> this.fieldNames((Dictionary)dict, true)).collect(Collectors.toSet());
    }

    private Field copyOf(Field field) {
        Field newField = new Field(field.number(), field.name(), field.type());
        newField.values().addAll(field.values());
        return newField;
    }

    private Component findSharedComponent(Function<Dictionary, Component> getter) {
        Dictionary firstDictionary = this.inputDictionaries.get(0);
        Component sharedComponent = this.copyOf(Collections.emptyList(), getter.apply(firstDictionary));
        this.inputDictionaries.forEach(dict -> {
            Component component = (Component)getter.apply((Dictionary)dict);
            this.mergeAggregate(component, sharedComponent);
        });
        this.inputDictionaries.forEach(dict -> {
            Component component = (Component)getter.apply((Dictionary)dict);
            this.identifyAggregateEntriesInParent(component, sharedComponent);
        });
        return sharedComponent;
    }

    private void mergeAggregate(Aggregate aggregate, Aggregate sharedAggregate) {
        aggregate.isInParent(true);
        Map<String, Entry> nameToEntry = this.nameToEntry(aggregate.entries());
        Iterator<Entry> it = sharedAggregate.entries().iterator();
        while (it.hasNext()) {
            Entry sharedEntry = it.next();
            if (sharedEntry.element() == null) {
                it.remove();
                continue;
            }
            Entry entry = nameToEntry.get(sharedEntry.name());
            if (entry == null) {
                it.remove();
                continue;
            }
            sharedEntry.required(sharedEntry.required() && entry.required());
            sharedEntry.sharedChildEntries().add(entry);
        }
    }

    private Set<String> findCommonNonEnumFieldNames() {
        return this.findCommonNames(dictionary -> this.fieldNames((Dictionary)dictionary, false).collect(Collectors.toSet()));
    }

    private Set<String> findCommonNames(Function<Dictionary, Set<String>> getAllNames) {
        HashSet<String> messageNames = new HashSet<String>();
        this.inputDictionaries.forEach(dict -> {
            Set namesInDictionary = (Set)getAllNames.apply((Dictionary)dict);
            if (messageNames.isEmpty()) {
                messageNames.addAll(namesInDictionary);
            } else {
                messageNames.retainAll(namesInDictionary);
            }
        });
        return messageNames;
    }

    private <T extends Aggregate> Set<String> aggregateNames(Collection<AggPath<T>> aggregates, GetName<T> getName) {
        return aggregates.stream().map(getName).collect(Collectors.toSet());
    }

    private Stream<String> fieldNames(Dictionary dictionary, boolean isEnum) {
        return dictionary.fields().entrySet().stream().filter(e -> ((Field)e.getValue()).isEnum() == isEnum).map(Map.Entry::getKey);
    }

    private Map<String, Entry> nameToEntry(List<Entry> entries) {
        return entries.stream().collect(Collectors.toMap(Entry::name, x -> x));
    }

    private Entry copyOf(List<Aggregate> parents, Entry entry) {
        String name;
        Entry.Element element = entry.element();
        if (element instanceof Field) {
            Field field = (Field)element;
            name = field.name();
            if ((element = (Entry.Element)this.sharedNameToField.get(name)) == null) {
                return null;
            }
        } else if (element instanceof Component) {
            Component component = (Component)element;
            name = component.name();
            if ((element = (Entry.Element)this.sharedNameToComponent.get(name)) == null) {
                element = this.copyOf(parents, component);
            }
        } else if (element instanceof Group) {
            Group group = (Group)element;
            String id = this.sharedGroupId(new AggPath<Group>(parents, group, null));
            Group sharedGroup = this.sharedIdToGroup.get(id);
            if (sharedGroup == null) {
                if (!this.commonGroupIds.contains(id)) {
                    return null;
                }
                sharedGroup = this.copyOf(parents, group);
                this.sharedIdToGroup.put(id, sharedGroup);
            }
            element = sharedGroup;
        } else {
            throw new IllegalArgumentException("Unknown element type: " + element);
        }
        Entry newEntry = new Entry(entry.required(), element);
        ArrayList<Entry> sharedChildEntries = new ArrayList<Entry>();
        newEntry.sharedChildEntries(sharedChildEntries);
        sharedChildEntries.add(entry);
        return newEntry;
    }

    private Component copyOf(List<Aggregate> prefix, Component component) {
        Component newComponent = new Component(component.name());
        this.copyTo(prefix, component, newComponent);
        return newComponent;
    }

    private Group copyOf(List<Aggregate> prefix, Group group) {
        Entry numberField;
        List<Aggregate> parents = this.path(prefix, group);
        Entry copiedNumberField = this.copyOf(parents, numberField = group.numberField());
        if (copiedNumberField == null) {
            return null;
        }
        Group newGroup = new Group(group.name(), copiedNumberField);
        this.copyTo(prefix, group, newGroup);
        return newGroup;
    }

    private Message copyOf(List<Aggregate> prefix, Message message) {
        Message newMessage = new Message(message.name(), message.fullType(), message.category());
        this.copyTo(prefix, message, newMessage);
        return newMessage;
    }

    private void copyTo(List<Aggregate> prefix, Aggregate aggregate, Aggregate newAggregate) {
        List<Aggregate> parents = this.path(prefix, aggregate);
        for (Entry entry : aggregate.entries()) {
            Entry newEntry = this.copyOf(parents, entry);
            if (newEntry == null) continue;
            newAggregate.entries().add(newEntry);
        }
    }

    private static final class AggPath<T extends Aggregate> {
        private final List<Aggregate> parents;
        private final T agg;

        private AggPath(List<Aggregate> parents, T agg) {
            this.parents = parents;
            this.agg = agg;
        }

        public List<Aggregate> parents() {
            return this.parents;
        }

        public T agg() {
            return this.agg;
        }

        /* synthetic */ AggPath(List x0, Aggregate x1, 1 x2) {
            this(x0, x1);
        }
    }

    static interface CopyOf<T extends Aggregate>
    extends BiFunction<List<Aggregate>, T, T> {
    }

    static interface GetName<T extends Aggregate>
    extends Function<AggPath<T>, String> {
    }
}

