/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.fields.ReadOnlyDecimalFloat;
import uk.co.real_logic.artio.util.PowerOf10;
import uk.co.real_logic.artio.util.float_parsing.CharSequenceCharReader;
import uk.co.real_logic.artio.util.float_parsing.DecimalFloatParser;

public final class DecimalFloat
extends ReadOnlyDecimalFloat {
    private static final int SCALE_NAN_VALUE = -128;
    private static final long VALUE_NAN_VALUE = Long.MIN_VALUE;
    private static final long VALUE_MAX_VAL = 999999999999999999L;
    private static final double VALUE_MAX_VAL_AS_DOUBLE = 1.0E18;
    private static final long VALUE_MIN_VAL = -999999999999999999L;
    private static final double VALUE_MIN_VAL_AS_DOUBLE = -1.0E18;
    private static final int SCALE_MAX_VAL = 127;
    private static final double FRACTION_LOWER_THRESHOLD = 1.0E-7;
    private static final double FRACTION_UPPER_THRESHOLD = 0.9999999;

    public DecimalFloat() {
        this(0L, 0);
    }

    public DecimalFloat(long value) {
        this(value, 0);
    }

    public DecimalFloat(long value, int scale) {
        super(value, scale);
    }

    public void reset() {
        this.value = Long.MIN_VALUE;
        this.scale = -128;
    }

    public DecimalFloat set(ReadOnlyDecimalFloat other) {
        this.value = other.value;
        this.scale = other.scale;
        return this;
    }

    public DecimalFloat fromLong(long value) {
        this.setAndNormalise(value, 0);
        return this;
    }

    public DecimalFloat set(long value, int scale) {
        this.setAndNormalise(value, scale);
        return this;
    }

    @Deprecated
    public DecimalFloat value(long value) {
        this.value = value;
        return this;
    }

    @Deprecated
    public DecimalFloat scale(int scale) {
        this.scale = scale;
        return this;
    }

    public DecimalFloat negate() {
        this.value *= -1L;
        return this;
    }

    public DecimalFloat copy() {
        return new DecimalFloat(this.value, this.scale);
    }

    public ReadOnlyDecimalFloat immutableCopy() {
        return this.isNaNValue() ? NAN : new ReadOnlyDecimalFloat(this.value, this.scale);
    }

    public boolean fromDouble(double doubleValue) {
        if (Double.isNaN(doubleValue)) {
            this.value = Long.MIN_VALUE;
            this.scale = -128;
            return true;
        }
        if (!Double.isFinite(doubleValue) || DecimalFloat.isOutsideLimits(doubleValue, -1.0E18, 1.0E18)) {
            return false;
        }
        if (doubleValue == 0.0) {
            this.value = 0L;
            this.scale = 0;
            return true;
        }
        boolean isNegative = doubleValue < 0.0;
        double remainingValue = Math.abs(doubleValue);
        long newValue = (long)remainingValue;
        if (DecimalFloat.isOutsideLimits(newValue, -999999999999999999L, 999999999999999999L)) {
            return false;
        }
        int newScale = 0;
        if ((remainingValue -= (double)newValue) == 0.0) {
            this.setAndNormalise(DecimalFloat.signedValue(isNegative, newValue), newScale);
            return true;
        }
        while (DecimalFloat.canValueAcceptMoreDigits(newValue, newScale) && (newValue == 0L || !DecimalFloat.isOutsideLimits(remainingValue, 1.0E-7, 0.9999999))) {
            double digit = Math.floor(remainingValue *= 10.0);
            remainingValue -= digit;
            newValue = newValue * 10L + (long)digit;
            ++newScale;
        }
        if (0.9999999 < remainingValue) {
            ++newValue;
        }
        this.setAndNormalise(DecimalFloat.signedValue(isNegative, newValue), newScale);
        return true;
    }

    public DecimalFloat fromString(CharSequence string) {
        return this.fromString(string, 0, string.length());
    }

    public DecimalFloat fromString(CharSequence string, int start, int length) {
        return DecimalFloatParser.extract(this, CharSequenceCharReader.INSTANCE, string, start, length);
    }

    public static DecimalFloat newNaNValue() {
        return ReadOnlyDecimalFloat.NAN.mutableCopy();
    }

    private static boolean canValueAcceptMoreDigits(long value, int scale) {
        return value <= PowerOf10.POWERS_OF_TEN[17] && scale < 127;
    }

    private static boolean isOutsideLimits(long value, long lowerBound, long upperBound) {
        return value < lowerBound || upperBound < value;
    }

    private static boolean isOutsideLimits(double value, double lowerBound, double upperBound) {
        return value < lowerBound || upperBound < value;
    }

    private static long signedValue(boolean isNegative, long value) {
        return isNegative ? -value : value;
    }
}

