/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.InitiateConnectionDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.ResetSequenceNumber;
import uk.co.real_logic.artio.messages.SequenceNumberType;

public final class InitiateConnectionEncoder {
    public static final int BLOCK_LENGTH = 37;
    public static final int TEMPLATE_ID = 11;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 23;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final InitiateConnectionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 37;
    }

    public int sbeTemplateId() {
        return 11;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 23;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public InitiateConnectionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 37);
        return this;
    }

    public InitiateConnectionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(37).templateId(11).schemaId(666).version(23);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public InitiateConnectionEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int requestedInitialReceivedSequenceNumberId() {
        return 2;
    }

    public static int requestedInitialReceivedSequenceNumberSinceVersion() {
        return 0;
    }

    public static int requestedInitialReceivedSequenceNumberEncodingOffset() {
        return 4;
    }

    public static int requestedInitialReceivedSequenceNumberEncodingLength() {
        return 4;
    }

    public static String requestedInitialReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int requestedInitialReceivedSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestedInitialReceivedSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int requestedInitialReceivedSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public InitiateConnectionEncoder requestedInitialReceivedSequenceNumber(int value) {
        this.buffer.putInt(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sequenceNumberTypeId() {
        return 3;
    }

    public static int sequenceNumberTypeSinceVersion() {
        return 0;
    }

    public static int sequenceNumberTypeEncodingOffset() {
        return 8;
    }

    public static int sequenceNumberTypeEncodingLength() {
        return 1;
    }

    public static String sequenceNumberTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public InitiateConnectionEncoder sequenceNumberType(SequenceNumberType value) {
        this.buffer.putByte(this.offset + 8, (byte)value.value());
        return this;
    }

    public static int portId() {
        return 4;
    }

    public static int portSinceVersion() {
        return 0;
    }

    public static int portEncodingOffset() {
        return 9;
    }

    public static int portEncodingLength() {
        return 4;
    }

    public static String portMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int portNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int portMinValue() {
        return -2147483647;
    }

    public static int portMaxValue() {
        return Integer.MAX_VALUE;
    }

    public InitiateConnectionEncoder port(int value) {
        this.buffer.putInt(this.offset + 9, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int heartbeatIntervalInSId() {
        return 5;
    }

    public static int heartbeatIntervalInSSinceVersion() {
        return 0;
    }

    public static int heartbeatIntervalInSEncodingOffset() {
        return 13;
    }

    public static int heartbeatIntervalInSEncodingLength() {
        return 4;
    }

    public static String heartbeatIntervalInSMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int heartbeatIntervalInSNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int heartbeatIntervalInSMinValue() {
        return -2147483647;
    }

    public static int heartbeatIntervalInSMaxValue() {
        return Integer.MAX_VALUE;
    }

    public InitiateConnectionEncoder heartbeatIntervalInS(int value) {
        this.buffer.putInt(this.offset + 13, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int resetSequenceNumberId() {
        return 6;
    }

    public static int resetSequenceNumberSinceVersion() {
        return 0;
    }

    public static int resetSequenceNumberEncodingOffset() {
        return 17;
    }

    public static int resetSequenceNumberEncodingLength() {
        return 1;
    }

    public static String resetSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public InitiateConnectionEncoder resetSequenceNumber(ResetSequenceNumber value) {
        this.buffer.putByte(this.offset + 17, (byte)value.value());
        return this;
    }

    public static int correlationIdId() {
        return 7;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 18;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public InitiateConnectionEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 18, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int requestedInitialSentSequenceNumberId() {
        return 17;
    }

    public static int requestedInitialSentSequenceNumberSinceVersion() {
        return 0;
    }

    public static int requestedInitialSentSequenceNumberEncodingOffset() {
        return 26;
    }

    public static int requestedInitialSentSequenceNumberEncodingLength() {
        return 4;
    }

    public static String requestedInitialSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int requestedInitialSentSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestedInitialSentSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int requestedInitialSentSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public InitiateConnectionEncoder requestedInitialSentSequenceNumber(int value) {
        this.buffer.putInt(this.offset + 26, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int closedResendIntervalId() {
        return 18;
    }

    public static int closedResendIntervalSinceVersion() {
        return 0;
    }

    public static int closedResendIntervalEncodingOffset() {
        return 30;
    }

    public static int closedResendIntervalEncodingLength() {
        return 1;
    }

    public static String closedResendIntervalMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public InitiateConnectionEncoder closedResendInterval(Bool value) {
        this.buffer.putByte(this.offset + 30, (byte)value.value());
        return this;
    }

    public static int resendRequestChunkSizeId() {
        return 19;
    }

    public static int resendRequestChunkSizeSinceVersion() {
        return 0;
    }

    public static int resendRequestChunkSizeEncodingOffset() {
        return 31;
    }

    public static int resendRequestChunkSizeEncodingLength() {
        return 4;
    }

    public static String resendRequestChunkSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int resendRequestChunkSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int resendRequestChunkSizeMinValue() {
        return -2147483647;
    }

    public static int resendRequestChunkSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public InitiateConnectionEncoder resendRequestChunkSize(int value) {
        this.buffer.putInt(this.offset + 31, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sendRedundantResendRequestsId() {
        return 20;
    }

    public static int sendRedundantResendRequestsSinceVersion() {
        return 0;
    }

    public static int sendRedundantResendRequestsEncodingOffset() {
        return 35;
    }

    public static int sendRedundantResendRequestsEncodingLength() {
        return 1;
    }

    public static String sendRedundantResendRequestsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public InitiateConnectionEncoder sendRedundantResendRequests(Bool value) {
        this.buffer.putByte(this.offset + 35, (byte)value.value());
        return this;
    }

    public static int enableLastMsgSeqNumProcessedId() {
        return 21;
    }

    public static int enableLastMsgSeqNumProcessedSinceVersion() {
        return 0;
    }

    public static int enableLastMsgSeqNumProcessedEncodingOffset() {
        return 36;
    }

    public static int enableLastMsgSeqNumProcessedEncodingLength() {
        return 1;
    }

    public static String enableLastMsgSeqNumProcessedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public InitiateConnectionEncoder enableLastMsgSeqNumProcessed(Bool value) {
        this.buffer.putByte(this.offset + 36, (byte)value.value());
        return this;
    }

    public static int hostId() {
        return 8;
    }

    public static String hostCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String hostMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int hostHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putHost(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putHost(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder host(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int senderCompIdId() {
        return 9;
    }

    public static String senderCompIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String senderCompIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int senderCompIdHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putSenderCompId(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putSenderCompId(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder senderCompId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int senderSubIdId() {
        return 10;
    }

    public static String senderSubIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String senderSubIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int senderSubIdHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putSenderSubId(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putSenderSubId(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder senderSubId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int senderLocationIdId() {
        return 11;
    }

    public static String senderLocationIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String senderLocationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int senderLocationIdHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putSenderLocationId(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putSenderLocationId(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder senderLocationId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int targetCompIdId() {
        return 12;
    }

    public static String targetCompIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String targetCompIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int targetCompIdHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putTargetCompId(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putTargetCompId(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder targetCompId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int targetSubIdId() {
        return 13;
    }

    public static String targetSubIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String targetSubIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int targetSubIdHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putTargetSubId(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putTargetSubId(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder targetSubId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int targetLocationIdId() {
        return 14;
    }

    public static String targetLocationIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String targetLocationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int targetLocationIdHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putTargetLocationId(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putTargetLocationId(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder targetLocationId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int usernameId() {
        return 15;
    }

    public static String usernameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String usernameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int usernameHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putUsername(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putUsername(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder username(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int passwordId() {
        return 16;
    }

    public static String passwordCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String passwordMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int passwordHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putPassword(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putPassword(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder password(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int fixDictionaryId() {
        return 22;
    }

    public static String fixDictionaryCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String fixDictionaryMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int fixDictionaryHeaderLength() {
        return 2;
    }

    public InitiateConnectionEncoder putFixDictionary(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder putFixDictionary(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InitiateConnectionEncoder fixDictionary(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        InitiateConnectionDecoder decoder = new InitiateConnectionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 37, 23);
        return decoder.appendTo(builder);
    }
}

