/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import org.agrona.DirectBuffer;

public class BufferAsciiSequence
implements CharSequence {
    private DirectBuffer buffer;
    private int offset;
    private int length;

    public BufferAsciiSequence wrap(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        return this;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return (char)this.buffer.getByte(index + this.offset);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < 0 || end > this.length || start > end) {
            throw new IllegalArgumentException(String.format("start = %d, end = %d, length = %d", start, end, this.length));
        }
        return new BufferAsciiSequence().wrap(this.buffer, this.offset + start, end - start);
    }

    @Override
    public String toString() {
        return this.buffer.getStringWithoutLengthUtf8(this.offset, this.length);
    }
}

