/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class ThrottleRejectDecoder {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 71;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 23;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ThrottleRejectDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 71;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 23;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ThrottleRejectDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ThrottleRejectDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (71 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ThrottleRejectDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int connectionId() {
        return 2;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 4;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long connection() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int refMsgTypeId() {
        return 3;
    }

    public static int refMsgTypeSinceVersion() {
        return 0;
    }

    public static int refMsgTypeEncodingOffset() {
        return 12;
    }

    public static int refMsgTypeEncodingLength() {
        return 8;
    }

    public static String refMsgTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long refMsgTypeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long refMsgTypeMinValue() {
        return -9223372036854775807L;
    }

    public static long refMsgTypeMaxValue() {
        return Long.MAX_VALUE;
    }

    public long refMsgType() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int refSeqNumId() {
        return 4;
    }

    public static int refSeqNumSinceVersion() {
        return 0;
    }

    public static int refSeqNumEncodingOffset() {
        return 20;
    }

    public static int refSeqNumEncodingLength() {
        return 4;
    }

    public static String refSeqNumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int refSeqNumNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int refSeqNumMinValue() {
        return -2147483647;
    }

    public static int refSeqNumMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int refSeqNum() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sequenceNumberId() {
        return 5;
    }

    public static int sequenceNumberSinceVersion() {
        return 0;
    }

    public static int sequenceNumberEncodingOffset() {
        return 24;
    }

    public static int sequenceNumberEncodingLength() {
        return 4;
    }

    public static String sequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceNumberMinValue() {
        return -2147483647;
    }

    public static int sequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sequenceNumber() {
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionId() {
        return 6;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 28;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long session() {
        return this.buffer.getLong(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sequenceIndexId() {
        return 7;
    }

    public static int sequenceIndexSinceVersion() {
        return 0;
    }

    public static int sequenceIndexEncodingOffset() {
        return 36;
    }

    public static int sequenceIndexEncodingLength() {
        return 4;
    }

    public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceIndexMinValue() {
        return -2147483647;
    }

    public static int sequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sequenceIndex() {
        return this.buffer.getInt(this.offset + 36, ByteOrder.LITTLE_ENDIAN);
    }

    public static int businessRejectRefIDId() {
        return 8;
    }

    public static int businessRejectRefIDSinceVersion() {
        return 0;
    }

    public static String businessRejectRefIDCharacterEncoding() {
        return "US-ASCII";
    }

    public static String businessRejectRefIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int businessRejectRefIDHeaderLength() {
        return 4;
    }

    public int businessRejectRefIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipBusinessRejectRefID() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getBusinessRejectRefID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getBusinessRejectRefID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapBusinessRejectRefID(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String businessRejectRefID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public int getBusinessRejectRefID(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ThrottleRejectDecoder decoder = new ThrottleRejectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ThrottleReject](sbeTemplateId=");
        builder.append(71);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 23) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(23);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 40) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(40);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("connection=");
        builder.append(this.connection());
        builder.append('|');
        builder.append("refMsgType=");
        builder.append(this.refMsgType());
        builder.append('|');
        builder.append("refSeqNum=");
        builder.append(this.refSeqNum());
        builder.append('|');
        builder.append("sequenceNumber=");
        builder.append(this.sequenceNumber());
        builder.append('|');
        builder.append("session=");
        builder.append(this.session());
        builder.append('|');
        builder.append("sequenceIndex=");
        builder.append(this.sequenceIndex());
        builder.append('|');
        builder.append("businessRejectRefID=");
        builder.append('\'');
        this.getBusinessRejectRefID(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public ThrottleRejectDecoder sbeSkip() {
        this.sbeRewind();
        this.skipBusinessRejectRefID();
        return this;
    }
}

