/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.ReleaseSessionDecoder;
import uk.co.real_logic.artio.messages.SessionState;

public final class ReleaseSessionEncoder {
    public static final int BLOCK_LENGTH = 46;
    public static final int TEMPLATE_ID = 29;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 23;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ReleaseSessionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 46;
    }

    public int sbeTemplateId() {
        return 29;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 23;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ReleaseSessionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 46);
        return this;
    }

    public ReleaseSessionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(46).templateId(29).schemaId(666).version(23);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReleaseSessionEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionIdId() {
        return 2;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 4;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ReleaseSessionEncoder sessionId(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int connectionId() {
        return 3;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 12;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public ReleaseSessionEncoder connection(long value) {
        this.buffer.putLong(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdId() {
        return 4;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 20;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ReleaseSessionEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int heartbeatIntervalInMsId() {
        return 5;
    }

    public static int heartbeatIntervalInMsSinceVersion() {
        return 0;
    }

    public static int heartbeatIntervalInMsEncodingOffset() {
        return 28;
    }

    public static int heartbeatIntervalInMsEncodingLength() {
        return 8;
    }

    public static String heartbeatIntervalInMsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long heartbeatIntervalInMsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long heartbeatIntervalInMsMinValue() {
        return -9223372036854775807L;
    }

    public static long heartbeatIntervalInMsMaxValue() {
        return Long.MAX_VALUE;
    }

    public ReleaseSessionEncoder heartbeatIntervalInMs(long value) {
        this.buffer.putLong(this.offset + 28, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int stateId() {
        return 6;
    }

    public static int stateSinceVersion() {
        return 0;
    }

    public static int stateEncodingOffset() {
        return 36;
    }

    public static int stateEncodingLength() {
        return 1;
    }

    public static String stateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ReleaseSessionEncoder state(SessionState value) {
        this.buffer.putByte(this.offset + 36, (byte)value.value());
        return this;
    }

    public static int lastSentSequenceNumberId() {
        return 7;
    }

    public static int lastSentSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastSentSequenceNumberEncodingOffset() {
        return 37;
    }

    public static int lastSentSequenceNumberEncodingLength() {
        return 4;
    }

    public static String lastSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lastSentSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lastSentSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int lastSentSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReleaseSessionEncoder lastSentSequenceNumber(int value) {
        this.buffer.putInt(this.offset + 37, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int lastReceivedSequenceNumberId() {
        return 8;
    }

    public static int lastReceivedSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastReceivedSequenceNumberEncodingOffset() {
        return 41;
    }

    public static int lastReceivedSequenceNumberEncodingLength() {
        return 4;
    }

    public static String lastReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lastReceivedSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lastReceivedSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int lastReceivedSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ReleaseSessionEncoder lastReceivedSequenceNumber(int value) {
        this.buffer.putInt(this.offset + 41, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int awaitingResendId() {
        return 11;
    }

    public static int awaitingResendSinceVersion() {
        return 0;
    }

    public static int awaitingResendEncodingOffset() {
        return 45;
    }

    public static int awaitingResendEncodingLength() {
        return 1;
    }

    public static String awaitingResendMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ReleaseSessionEncoder awaitingResend(AwaitingResend value) {
        this.buffer.putByte(this.offset + 45, (byte)value.value());
        return this;
    }

    public static int usernameId() {
        return 9;
    }

    public static String usernameCharacterEncoding() {
        return "UTF-8";
    }

    public static String usernameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int usernameHeaderLength() {
        return 2;
    }

    public ReleaseSessionEncoder putUsername(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ReleaseSessionEncoder putUsername(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ReleaseSessionEncoder username(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int passwordId() {
        return 10;
    }

    public static String passwordCharacterEncoding() {
        return "UTF-8";
    }

    public static String passwordMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int passwordHeaderLength() {
        return 2;
    }

    public ReleaseSessionEncoder putPassword(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ReleaseSessionEncoder putPassword(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ReleaseSessionEncoder password(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ReleaseSessionDecoder decoder = new ReleaseSessionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 46, 23);
        return decoder.appendTo(builder);
    }
}

