/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class RequestSessionDecoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 31;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 20;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RequestSessionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 31;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 20;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RequestSessionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RequestSessionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (31 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RequestSessionDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 4;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionIdId() {
        return 3;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 12;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long sessionId() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastReceivedSequenceNumberId() {
        return 4;
    }

    public static int lastReceivedSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastReceivedSequenceNumberEncodingOffset() {
        return 20;
    }

    public static int lastReceivedSequenceNumberEncodingLength() {
        return 4;
    }

    public static String lastReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lastReceivedSequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lastReceivedSequenceNumberMinValue() {
        return -2147483647;
    }

    public static int lastReceivedSequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int lastReceivedSequenceNumber() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sequenceIndexId() {
        return 5;
    }

    public static int sequenceIndexSinceVersion() {
        return 0;
    }

    public static int sequenceIndexEncodingOffset() {
        return 24;
    }

    public static int sequenceIndexEncodingLength() {
        return 4;
    }

    public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceIndexMinValue() {
        return -2147483647;
    }

    public static int sequenceIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int sequenceIndex() {
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RequestSessionDecoder decoder = new RequestSessionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RequestSession](sbeTemplateId=");
        builder.append(31);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 20) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(20);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 28) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(28);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("lastReceivedSequenceNumber=");
        builder.append(this.lastReceivedSequenceNumber());
        builder.append('|');
        builder.append("sequenceIndex=");
        builder.append(this.sequenceIndex());
        this.limit(originalLimit);
        return builder;
    }

    public RequestSessionDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

