/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.util.Collection;
import java.util.stream.Collectors;
import org.agrona.collections.IntHashSet;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import uk.co.real_logic.artio.dictionary.generation.DecoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Field;

class ConstantGenerator {
    static final String CLASS_NAME = "Constants";
    private static final String BODY = "public class Constants\n{\n\n";
    static final String VERSION = "VERSION";
    private final Dictionary dictionary;
    private final String builderPackage;
    private final OutputManager outputManager;

    ConstantGenerator(Dictionary dictionary, String builderPackage, OutputManager outputManager) {
        this.dictionary = dictionary;
        this.builderPackage = builderPackage;
        this.outputManager = outputManager;
    }

    public void generate() {
        if (this.dictionary.shared()) {
            return;
        }
        this.outputManager.withOutput(CLASS_NAME, out -> {
            out.append(GenerationUtil.fileHeader(this.builderPackage));
            out.append(GenerationUtil.importFor(IntHashSet.class));
            out.append(GenerationUtil.importFor(CharArraySet.class));
            out.append(BODY);
            out.append(this.generateVersion());
            out.append(this.generateMessageTypes());
            out.append(this.generateFieldTags());
            out.append(this.generateAllFieldsDictionary());
            out.append("}\n");
        });
    }

    private String generateAllFieldsDictionary() {
        return this.generateFieldDictionary(this.dictionary.fields().values(), "ALL_FIELDS");
    }

    private String generateFieldDictionary(Collection<Field> fields, String name) {
        String addFields = fields.stream().map(field -> DecoderGenerator.addField(field, name, "        ")).collect(Collectors.joining());
        int hashMapSize = ConstantGenerator.sizeHashSet(fields);
        return String.format("    public static final IntHashSet %3$s = new IntHashSet(%1$d);\n    static\n    {\n%2$s    }\n\n", hashMapSize, addFields, name);
    }

    private String generateVersion() {
        return String.format("    public static String VERSION = \"%s.%d.%d\";\n    public static char[] VERSION_CHARS = VERSION.toCharArray();\n\n", this.dictionary.specType(), this.dictionary.majorVersion(), this.dictionary.minorVersion());
    }

    public static int sizeHashSet(Collection<?> objects) {
        return objects.size() * 2;
    }

    private String generateMessageTypes() {
        return this.dictionary.messages().stream().map(message -> {
            long type = message.packedType();
            String constantName = GenerationUtil.constantName(message.name()) + "_MESSAGE";
            String stringConstantName = constantName + "_AS_STR";
            return this.generateMessageTypeConstant(stringConstantName, message.fullType()) + this.generateLongConstant(constantName, type);
        }).collect(Collectors.joining());
    }

    private String generateFieldTags() {
        return this.fields().stream().map(field -> this.generateIntConstant(GenerationUtil.constantName(field.name()), field.number())).collect(Collectors.joining());
    }

    private Collection<Field> fields() {
        return this.dictionary.fields().values();
    }

    private String generateMessageTypeConstant(String stringConstantName, String messageType) {
        return String.format("    public static final String %1$s = \"%2$s\";\n", stringConstantName, messageType);
    }

    private String generateIntConstant(String name, int number) {
        return String.format("    public static final int %1$s = %2$d;\n\n", name, number);
    }

    private String generateLongConstant(String name, long number) {
        return String.format("    public static final long %1$s = %2$dL;\n\n", name, number);
    }
}

