/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import uk.co.real_logic.artio.dictionary.generation.GeneratorDictionaryConfiguration;

public final class SharedCodecConfiguration {
    private boolean splitDirectories = true;
    private final List<GeneratorDictionaryConfiguration> dictionaries = new ArrayList<GeneratorDictionaryConfiguration>();

    SharedCodecConfiguration() {
    }

    public SharedCodecConfiguration splitDirectories(boolean splitDirectories) {
        this.splitDirectories = splitDirectories;
        return this;
    }

    public SharedCodecConfiguration withDictionary(String dictionaryName, String ... fileNames) {
        if (fileNames.length == 0) {
            throw new IllegalArgumentException("Please provide file names for Dictionary");
        }
        return this.withDictionary(dictionaryName, (InputStream[])null, fileNames);
    }

    public SharedCodecConfiguration withDictionary(String dictionaryName, InputStream ... fileStreams) {
        if (fileStreams.length == 0) {
            throw new IllegalArgumentException("Please provide file names for Dictionary");
        }
        return this.withDictionary(dictionaryName, fileStreams, (String[])null);
    }

    private SharedCodecConfiguration withDictionary(String dictionaryName, InputStream[] fileStreams, String[] fileNames) {
        Objects.requireNonNull(dictionaryName);
        this.dictionaries.add(new GeneratorDictionaryConfiguration(dictionaryName, fileStreams, fileNames));
        return this;
    }

    List<GeneratorDictionaryConfiguration> dictionaries() {
        return this.dictionaries;
    }

    boolean splitDirectories() {
        return this.splitDirectories;
    }
}

