/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.AsciiSequenceView;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntHashSet;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.dictionary.SessionConstants;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

public abstract class Generator {
    public static final String MSG_TYPE = "MsgType";
    public static final String BEGIN_STRING = "BeginString";
    public static final String BODY_LENGTH = "BodyLength";
    public static final String CODEC_VALIDATION_ENABLED = "CODEC_VALIDATION_ENABLED";
    public static final String CODEC_REJECT_UNKNOWN_FIELD_ENABLED = "CODEC_REJECT_UNKNOWN_FIELD_ENABLED";
    public static final String RUNTIME_REJECT_UNKNOWN_ENUM_VALUE_PROPERTY = "CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED";
    public static final Pattern NEWLINE = Pattern.compile("^", 8);
    public static final String MESSAGE_FIELDS = "messageFields";
    private static final String COMMON_COMPOUND_IMPORTS = "import %1$s.Header%2$s;\nimport %1$s.Trailer%2$s;\n";
    protected final Dictionary dictionary;
    protected final String thisPackage;
    private final String commonPackage;
    protected final OutputManager outputManager;
    protected final Class<?> validationClass;
    protected final Class<?> rejectUnknownFieldClass;
    private final Class<?> rejectUnknownEnumValueClass;
    protected final boolean flyweightsEnabled;
    protected final String codecRejectUnknownEnumValueEnabled;
    protected final String scope;
    protected final Deque<Aggregate> aggregateStack = new ArrayDeque<Aggregate>();

    protected String commonCompoundImports(String form, boolean headerWrapsTrailer, String messageFieldsSet) {
        String headerParameter = headerWrapsTrailer ? "trailer" : "";
        return String.format("%3$s    private final Trailer%1$s trailer = new Trailer%1$s();\n\n    public Trailer%1$s trailer()\n    {\n        return trailer;\n    }\n\n    private final Header%1$s header = new Header%1$s(%2$s);\n\n    public Header%1$s header()\n    {\n        return header;\n    }\n\n", form, headerParameter, messageFieldsSet);
    }

    protected Generator(Dictionary dictionary, String thisPackage, String commonPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownFieldClass, Class<?> rejectUnknownEnumValueClass, boolean flyweightsEnabled, String codecRejectUnknownEnumValueEnabled) {
        this.dictionary = dictionary;
        this.thisPackage = thisPackage;
        this.commonPackage = commonPackage;
        this.outputManager = outputManager;
        this.validationClass = validationClass;
        this.rejectUnknownFieldClass = rejectUnknownFieldClass;
        this.rejectUnknownEnumValueClass = rejectUnknownEnumValueClass;
        this.flyweightsEnabled = flyweightsEnabled;
        this.codecRejectUnknownEnumValueEnabled = codecRejectUnknownEnumValueEnabled;
        this.scope = dictionary.shared() ? "protected" : "private";
    }

    public void generate() {
        this.generateAggregateFile(this.dictionary.header(), AggregateType.HEADER);
        this.generateAggregateFile(this.dictionary.trailer(), AggregateType.TRAILER);
        this.dictionary.components().forEach((name, component) -> this.generateAggregateFile((Aggregate)component, AggregateType.COMPONENT));
        this.dictionary.messages().forEach(msg -> this.generateAggregateFile((Aggregate)msg, AggregateType.MESSAGE));
    }

    protected abstract void generateAggregateFile(Aggregate var1, AggregateType var2);

    protected abstract Class<?> topType(AggregateType var1);

    protected void generateImports(String compoundSuffix, AggregateType type, Writer out, Class<?> ... extraImports) throws IOException {
        out.append(GenerationUtil.importFor(MutableDirectBuffer.class)).append(GenerationUtil.importFor(AsciiSequenceView.class)).append(GenerationUtil.importStaticFor(CodecUtil.class)).append(GenerationUtil.importStaticFor(SessionConstants.class)).append(GenerationUtil.importFor(this.topType(AggregateType.MESSAGE)));
        if (this.topType(AggregateType.GROUP) != this.topType(AggregateType.MESSAGE)) {
            out.append(GenerationUtil.importFor(this.topType(AggregateType.GROUP)));
        }
        out.append(type == AggregateType.MESSAGE ? String.format(COMMON_COMPOUND_IMPORTS, this.thisPackage, compoundSuffix) : "").append(GenerationUtil.importFor(DecimalFloat.class)).append(GenerationUtil.importFor(MutableAsciiBuffer.class)).append(GenerationUtil.importFor(AsciiBuffer.class)).append(GenerationUtil.importFor(LocalMktDateEncoder.class)).append(GenerationUtil.importFor(UtcTimestampEncoder.class)).append(GenerationUtil.importFor(StandardCharsets.class)).append(GenerationUtil.importFor(Arrays.class)).append(GenerationUtil.importFor(CharArraySet.class)).append(GenerationUtil.importFor(IntHashSet.class)).append(GenerationUtil.importFor(IntHashSet.IntIterator.class)).append(GenerationUtil.importFor(EncodingException.class)).append(GenerationUtil.importFor(CharArrayWrapper.class));
        for (Class<?> extraImport : extraImports) {
            out.append(GenerationUtil.importFor(extraImport));
        }
        out.append(GenerationUtil.importStaticFor(StandardCharsets.class, "US_ASCII")).append(GenerationUtil.importStaticFor(this.validationClass, CODEC_VALIDATION_ENABLED)).append(GenerationUtil.importStaticFor(this.rejectUnknownFieldClass, CODEC_REJECT_UNKNOWN_FIELD_ENABLED)).append(GenerationUtil.importStaticFor(this.rejectUnknownEnumValueClass, RUNTIME_REJECT_UNKNOWN_ENUM_VALUE_PROPERTY));
        if (!this.thisPackage.equals(this.commonPackage) && !this.commonPackage.isEmpty()) {
            out.append(GenerationUtil.importFor(this.commonPackage + ".*"));
        }
        if (this.hasParent()) {
            out.append(GenerationUtil.importFor(this.parentDictCommonPackage() + ".*"));
        }
    }

    protected String completeResetMethod(boolean isMessage, List<Entry> entries, String additionalReset, boolean isInParent) {
        StringBuilder methods = new StringBuilder();
        String resetEntries = this.resetEntries(entries, methods);
        if (isMessage) {
            String reset = this.isSharedParent() ? "" : String.format("    public void reset()\n    {\n        header.reset();\n        trailer.reset();\n        resetMessage();\n%1$s    }\n\n", additionalReset);
            String resetParent = isInParent ? "        super.resetMessage();\n" : "";
            return String.format("%1$s    public void resetMessage()\n    {\n%4$s%2$s    }\n\n%3$s", reset, resetEntries, methods, resetParent);
        }
        String resetParent = isInParent ? "        super.reset();\n" : "";
        return String.format("    public void reset()\n    {\n%4$s%1$s%2$s    }\n\n%3$s", resetEntries, this.isSharedParent() ? "" : additionalReset, methods, resetParent);
    }

    protected String resetEntries(List<Entry> entries, StringBuilder methods) {
        return this.resetFields(entries, methods) + this.resetComponents(entries, methods) + this.resetGroups(entries, methods);
    }

    private String resetFields(List<Entry> entries, StringBuilder methods) {
        return this.resetAllBy(entries, methods, entry -> entry.isField() && !entry.isInParent(), entry -> this.resetField(entry.required(), (Field)entry.element()), this::callResetMethod);
    }

    protected String resetAllBy(List<Entry> entries, StringBuilder methods, Predicate<Entry> predicate, Function<Entry, String> methodFactory, Function<Entry, String> callFactory) {
        methods.append(entries.stream().filter(predicate).map(methodFactory).collect(Collectors.joining()));
        return entries.stream().filter(predicate).map(callFactory).collect(Collectors.joining());
    }

    private String resetGroups(List<Entry> entries, StringBuilder methods) {
        return this.resetAllBy(entries, methods, Entry::isGroup, this::resetGroup, this::callResetMethod);
    }

    protected abstract String resetGroup(Entry var1);

    private String resetField(boolean isRequired, Field field) {
        String name = field.name();
        if (this.isNotResettableField(name)) {
            return "";
        }
        if (!isRequired) {
            return this.optionalReset(field, name);
        }
        switch (field.type()) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return this.resetRequiredInt(field);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return this.resetRequiredFloat(name);
            }
            case CHAR: {
                return this.resetFieldValue(field, "MISSING_CHAR");
            }
            case DATA: 
            case XMLDATA: {
                return this.resetFieldValue(field, "null");
            }
            case BOOLEAN: {
                return this.resetFieldValue(field, "false");
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return this.resetStringBasedData(name);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.resetTemporalValue(name);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)field.type()));
    }

    protected abstract String resetRequiredInt(Field var1);

    protected abstract String optionalReset(Field var1, String var2);

    protected abstract String resetTemporalValue(String var1);

    protected abstract String resetComponents(List<Entry> var1, StringBuilder var2);

    protected abstract String resetStringBasedData(String var1);

    protected String nameOfResetMethod(String name) {
        return "reset" + name;
    }

    private String callResetMethod(Entry entry) {
        if (this.isNotResettableField(entry.name())) {
            return "";
        }
        return String.format("        this.%1$s();\n", this.nameOfResetMethod(entry.name()));
    }

    protected String hasField(Entry entry) {
        String name = entry.name();
        return entry.required() ? "" : String.format("    %2$s boolean has%1$s;\n\n", name, this.scope);
    }

    protected String resetNothing(String name) {
        return String.format("    public void %1$s()\n    {\n    }\n\n", this.nameOfResetMethod(name));
    }

    private boolean isNotResettableField(String name) {
        return this.isDerivedField(name) || this.isPreCalculatedField(name);
    }

    private boolean isPreCalculatedField(String name) {
        return "MessageName".equals(name) || BEGIN_STRING.equals(name) || MSG_TYPE.equals(name);
    }

    private boolean isDerivedField(String name) {
        return this.isBodyLength(name) || this.isCheckSum(name);
    }

    protected abstract String resetRequiredFloat(String var1);

    protected String resetLength(String name) {
        return String.format("    public void %1$s()\n    {\n        %2$sLength = 0;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name));
    }

    protected String resetByFlag(String name) {
        return String.format("    public void %2$s()\n    {\n        has%1$s = false;\n    }\n\n", name, this.nameOfResetMethod(name));
    }

    protected String resetFieldValue(Field field, String resetValue) {
        String name = field.name();
        boolean hasLengthField = field.type().hasLengthField(this.flyweightsEnabled);
        String lengthReset = hasLengthField ? "        %2$sLength = 0;\n" : "";
        return String.format("    public void %1$s()\n    {\n" + lengthReset + "        %2$s = %3$s;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name), resetValue);
    }

    protected String generateAppendTo(Aggregate aggregate, boolean hasCommonCompounds) {
        String entriesToString = aggregate.entries().stream().map(this::generateEntryAppendTo).collect(Collectors.joining("\n"));
        String prefix = hasCommonCompounds && !this.isSharedParent() ? "        builder.append(\"  \\\"header\\\": \");\n        header.appendTo(builder, level + 1);\n        builder.append(\"\\n\");\n" : "";
        return String.format("    public String toString()\n    {\n        return appendTo(new StringBuilder()).toString();\n    }\n\n    public StringBuilder appendTo(final StringBuilder builder)\n    {\n        return appendTo(builder, 1);\n    }\n\n    public StringBuilder appendTo(final StringBuilder builder, final int level)\n    {\n        builder.append(\"{\\n\");        indent(builder, level);\n        builder.append(\"\\\"MessageName\\\": \\\"%1$s\\\",\\n\");\n%2$s%3$s        indent(builder, level - 1);\n        builder.append(\"}\");\n        return builder;\n    }\n\n", aggregate.name(), prefix, entriesToString);
    }

    protected String generateEntryAppendTo(Entry entry) {
        if (this.isBodyLength(entry)) {
            return "";
        }
        Entry.Element element = entry.element();
        String name = entry.name();
        if (element instanceof Field) {
            Field field = (Field)element;
            String value = this.fieldAppendTo(field);
            String fieldAppender = String.format("        indent(builder, level);\n        builder.append(\"\\\"%1$s\\\": \\\"\");\n        %2$s;\n        builder.append(\"\\\",\\n\");\n", name, value);
            if (this.appendToChecksHasGetter(entry, field)) {
                String indentedFieldAppender = NEWLINE.matcher(fieldAppender).replaceAll("    ");
                return String.format("        if (has%1$s())\n        {\n%2$s        }\n", name, indentedFieldAppender);
            }
            return fieldAppender;
        }
        if (element instanceof Group) {
            return this.groupEntryAppendTo((Group)element, name);
        }
        if (element instanceof Component) {
            return this.componentAppendTo((Component)element);
        }
        return "";
    }

    protected abstract boolean appendToChecksHasGetter(Entry var1, Field var2);

    protected abstract String groupEntryAppendTo(Group var1, String var2);

    protected abstract boolean hasFlag(Entry var1, Field var2);

    protected String hasGetter(String name) {
        return String.format("    public boolean has%s()\n    {\n        return has%1$s;\n    }\n\n", name);
    }

    protected abstract String componentAppendTo(Component var1);

    protected String fieldAppendTo(Field field) {
        String fieldName = JavaUtil.formatPropertyName((String)field.name());
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return this.stringAppendTo(fieldName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.timeAppendTo(fieldName);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                if (this.flyweightsEnabled) {
                    return String.format("this.%1$s().appendTo(builder)", fieldName);
                }
                return String.format("%1$s.appendTo(builder)", fieldName);
            }
            case DATA: 
            case XMLDATA: {
                return this.dataAppendTo(field, fieldName);
            }
        }
        if (this.flyweightsEnabled) {
            return String.format("builder.append(this.%1$s())", fieldName);
        }
        return String.format("builder.append(%1$s)", fieldName);
    }

    protected abstract String timeAppendTo(String var1);

    protected abstract String dataAppendTo(Field var1, String var2);

    protected boolean isCheckSum(Entry entry) {
        return entry != null && this.isCheckSum(entry.name());
    }

    private boolean isCheckSum(String name) {
        return "CheckSum".equals(name);
    }

    protected boolean isBodyLength(Entry entry) {
        return entry != null && this.isBodyLength(entry.name());
    }

    protected boolean isBeginString(Entry entry) {
        return entry != null && BEGIN_STRING.equals(entry.name());
    }

    protected boolean isBodyLength(String name) {
        return BODY_LENGTH.equals(name);
    }

    void generateOptionalSessionFieldsSupportedMethods(List<String> optionalFields, Set<String> missingOptionalFields, Writer out) throws IOException {
        if (optionalFields != null) {
            for (String optionalField : optionalFields) {
                boolean inDictionary = !missingOptionalFields.contains(optionalField);
                out.append(String.format("    public boolean supports%1$s()\n    {\n        return %2$s;\n    }\n\n", optionalField, inDictionary));
            }
        }
    }

    boolean isSharedParent() {
        return this.dictionary.shared();
    }

    boolean hasParent() {
        return this.dictionary.sharedParent() != null;
    }

    String parentDictPackage() {
        return this.toParentDictPackage(this.thisPackage);
    }

    String parentDictCommonPackage() {
        return this.toParentDictPackage(this.commonPackage);
    }

    private String toParentDictPackage(String whichPackage) {
        return whichPackage.replace("." + this.dictionary.name(), "");
    }

    protected abstract String stringAppendTo(String var1);

    protected String indent(int times, String suffix) {
        StringBuilder sb = new StringBuilder(times * 4 + suffix.length());
        IntStream.range(0, times).forEach(ignore -> sb.append("    "));
        sb.append(suffix);
        return sb.toString();
    }

    boolean shouldGenerateClassEnumMethods(Field field) {
        return EnumGenerator.hasEnumGenerated(field) && !field.type().isMultiValue() && !field.hasSharedSometimesEnumClash();
    }

    Aggregate currentAggregate() {
        return this.aggregateStack.peekLast();
    }

    Aggregate parentAggregate() {
        Aggregate current = this.aggregateStack.removeLast();
        Aggregate parent = this.aggregateStack.peekLast();
        this.push(current);
        return parent;
    }

    void pop() {
        this.aggregateStack.removeLast();
    }

    void push(Aggregate aggregate) {
        this.aggregateStack.addLast(aggregate);
    }

    String qualifiedAggregateStackNames(Function<Aggregate, String> toName) {
        return this.aggregateStack.stream().map(toName).collect(Collectors.joining("."));
    }
}

