/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class FixPContextWrapperDecoder {
    public static final int BLOCK_LENGTH = 4;
    public static final int TEMPLATE_ID = 32;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final FixPContextWrapperDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 4;
    }

    public int sbeTemplateId() {
        return 32;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 8;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public FixPContextWrapperDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public FixPContextWrapperDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (32 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public FixPContextWrapperDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int protocolTypeId() {
        return 1;
    }

    public static int protocolTypeSinceVersion() {
        return 0;
    }

    public static int protocolTypeEncodingOffset() {
        return 0;
    }

    public static int protocolTypeEncodingLength() {
        return 2;
    }

    public static String protocolTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int protocolTypeNullValue() {
        return 65535;
    }

    public static int protocolTypeMinValue() {
        return 0;
    }

    public static int protocolTypeMaxValue() {
        return 65534;
    }

    public int protocolType() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int contextLengthId() {
        return 2;
    }

    public static int contextLengthSinceVersion() {
        return 0;
    }

    public static int contextLengthEncodingOffset() {
        return 2;
    }

    public static int contextLengthEncodingLength() {
        return 2;
    }

    public static String contextLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int contextLengthNullValue() {
        return 65535;
    }

    public static int contextLengthMinValue() {
        return 0;
    }

    public static int contextLengthMaxValue() {
        return 65534;
    }

    public int contextLength() {
        return this.buffer.getShort(this.offset + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        FixPContextWrapperDecoder decoder = new FixPContextWrapperDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[FixPContextWrapper](sbeTemplateId=");
        builder.append(32);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 8) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(8);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 4) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(4);
        builder.append("):");
        builder.append("protocolType=");
        builder.append(this.protocolType());
        builder.append('|');
        builder.append("contextLength=");
        builder.append(this.contextLength());
        this.limit(originalLimit);
        return builder;
    }
}

