/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

class GeneratorDictionaryConfiguration {
    private String dictionaryName;
    private InputStream[] fileStreams;
    private String[] fileNames;

    GeneratorDictionaryConfiguration(String dictionaryName, InputStream[] fileStreams, String[] fileNames) {
        this.dictionaryName = dictionaryName;
        this.fileStreams = fileStreams;
        this.fileNames = fileNames;
    }

    void dictionaryName(String dictionaryName) {
        this.dictionaryName = dictionaryName;
    }

    void fileNames(String[] fileNames) {
        this.fileNames = fileNames;
    }

    void fileStreams(InputStream[] fileStreams) {
        this.fileStreams = fileStreams;
    }

    String dictionaryName() {
        return this.dictionaryName;
    }

    boolean hasStreams() {
        return this.fileStreams != null || this.fileNames != null;
    }

    InputStream[] toStreams() throws FileNotFoundException {
        if (this.fileStreams == null) {
            if (this.fileNames == null) {
                throw new IllegalArgumentException("You must provide either the fileNames or fileStream configuration options");
            }
            int n = this.fileNames.length;
            this.fileStreams = new InputStream[n];
            for (int i = 0; i < n; ++i) {
                File xmlFile = new File(this.fileNames[i]);
                if (!xmlFile.exists()) {
                    throw new IllegalArgumentException("xmlFile does not exist: " + xmlFile.getAbsolutePath());
                }
                if (!xmlFile.isFile()) {
                    throw new IllegalArgumentException(String.format("xmlFile [%s] isn't a file, are the arguments the correct way around?", xmlFile));
                }
                this.fileStreams[i] = new FileInputStream(xmlFile);
            }
        }
        return this.fileStreams;
    }
}

