/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.SequenceDecoder;
import java.util.function.LongFunction;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.logger.FixPSequenceNumberHandler;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.fixp.AbstractFixPSequenceExtractor;
import uk.co.real_logic.artio.messages.FixPMessageDecoder;

class BinaryEntryPointSequenceExtractor
extends AbstractFixPSequenceExtractor {
    private static final int LOWEST_APP_TEMPLATE_ID = 100;
    private final Long2ObjectHashMap<Info> sessionIdToInfo = new Long2ObjectHashMap();
    private final LongFunction<Info> onNewConnectionFunc = this::onNewConnection;
    private final MessageHeaderDecoder beHeader = new MessageHeaderDecoder();
    private final SequenceNumberIndexReader sequenceNumberReader;
    private final SequenceDecoder sequence = new SequenceDecoder();

    BinaryEntryPointSequenceExtractor(FixPSequenceNumberHandler handler, SequenceNumberIndexReader sequenceNumberReader) {
        super(handler);
        this.sequenceNumberReader = sequenceNumberReader;
    }

    public void onMessage(FixPMessageDecoder fixPMessage, DirectBuffer buffer, int headerOffset, int totalLength, long endPosition, int aeronSessionId, long timestamp) {
        int templateId = this.beHeader.wrap(buffer, headerOffset).templateId();
        int msgOffset = headerOffset + 8;
        long sessionId = fixPMessage.sessionId();
        if (templateId == 2) {
            this.onSequenceReset(totalLength, endPosition, aeronSessionId, sessionId, timestamp);
        } else if (templateId == 9) {
            this.sequence.wrap(buffer, msgOffset, this.beHeader.blockLength(), this.beHeader.version());
            Info info = this.lookupInfo(sessionId);
            info.lastSequenceNumber = (int)(this.sequence.nextSeqNo() - 1L);
        } else if (templateId >= 100) {
            Info info = this.lookupInfo(sessionId);
            info.lastSequenceNumber++;
            this.onSequenceNumber(totalLength, endPosition, aeronSessionId, info, timestamp);
        }
    }

    private void onSequenceReset(int totalLength, long endPosition, int aeronSessionId, long sessionId, long timestamp) {
        Info info = this.lookupInfo(sessionId);
        info.lastSequenceNumber = 0;
        this.onSequenceNumber(totalLength, endPosition, aeronSessionId, info, timestamp);
    }

    public void onRedactSequenceUpdate(long sessionId, int newSequenceNumber) {
        Info info = this.lookupInfo(sessionId);
        info.lastSequenceNumber = newSequenceNumber;
    }

    private Info lookupInfo(long sessionId) {
        return (Info)this.sessionIdToInfo.computeIfAbsent(sessionId, this.onNewConnectionFunc);
    }

    private void onSequenceNumber(int totalLength, long endPosition, int aeronSessionId, Info info, long timestamp) {
        this.handler.onSequenceNumber(info.lastSequenceNumber, info.sessionId, totalLength, endPosition, aeronSessionId, false, timestamp);
    }

    private Info onNewConnection(long sessionId) {
        int lastSequenceNumber = this.sequenceNumberReader.lastKnownSequenceNumber(sessionId);
        if (lastSequenceNumber == -1) {
            lastSequenceNumber = 0;
        }
        return new Info(sessionId, lastSequenceNumber);
    }

    static class Info {
        private final long sessionId;
        private int lastSequenceNumber;

        Info(long sessionId, int lastSequenceNumber) {
            this.sessionId = sessionId;
            this.lastSequenceNumber = lastSequenceNumber;
        }
    }
}

