/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.RatioQtyEncoder;
import b3.entrypoint.fixp.sbe.SecurityDefinitionRequestDecoder;
import b3.entrypoint.fixp.sbe.Side;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class SecurityDefinitionRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 14;
    public static final int TEMPLATE_ID = 300;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SecurityDefinitionRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final NoLegsEncoder noLegs = new NoLegsEncoder(this);

    public int sbeBlockLength() {
        return 14;
    }

    public int sbeTemplateId() {
        return 300;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SecurityDefinitionRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 14);
        return this;
    }

    public SecurityDefinitionRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(14).templateId(300).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int securityReqIDId() {
        return 320;
    }

    public static int securityReqIDSinceVersion() {
        return 0;
    }

    public static int securityReqIDEncodingOffset() {
        return 0;
    }

    public static int securityReqIDEncodingLength() {
        return 8;
    }

    public static String securityReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityReqIDNullValue() {
        return -1L;
    }

    public static long securityReqIDMinValue() {
        return 0L;
    }

    public static long securityReqIDMaxValue() {
        return -2L;
    }

    public SecurityDefinitionRequestEncoder securityReqID(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 8;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public SecurityDefinitionRequestEncoder enteringTrader(int index, byte value) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 8 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String enteringTraderCharacterEncoding() {
        return "ASCII";
    }

    public SecurityDefinitionRequestEncoder putEnteringTrader(byte[] src, int srcOffset) {
        int length = 5;
        if (srcOffset < 0 || srcOffset > src.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 8, src, srcOffset, 5);
        return this;
    }

    public SecurityDefinitionRequestEncoder enteringTrader(String src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 8, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 8 + start, (byte)0);
        }
        return this;
    }

    public SecurityDefinitionRequestEncoder enteringTrader(CharSequence src) {
        int i;
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        for (i = 0; i < srcLength; ++i) {
            char charValue = src.charAt(i);
            byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
            this.buffer.putByte(this.offset + 8 + i, byteValue);
        }
        for (i = srcLength; i < 5; ++i) {
            this.buffer.putByte(this.offset + 8 + i, (byte)0);
        }
        return this;
    }

    public static int marketSegmentIDId() {
        return 1300;
    }

    public static int marketSegmentIDSinceVersion() {
        return 0;
    }

    public static int marketSegmentIDEncodingOffset() {
        return 13;
    }

    public static int marketSegmentIDEncodingLength() {
        return 1;
    }

    public static String marketSegmentIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short marketSegmentIDNullValue() {
        return 255;
    }

    public static short marketSegmentIDMinValue() {
        return 0;
    }

    public static short marketSegmentIDMaxValue() {
        return 254;
    }

    public SecurityDefinitionRequestEncoder marketSegmentID(short value) {
        this.buffer.putByte(this.offset + 13, (byte)value);
        return this;
    }

    public static long noLegsId() {
        return 5L;
    }

    public NoLegsEncoder noLegsCount(int count) {
        this.noLegs.wrap(this.buffer, count);
        return this.noLegs;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SecurityDefinitionRequestDecoder decoder = new SecurityDefinitionRequestDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 14, 0);
        return decoder.appendTo(builder);
    }

    public static final class NoLegsEncoder {
        public static final int HEADER_SIZE = 3;
        private final SecurityDefinitionRequestEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;
        private static final byte[] LEGSECURITYIDSOURCE_VALUE = new byte[]{56};
        private static final byte[] LEGSECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
        private final RatioQtyEncoder legRatioQty = new RatioQtyEncoder();

        NoLegsEncoder(SecurityDefinitionRequestEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)17, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoLegsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoLegsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 17;
        }

        public static int legSecurityIDId() {
            return 602;
        }

        public static int legSecurityIDSinceVersion() {
            return 0;
        }

        public static int legSecurityIDEncodingOffset() {
            return 0;
        }

        public static int legSecurityIDEncodingLength() {
            return 8;
        }

        public static String legSecurityIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long legSecurityIDNullValue() {
            return -1L;
        }

        public static long legSecurityIDMinValue() {
            return 0L;
        }

        public static long legSecurityIDMaxValue() {
            return -2L;
        }

        public NoLegsEncoder legSecurityID(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int legSecurityIDSourceId() {
            return 603;
        }

        public static int legSecurityIDSourceSinceVersion() {
            return 0;
        }

        public static int legSecurityIDSourceEncodingOffset() {
            return 8;
        }

        public static int legSecurityIDSourceEncodingLength() {
            return 0;
        }

        public static String legSecurityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "constant";
            }
            return "";
        }

        public static byte legSecurityIDSourceNullValue() {
            return 0;
        }

        public static byte legSecurityIDSourceMinValue() {
            return 32;
        }

        public static byte legSecurityIDSourceMaxValue() {
            return 126;
        }

        public static int legSecurityIDSourceLength() {
            return 1;
        }

        public byte legSecurityIDSource(int index) {
            return LEGSECURITYIDSOURCE_VALUE[index];
        }

        public int getLegSecurityIDSource(byte[] dst, int offset, int length) {
            int bytesCopied = Math.min(length, 1);
            System.arraycopy(LEGSECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
            return bytesCopied;
        }

        public byte legSecurityIDSource() {
            return 56;
        }

        public static int legSecurityExchangeId() {
            return 616;
        }

        public static int legSecurityExchangeSinceVersion() {
            return 0;
        }

        public static int legSecurityExchangeEncodingOffset() {
            return 8;
        }

        public static int legSecurityExchangeEncodingLength() {
            return 0;
        }

        public static String legSecurityExchangeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "constant";
            }
            return "";
        }

        public static byte legSecurityExchangeNullValue() {
            return 0;
        }

        public static byte legSecurityExchangeMinValue() {
            return 32;
        }

        public static byte legSecurityExchangeMaxValue() {
            return 126;
        }

        public static int legSecurityExchangeLength() {
            return 4;
        }

        public byte legSecurityExchange(int index) {
            return LEGSECURITYEXCHANGE_VALUE[index];
        }

        public int getLegSecurityExchange(byte[] dst, int offset, int length) {
            int bytesCopied = Math.min(length, 4);
            System.arraycopy(LEGSECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
            return bytesCopied;
        }

        public String legSecurityExchange() {
            return "BVMF";
        }

        public static int legRatioQtyId() {
            return 623;
        }

        public static int legRatioQtySinceVersion() {
            return 0;
        }

        public static int legRatioQtyEncodingOffset() {
            return 8;
        }

        public static int legRatioQtyEncodingLength() {
            return 8;
        }

        public static String legRatioQtyMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public RatioQtyEncoder legRatioQty() {
            this.legRatioQty.wrap(this.buffer, this.offset + 8);
            return this.legRatioQty;
        }

        public static int legSideId() {
            return 624;
        }

        public static int legSideSinceVersion() {
            return 0;
        }

        public static int legSideEncodingOffset() {
            return 16;
        }

        public static int legSideEncodingLength() {
            return 1;
        }

        public static String legSideMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public NoLegsEncoder legSide(Side value) {
            this.buffer.putByte(this.offset + 16, value.value());
            return this;
        }
    }
}

