/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.Side;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class AllocationInstructionDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 5;
    public static final int TEMPLATE_ID = 601;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AllocationInstructionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final NoExecsDecoder noExecs = new NoExecsDecoder(this);
    private final NoAllocsDecoder noAllocs = new NoAllocsDecoder(this);

    public int sbeBlockLength() {
        return 5;
    }

    public int sbeTemplateId() {
        return 601;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public AllocationInstructionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public AllocationInstructionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (601 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int sideId() {
        return 54;
    }

    public static int sideSinceVersion() {
        return 0;
    }

    public static int sideEncodingOffset() {
        return 0;
    }

    public static int sideEncodingLength() {
        return 1;
    }

    public static String sideMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte sideRaw() {
        return this.buffer.getByte(this.offset + 0);
    }

    public Side side() {
        return Side.get(this.buffer.getByte(this.offset + 0));
    }

    public static int tradeDateId() {
        return 75;
    }

    public static int tradeDateSinceVersion() {
        return 0;
    }

    public static int tradeDateEncodingOffset() {
        return 1;
    }

    public static int tradeDateEncodingLength() {
        return 4;
    }

    public static String tradeDateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int tradeDateNullValue() {
        return 0;
    }

    public static int tradeDateMinValue() {
        return 0;
    }

    public static int tradeDateMaxValue() {
        return 65534;
    }

    public static int tradeDateLength() {
        return 2;
    }

    public int tradeDate(int index) {
        if (index < 0 || index >= 2) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 1 + index * 2;
        return this.buffer.getShort(pos, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static long noExecsDecoderId() {
        return 13L;
    }

    public static int noExecsDecoderSinceVersion() {
        return 0;
    }

    public NoExecsDecoder noExecs() {
        this.noExecs.wrap(this.buffer);
        return this.noExecs;
    }

    public static long noAllocsDecoderId() {
        return 15L;
    }

    public static int noAllocsDecoderSinceVersion() {
        return 0;
    }

    public NoAllocsDecoder noAllocs() {
        this.noAllocs.wrap(this.buffer);
        return this.noAllocs;
    }

    public static int deskIDId() {
        return 35510;
    }

    public static int deskIDSinceVersion() {
        return 0;
    }

    public static String deskIDCharacterEncoding() {
        return "ASCII";
    }

    public static String deskIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int deskIDHeaderLength() {
        return 1;
    }

    public int deskIDLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipDeskID() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getDeskID(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getDeskID(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapDeskID(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String deskID() {
        String value;
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        try {
            value = new String(tmp, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public int getDeskID(Appendable appendable) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, (int)dataLength, appendable);
        return dataLength;
    }

    public static int memoId() {
        return 5149;
    }

    public static int memoSinceVersion() {
        return 0;
    }

    public static String memoCharacterEncoding() {
        return "UTF-8";
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public int memoLength() {
        int limit = this.parentMessage.limit();
        return (short)(this.buffer.getByte(limit) & 0xFF);
    }

    public int skipMemo() {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int dataOffset = limit + 1;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMemo(MutableDirectBuffer dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMemo(byte[] dst, int dstOffset, int length) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 1 + dataLength);
        this.buffer.getBytes(limit + 1, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMemo(DirectBuffer wrapBuffer) {
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 1, (int)dataLength);
    }

    public String memo() {
        String value;
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        short dataLength = (short)(this.buffer.getByte(limit) & 0xFF);
        this.parentMessage.limit(limit + 1 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 1, tmp, 0, (int)dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        AllocationInstructionDecoder decoder = new AllocationInstructionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[AllocationInstruction](sbeTemplateId=");
        builder.append(601);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 5) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(5);
        builder.append("):");
        builder.append("side=");
        builder.append((Object)this.side());
        builder.append('|');
        builder.append("tradeDate=");
        builder.append('[');
        if (AllocationInstructionDecoder.tradeDateLength() > 0) {
            for (int i = 0; i < AllocationInstructionDecoder.tradeDateLength(); ++i) {
                builder.append(this.tradeDate(i));
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("noExecs=[");
        NoExecsDecoder noExecs = this.noExecs();
        if (noExecs.count() > 0) {
            while (noExecs.hasNext()) {
                noExecs.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("noAllocs=[");
        NoAllocsDecoder noAllocs = this.noAllocs();
        if (noAllocs.count() > 0) {
            while (noAllocs.hasNext()) {
                noAllocs.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("deskID=");
        builder.append('\'');
        this.getDeskID(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("memo=");
        builder.append('\'').append(this.memo()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public static final class NoAllocsDecoder
    implements Iterable<NoAllocsDecoder>,
    Iterator<NoAllocsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NoAllocsDecoder(AllocationInstructionDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NoAllocsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NoAllocsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append(')');
            return builder;
        }
    }

    public static final class NoExecsDecoder
    implements Iterable<NoExecsDecoder>,
    Iterator<NoExecsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NoExecsDecoder(AllocationInstructionDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NoExecsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NoExecsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append(')');
            return builder;
        }
    }
}

