/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.Boolean;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.SecurityDefinitionResponseDecoder;
import b3.entrypoint.fixp.sbe.SecurityResponseType;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class SecurityDefinitionResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 54;
    public static final int TEMPLATE_ID = 301;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SecurityDefinitionResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};

    public int sbeBlockLength() {
        return 54;
    }

    public int sbeTemplateId() {
        return 301;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SecurityDefinitionResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 54);
        return this;
    }

    public SecurityDefinitionResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(54).templateId(301).schemaId(1).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int securityReqIDId() {
        return 320;
    }

    public static int securityReqIDSinceVersion() {
        return 0;
    }

    public static int securityReqIDEncodingOffset() {
        return 0;
    }

    public static int securityReqIDEncodingLength() {
        return 8;
    }

    public static String securityReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityReqIDNullValue() {
        return -1L;
    }

    public static long securityReqIDMinValue() {
        return 0L;
    }

    public static long securityReqIDMaxValue() {
        return -2L;
    }

    public SecurityDefinitionResponseEncoder securityReqID(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int securityResponseIDId() {
        return 322;
    }

    public static int securityResponseIDSinceVersion() {
        return 0;
    }

    public static int securityResponseIDEncodingOffset() {
        return 8;
    }

    public static int securityResponseIDEncodingLength() {
        return 8;
    }

    public static String securityResponseIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityResponseIDNullValue() {
        return -1L;
    }

    public static long securityResponseIDMinValue() {
        return 0L;
    }

    public static long securityResponseIDMaxValue() {
        return -2L;
    }

    public SecurityDefinitionResponseEncoder securityResponseID(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int securityResponseTypeId() {
        return 323;
    }

    public static int securityResponseTypeSinceVersion() {
        return 0;
    }

    public static int securityResponseTypeEncodingOffset() {
        return 16;
    }

    public static int securityResponseTypeEncodingLength() {
        return 1;
    }

    public static String securityResponseTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public SecurityDefinitionResponseEncoder securityResponseType(SecurityResponseType value) {
        this.buffer.putByte(this.offset + 16, (byte)value.value());
        return this;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 17;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public SecurityDefinitionResponseEncoder enteringTrader(int index, byte value) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 17 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public SecurityDefinitionResponseEncoder putEnteringTrader(byte[] src, int srcOffset) {
        int length = 5;
        if (srcOffset < 0 || srcOffset > src.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 17, src, srcOffset, 5);
        return this;
    }

    public SecurityDefinitionResponseEncoder enteringTrader(String src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 17, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 17 + start, (byte)0);
        }
        return this;
    }

    public SecurityDefinitionResponseEncoder enteringTrader(CharSequence src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 17, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 17 + start, (byte)0);
        }
        return this;
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 22;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public SecurityDefinitionResponseEncoder securityID(long value) {
        this.buffer.putLong(this.offset + 22, value, BYTE_ORDER);
        return this;
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 30;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 30;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int symbolId() {
        return 55;
    }

    public static int symbolSinceVersion() {
        return 0;
    }

    public static int symbolEncodingOffset() {
        return 30;
    }

    public static int symbolEncodingLength() {
        return 20;
    }

    public static String symbolMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte symbolNullValue() {
        return 0;
    }

    public static byte symbolMinValue() {
        return 32;
    }

    public static byte symbolMaxValue() {
        return 126;
    }

    public static int symbolLength() {
        return 20;
    }

    public SecurityDefinitionResponseEncoder symbol(int index, byte value) {
        if (index < 0 || index >= 20) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 30 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String symbolCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public SecurityDefinitionResponseEncoder putSymbol(byte[] src, int srcOffset) {
        int length = 20;
        if (srcOffset < 0 || srcOffset > src.length - 20) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 30, src, srcOffset, 20);
        return this;
    }

    public SecurityDefinitionResponseEncoder symbol(String src) {
        int srcLength;
        int length = 20;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 20) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 30, src);
        for (int start = srcLength; start < 20; ++start) {
            this.buffer.putByte(this.offset + 30 + start, (byte)0);
        }
        return this;
    }

    public SecurityDefinitionResponseEncoder symbol(CharSequence src) {
        int srcLength;
        int length = 20;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 20) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 30, src);
        for (int start = srcLength; start < 20; ++start) {
            this.buffer.putByte(this.offset + 30 + start, (byte)0);
        }
        return this;
    }

    public static int securityStrategyTypeId() {
        return 7534;
    }

    public static int securityStrategyTypeSinceVersion() {
        return 0;
    }

    public static int securityStrategyTypeEncodingOffset() {
        return 50;
    }

    public static int securityStrategyTypeEncodingLength() {
        return 3;
    }

    public static String securityStrategyTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static byte securityStrategyTypeNullValue() {
        return 0;
    }

    public static byte securityStrategyTypeMinValue() {
        return 32;
    }

    public static byte securityStrategyTypeMaxValue() {
        return 126;
    }

    public static int securityStrategyTypeLength() {
        return 3;
    }

    public SecurityDefinitionResponseEncoder securityStrategyType(int index, byte value) {
        if (index < 0 || index >= 3) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 50 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public SecurityDefinitionResponseEncoder putSecurityStrategyType(byte value0, byte value1, byte value2) {
        this.buffer.putByte(this.offset + 50, value0);
        this.buffer.putByte(this.offset + 51, value1);
        this.buffer.putByte(this.offset + 52, value2);
        return this;
    }

    public static String securityStrategyTypeCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public SecurityDefinitionResponseEncoder putSecurityStrategyType(byte[] src, int srcOffset) {
        int length = 3;
        if (srcOffset < 0 || srcOffset > src.length - 3) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 50, src, srcOffset, 3);
        return this;
    }

    public SecurityDefinitionResponseEncoder securityStrategyType(String src) {
        int srcLength;
        int length = 3;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 3) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 50, src);
        for (int start = srcLength; start < 3; ++start) {
            this.buffer.putByte(this.offset + 50 + start, (byte)0);
        }
        return this;
    }

    public SecurityDefinitionResponseEncoder securityStrategyType(CharSequence src) {
        int srcLength;
        int length = 3;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 3) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 50, src);
        for (int start = srcLength; start < 3; ++start) {
            this.buffer.putByte(this.offset + 50 + start, (byte)0);
        }
        return this;
    }

    public static int possResendId() {
        return 97;
    }

    public static int possResendSinceVersion() {
        return 0;
    }

    public static int possResendEncodingOffset() {
        return 53;
    }

    public static int possResendEncodingLength() {
        return 1;
    }

    public static String possResendMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public SecurityDefinitionResponseEncoder possResend(Boolean value) {
        this.buffer.putByte(this.offset + 53, (byte)value.value());
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SecurityDefinitionResponseDecoder decoder = new SecurityDefinitionResponseDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 54, 5);
        return decoder.appendTo(builder);
    }
}

