/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.FramingHeaderEncoder;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.SimpleOpenFramingHeaderMessageDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class SimpleOpenFramingHeaderMessageEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 4;
    public static final int TEMPLATE_ID = 0;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SimpleOpenFramingHeaderMessageEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final FramingHeaderEncoder framingHeader = new FramingHeaderEncoder();

    public int sbeBlockLength() {
        return 4;
    }

    public int sbeTemplateId() {
        return 0;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SimpleOpenFramingHeaderMessageEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 4);
        return this;
    }

    public SimpleOpenFramingHeaderMessageEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(4).templateId(0).schemaId(1).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int framingHeaderId() {
        return 0;
    }

    public static int framingHeaderSinceVersion() {
        return 0;
    }

    public static int framingHeaderEncodingOffset() {
        return 0;
    }

    public static int framingHeaderEncodingLength() {
        return 4;
    }

    public static String framingHeaderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public FramingHeaderEncoder framingHeader() {
        this.framingHeader.wrap(this.buffer, this.offset + 0);
        return this.framingHeader;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SimpleOpenFramingHeaderMessageDecoder decoder = new SimpleOpenFramingHeaderMessageDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 4, 5);
        return decoder.appendTo(builder);
    }
}

