/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.FramingHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class SimpleOpenFramingHeaderMessageDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 4;
    public static final int TEMPLATE_ID = 0;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SimpleOpenFramingHeaderMessageDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final FramingHeaderDecoder framingHeader = new FramingHeaderDecoder();

    public int sbeBlockLength() {
        return 4;
    }

    public int sbeTemplateId() {
        return 0;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SimpleOpenFramingHeaderMessageDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public SimpleOpenFramingHeaderMessageDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (0 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public SimpleOpenFramingHeaderMessageDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int framingHeaderId() {
        return 0;
    }

    public static int framingHeaderSinceVersion() {
        return 0;
    }

    public static int framingHeaderEncodingOffset() {
        return 0;
    }

    public static int framingHeaderEncodingLength() {
        return 4;
    }

    public static String framingHeaderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public FramingHeaderDecoder framingHeader() {
        this.framingHeader.wrap(this.buffer, this.offset + 0);
        return this.framingHeader;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SimpleOpenFramingHeaderMessageDecoder decoder = new SimpleOpenFramingHeaderMessageDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SimpleOpenFramingHeaderMessage](sbeTemplateId=");
        builder.append(0);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 4) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(4);
        builder.append("):");
        builder.append("framingHeader=");
        FramingHeaderDecoder framingHeader = this.framingHeader();
        if (framingHeader != null) {
            framingHeader.appendTo(builder);
        } else {
            builder.append("null");
        }
        this.limit(originalLimit);
        return builder;
    }

    public SimpleOpenFramingHeaderMessageDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

